/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationVariable;

public class BaSyxOperation
extends BaSyxSubmodelElement
implements Operation {
    private IOperation operation;

    private BaSyxOperation() {
    }

    BaSyxOperation(IOperation operation) {
        this.operation = operation;
    }

    IOperation getOperation() {
        return this.operation;
    }

    public String getIdShort() {
        return this.operation.getIdShort();
    }

    public int getInArgsCount() {
        return this.operation.getInputVariables().size();
    }

    public int getOutArgsCount() {
        return this.operation.getOutputVariables().size();
    }

    public int getInOutArgsCount() {
        return this.operation.getInOutputVariables().size();
    }

    public int getArgsCount() {
        return this.getInArgsCount() + this.getOutArgsCount() + this.getInOutArgsCount();
    }

    public Object invoke(Object ... args) throws ExecutionException {
        try {
            return this.operation.invoke(args);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    IOperation getSubmodelElement() {
        return this.operation;
    }

    public void accept(AasVisitor visitor) {
        visitor.visitOperation((Operation)this);
    }

    public static class BaSxyOperationBuilder
    implements Operation.OperationBuilder {
        private BaSyxSubmodelElementContainerBuilder<?> parentBuilder;
        private BaSyxOperation instance;
        private org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation operation;
        private List<OperationVariable> inputVariables;
        private List<OperationVariable> outputVariables;
        private List<OperationVariable> inOutVariables;

        BaSxyOperationBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, String idShort) {
            this.parentBuilder = parentBuilder;
            this.instance = new BaSyxOperation();
            this.operation = new org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation();
            this.operation.setIdShort(Tools.checkId(idShort));
        }

        public BaSyxSubmodelElementContainerBuilder<?> getParentBuilder() {
            return this.parentBuilder;
        }

        private OperationVariable createOperationVariable(String idShort, Type type) {
            Property prop = new Property();
            prop.setIdShort(idShort);
            if (null != type) {
                prop.setValueType(Tools.translate(type));
            }
            return new OperationVariable((SubmodelElement)prop);
        }

        public Operation.OperationBuilder addInputVariable(String idShort, Type type) {
            if (null == this.inputVariables) {
                this.inputVariables = new ArrayList<OperationVariable>();
            }
            this.inputVariables.add(this.createOperationVariable(idShort, type));
            return this;
        }

        public Operation.OperationBuilder addOutputVariable(String idShort, Type type) {
            if (null == this.outputVariables) {
                this.outputVariables = new ArrayList<OperationVariable>();
            }
            this.outputVariables.add(this.createOperationVariable(idShort, type));
            return this;
        }

        public Operation.OperationBuilder addInOutVariable(String idShort, Type type) {
            if (null == this.outputVariables) {
                this.outputVariables = new ArrayList<OperationVariable>();
            }
            this.inOutVariables.add(this.createOperationVariable(idShort, type));
            return this;
        }

        public Operation.OperationBuilder setInvocable(Function<Object[], Object> invocable) {
            this.operation.setInvocable(invocable);
            return this;
        }

        public Operation build() {
            if (null != this.inputVariables) {
                this.operation.setInputVariables(this.inputVariables);
            }
            if (null != this.outputVariables) {
                this.operation.setInputVariables(this.outputVariables);
            }
            if (null != this.inOutVariables) {
                this.operation.setInOutputVariables(this.inOutVariables);
            }
            this.instance.operation = (IOperation)this.operation;
            return this.parentBuilder.register(this.instance);
        }
    }
}

