/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractAas;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAas;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistryService;
import org.eclipse.basyx.aas.registration.memory.InMemoryRegistry;
import org.eclipse.basyx.aas.registration.restapi.DirectoryModelProvider;
import org.eclipse.basyx.aas.restapi.AASModelProvider;
import org.eclipse.basyx.aas.restapi.VABMultiSubmodelProvider;
import org.eclipse.basyx.components.aas.AASServerComponent;
import org.eclipse.basyx.components.aas.configuration.AASServerBackend;
import org.eclipse.basyx.components.aas.configuration.BaSyxAASServerConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxContextConfiguration;
import org.eclipse.basyx.submodel.metamodel.map.SubModel;
import org.eclipse.basyx.submodel.restapi.SubModelProvider;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.modelprovider.generic.VABModelProvider;
import org.eclipse.basyx.vab.modelprovider.map.VABMapProvider;
import org.eclipse.basyx.vab.protocol.basyx.server.BaSyxTCPServer;
import org.eclipse.basyx.vab.protocol.http.server.AASHTTPServer;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;
import org.eclipse.basyx.vab.protocol.http.server.VABHTTPInterface;

public class BaSyxDeploymentRecipe
implements DeploymentRecipe {
    private DeploymentSpec deploymentSpec = new DeploymentSpec();

    BaSyxDeploymentRecipe(Endpoint endpoint) {
        this.deploymentSpec.endpoint = endpoint;
        this.deploymentSpec.context = new BaSyxContext(endpoint.getEndpoint(), "", endpoint.getHost(), endpoint.getPort());
        this.deploymentSpec.contextConfig = new BaSyxContextConfiguration(endpoint.getEndpoint(), "", endpoint.getHost(), endpoint.getPort()){

            public BaSyxContext createBaSyxContext() {
                return BaSyxDeploymentRecipe.this.deploymentSpec.context;
            }
        };
    }

    BaSyxDeploymentRecipe(String host, int port, String contextPath, String docBasePath) {
    }

    public DeploymentRecipe.ImmediateDeploymentRecipe addInMemoryRegistry(String regEndpoint) {
        this.deploymentSpec.registry = (IAASRegistryService)new InMemoryRegistry();
        DirectoryModelProvider registryProvider = new DirectoryModelProvider(this.deploymentSpec.registry);
        VABHTTPInterface registryServlet = new VABHTTPInterface((IModelProvider)registryProvider);
        this.deploymentSpec.context.addServletMapping(Endpoint.checkEndpoint((String)regEndpoint) + "/*", (HttpServlet)registryServlet);
        return new BaSyxImmediateDeploymentRecipe();
    }

    public DeploymentRecipe.RegistryDeploymentRecipe setRegistryUrl(Endpoint endpoint) {
        return new BaSyxRegistryDeploymentRecipe(endpoint);
    }

    static void deploy(DeploymentSpec deploymentSpec, Aas aas) {
        if (null == deploymentSpec.registry) {
            throw new IllegalArgumentException("No registry created before");
        }
        if (!(aas instanceof BaSyxAas)) {
            throw new IllegalArgumentException("The aas must be of instance BaSyxAas, i.e., created through the AasFactory.");
        }
        BaSyxAas bAas = (BaSyxAas)aas;
        AASModelProvider aasProvider = new AASModelProvider((AssetAdministrationShell)bAas.getAas());
        VABMultiSubmodelProvider fullProvider = new VABMultiSubmodelProvider();
        fullProvider.setAssetAdministrationShell(aasProvider);
        AASDescriptor aasDescriptor = new AASDescriptor(bAas.getAas(), AbstractAas.getAasEndpoint((ServerAddress)deploymentSpec.endpoint, aas));
        for (Submodel sm : bAas.submodels()) {
            if (!(sm instanceof BaSyxSubmodel)) continue;
            BaSyxSubmodel submodel = (BaSyxSubmodel)sm;
            SubModelProvider subModelProvider = new SubModelProvider((SubModel)submodel.getSubmodel());
            fullProvider.addSubmodel(subModelProvider);
            aasDescriptor.addSubmodelDescriptor(new SubmodelDescriptor(submodel.getSubmodel(), AbstractSubmodel.getSubmodelEndpoint((ServerAddress)deploymentSpec.endpoint, aas, submodel)));
        }
        VABHTTPInterface aasServlet = new VABHTTPInterface((IModelProvider)fullProvider);
        deploymentSpec.registry.register(aasDescriptor);
        deploymentSpec.context.addServletMapping("/" + Tools.idToUrlPath(aas.getIdShort()) + "/*", (HttpServlet)aasServlet);
        deploymentSpec.descriptors.put(aas.getIdShort(), new BaSyxAasDescriptor(fullProvider, aasDescriptor));
    }

    public static Server createControlComponent(HashMap<String, Object> cc, int port) {
        return BaSyxDeploymentRecipe.createControlComponent((VABModelProvider)new VABMapProvider(cc), port);
    }

    public static Server createControlComponent(VABModelProvider provider, int port) {
        final BaSyxTCPServer server = new BaSyxTCPServer((IModelProvider)provider, port);
        Server result = new Server(){

            public Server start() {
                server.start();
                return this;
            }

            public void stop(boolean dispose) {
                server.stop();
            }
        };
        return result;
    }

    private static class DeploymentSpec {
        private Endpoint endpoint;
        private BaSyxContextConfiguration contextConfig;
        private BaSyxContext context;
        private IAASRegistryService registry;
        private Map<String, BaSyxAasDescriptor> descriptors = new HashMap<String, BaSyxAasDescriptor>();

        private DeploymentSpec() {
        }
    }

    private class BaSyxImmediateDeploymentRecipe
    implements DeploymentRecipe.ImmediateDeploymentRecipe {
        private BaSyxImmediateDeploymentRecipe() {
        }

        public DeploymentRecipe.ImmediateDeploymentRecipe deploy(Aas aas) {
            BaSyxDeploymentRecipe.deploy(BaSyxDeploymentRecipe.this.deploymentSpec, aas);
            return this;
        }

        public AasServer createServer(String ... options) {
            return new BaSyxImmediateDeploymentAasServer(BaSyxDeploymentRecipe.this.deploymentSpec);
        }
    }

    private class BaSyxRegistryDeploymentRecipe
    implements DeploymentRecipe.RegistryDeploymentRecipe {
        private Endpoint endpoint;

        private BaSyxRegistryDeploymentRecipe(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public Registry obtainRegistry() throws IOException {
            return AasFactory.getInstance().obtainRegistry(this.endpoint);
        }

        public AasServer createServer(String ... options) {
            return new BaSyxRegistryDeploymentAasServer(BaSyxDeploymentRecipe.this.deploymentSpec, this.endpoint.toUri(), options);
        }
    }

    private static class BaSyxAasDescriptor {
        private AASDescriptor aasDescriptor;
        private VABMultiSubmodelProvider fullProvider;

        private BaSyxAasDescriptor(VABMultiSubmodelProvider fullProvider, AASDescriptor aasDescriptor) {
            this.fullProvider = fullProvider;
            this.aasDescriptor = aasDescriptor;
        }
    }

    private static class BaSyxRegistryDeploymentAasServer
    extends BaSyxAbstractAasServer {
        private AASServerComponent server;

        BaSyxRegistryDeploymentAasServer(DeploymentSpec deploymentSet, String regUrl, String ... options) {
            super(deploymentSet);
            AASServerBackend backend = Tools.getOption(options, AASServerBackend.INMEMORY, AASServerBackend.class);
            this.server = new AASServerComponent(deploymentSet.contextConfig, new BaSyxAASServerConfiguration(backend, "", regUrl));
        }

        public AasServer start() {
            this.server.startComponent();
            return this;
        }

        @Override
        public void stop(boolean dispose) {
            this.server.stopComponent();
            super.stop(dispose);
        }
    }

    private static class BaSyxImmediateDeploymentAasServer
    extends BaSyxAbstractAasServer {
        private AASHTTPServer server;

        BaSyxImmediateDeploymentAasServer(DeploymentSpec deploymentSet) {
            super(deploymentSet);
            this.server = new AASHTTPServer(deploymentSet.context);
        }

        public AasServer start() {
            this.server.start();
            return this;
        }

        @Override
        public void stop(boolean dispose) {
            this.server.shutdown();
            super.stop(dispose);
        }
    }

    private static abstract class BaSyxAbstractAasServer
    implements AasServer {
        private DeploymentSpec deploymentSpec;

        BaSyxAbstractAasServer(DeploymentSpec deploymentSet) {
            this.deploymentSpec = deploymentSet;
        }

        public void deploy(Aas aas) throws IOException {
            BaSyxDeploymentRecipe.deploy(this.deploymentSpec, aas);
        }

        public void deploy(Aas aas, Submodel submodel) {
            if (!(submodel instanceof BaSyxSubmodel)) {
                throw new IllegalArgumentException("The subModel must be of instance BaSyxSubModel, i.e., created through the AasFactory.");
            }
            BaSyxAasDescriptor desc = (BaSyxAasDescriptor)this.deploymentSpec.descriptors.get(aas.getIdShort());
            if (null == desc) {
                throw new IllegalArgumentException("The AAS " + aas.getIdShort() + " is unknown on this server instance.");
            }
            BaSyxSubmodel sm = (BaSyxSubmodel)submodel;
            SubModelProvider subModelProvider = new SubModelProvider((SubModel)sm.getSubmodel());
            desc.fullProvider.addSubmodel(subModelProvider);
            desc.aasDescriptor.addSubmodelDescriptor(new SubmodelDescriptor(sm.getSubmodel(), AbstractSubmodel.getSubmodelEndpoint((ServerAddress)this.deploymentSpec.endpoint, aas, submodel)));
        }

        public void stop(boolean dispose) {
            if (dispose) {
                Tools.disposeTomcatWorkingDir(null, this.deploymentSpec.endpoint.getPort());
            }
        }
    }
}

