/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasFactoryDescriptor;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.PersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAas;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxDeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxPersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRegistry;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import de.iip_ecosphere.platform.support.aas.basyx.VabIipInvocablesCreator;
import de.iip_ecosphere.platform.support.aas.basyx.VabIipOperationsProvider;
import java.io.IOException;
import org.eclipse.basyx.components.IComponent;
import org.eclipse.basyx.components.configuration.BaSyxContextConfiguration;
import org.eclipse.basyx.components.registry.RegistryComponent;
import org.eclipse.basyx.components.registry.configuration.BaSyxRegistryConfiguration;
import org.eclipse.basyx.components.registry.configuration.RegistryBackend;

public class BaSyxAasFactory
extends AasFactory {
    private static final String PROTOCOL_VAB_IIP = "VAB-IIP";

    public Aas.AasBuilder createAasBuilder(String idShort, String identifier) {
        return new BaSyxAas.BaSyxAasBuilder(idShort, identifier);
    }

    public Submodel.SubmodelBuilder createSubmodelBuilder(String idShort, String identifier) {
        return new BaSyxSubmodel.BaSyxSubmodelBuilder(null, idShort, identifier);
    }

    public Server createRegistryServer(Endpoint endpoint, String ... options) {
        BaSyxContextConfiguration contextConfig = new BaSyxContextConfiguration(endpoint.getPort(), endpoint.getEndpoint());
        RegistryBackend backend = Tools.getOption(options, RegistryBackend.INMEMORY, RegistryBackend.class);
        BaSyxRegistryConfiguration registryConfig = new BaSyxRegistryConfiguration(backend);
        RegistryComponent component = new RegistryComponent(contextConfig, registryConfig);
        return new Server((IComponent)component, endpoint){
            final /* synthetic */ IComponent val$component;
            final /* synthetic */ Endpoint val$endpoint;
            {
                this.val$component = iComponent;
                this.val$endpoint = endpoint;
            }

            public Server start() {
                this.val$component.startComponent();
                return this;
            }

            public void stop(boolean dispose) {
                this.val$component.stopComponent();
                if (dispose) {
                    Tools.disposeTomcatWorkingDir(null, this.val$endpoint.getPort());
                }
            }
        };
    }

    public Registry obtainRegistry(Endpoint endpoint) throws IOException {
        return new BaSyxRegistry(endpoint);
    }

    public DeploymentRecipe createDeploymentRecipe(Endpoint endpoint) {
        return new BaSyxDeploymentRecipe(endpoint);
    }

    public String getName() {
        return "AAS/BaSyx v0.1.0-SNAPSHOT (Dec'20)";
    }

    public PersistenceRecipe createPersistenceRecipe() {
        return new BaSyxPersistenceRecipe();
    }

    public String[] getProtocols() {
        return new String[]{"", PROTOCOL_VAB_IIP};
    }

    public InvocablesCreator createInvocablesCreator(String protocol, String host, int port) {
        if ("".equals(protocol) || PROTOCOL_VAB_IIP.equals(protocol)) {
            return new VabIipInvocablesCreator(host, port);
        }
        throw new IllegalArgumentException("Unknown protocol: " + protocol);
    }

    public ProtocolServerBuilder createProtocolServerBuilder(String protocol, int port) {
        if ("".equals(protocol) || PROTOCOL_VAB_IIP.equals(protocol)) {
            return new VabIipOperationsProvider.VabIipOperationsBuilder(port);
        }
        throw new IllegalArgumentException("Unknown protocol: " + protocol);
    }

    public static class Descriptor
    implements AasFactoryDescriptor {
        public AasFactory createInstance() {
            return new BaSyxAasFactory();
        }
    }
}

