/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.DataElement;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractAas;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxElementTranslator;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxOperation;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxProperty;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxReference;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxReferenceElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.ISubModel;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.slf4j.LoggerFactory;

public abstract class AbstractSubmodel<S extends ISubModel>
implements Submodel,
BaSyxElementTranslator.SubmodelElementsRegistrar {
    private S submodel;
    private Map<String, Operation> operations = new HashMap<String, Operation>();
    private Map<String, DataElement> dataElements = new HashMap<String, DataElement>();
    private Map<String, Property> properties = new HashMap<String, Property>();
    private Map<String, SubmodelElement> submodelElements = new HashMap<String, SubmodelElement>();

    protected AbstractSubmodel(S submodel) {
        this.submodel = submodel;
    }

    S getSubmodel() {
        return this.submodel;
    }

    private void warn(String msg) {
        LoggerFactory.getLogger(this.getClass()).warn(msg);
    }

    @Override
    public BaSyxOperation register(BaSyxOperation operation) {
        String id = operation.getIdShort();
        if (this.operations.containsKey(id) || this.submodelElements.containsKey(id)) {
            this.warn("There is already an operation/element with short id '" + id + "'. The property/element may be redefined.");
        }
        this.operations.put(id, operation);
        this.submodelElements.put(id, operation);
        return operation;
    }

    @Override
    public BaSyxProperty register(BaSyxProperty property) {
        String id = property.getIdShort();
        if (this.properties.containsKey(id) || this.submodelElements.containsKey(id)) {
            this.warn("There is already a property/element with short id '" + id + "'. The property/element may be redefined.");
        }
        this.properties.put(id, property);
        this.submodelElements.put(id, property);
        return property;
    }

    @Override
    public BaSyxReferenceElement register(BaSyxReferenceElement reference) {
        String id = reference.getIdShort();
        if (this.submodelElements.containsKey(id)) {
            this.warn("There is already a reference/element with short id '" + id + "'. The reference/element may be redefined.");
        }
        this.submodelElements.put(id, reference);
        return reference;
    }

    @Override
    public BaSyxSubmodelElementCollection register(BaSyxSubmodelElementCollection collection) {
        String id = collection.getIdShort();
        if (this.submodelElements.containsKey(id)) {
            this.warn("There is already a collection/element with short id '" + id + "'. The collection/element may be redefined.");
        }
        this.submodelElements.put(id, collection);
        return collection;
    }

    public String getIdShort() {
        return this.submodel.getIdShort();
    }

    public Iterable<SubmodelElement> submodelElements() {
        return this.submodelElements.values();
    }

    public Iterable<Property> properties() {
        return this.properties.values();
    }

    public Iterable<DataElement> dataElements() {
        return this.dataElements.values();
    }

    public Iterable<Operation> operations() {
        return this.operations.values();
    }

    public int getSubmodelElementsCount() {
        return this.submodelElements.size();
    }

    public int getDataElementsCount() {
        return this.dataElements.size();
    }

    public int getOperationsCount() {
        return this.operations.size();
    }

    public DataElement getDataElement(String idShort) {
        return this.dataElements.get(idShort);
    }

    public Property getProperty(String idShort) {
        return this.properties.get(idShort);
    }

    public int getPropertiesCount() {
        return this.properties.size();
    }

    public ReferenceElement getReferenceElement(String idShort) {
        ReferenceElement found = null;
        try {
            SubmodelElement elt = this.submodelElements.get(idShort);
            if (elt instanceof ReferenceElement) {
                found = (ReferenceElement)elt;
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        return found;
    }

    public Operation getOperation(String idShort) {
        return this.operations.get(idShort);
    }

    public SubmodelElement getSubmodelElement(String idShort) {
        return this.submodelElements.get(idShort);
    }

    public SubmodelElementCollection getSubmodelElementCollection(String idShort) {
        SubmodelElementCollection result = null;
        SubmodelElement tmp = this.getSubmodelElement(idShort);
        if (tmp instanceof SubmodelElementCollection) {
            result = (SubmodelElementCollection)tmp;
        }
        return result;
    }

    public void accept(AasVisitor visitor) {
        visitor.visitSubmodel((Submodel)this);
        for (DataElement de : this.dataElements.values()) {
            de.accept(visitor);
        }
        for (Operation op : this.operations.values()) {
            op.accept(visitor);
        }
        for (SubmodelElement se : this.submodelElements.values()) {
            if (se instanceof DataElement && se instanceof Operation) continue;
            se.accept(visitor);
        }
        visitor.endSubmodel((Submodel)this);
    }

    public Reference createReference() {
        return new BaSyxReference(this.getSubmodel().getReference());
    }

    public void delete(SubmodelElement elt) {
        try {
            if (elt instanceof Property) {
                this.properties.remove(elt.getIdShort());
            } else if (elt instanceof DataElement) {
                this.dataElements.remove(elt.getIdShort());
            } else if (elt instanceof Operation) {
                this.operations.remove(elt.getIdShort());
            }
            this.submodelElements.remove(elt.getIdShort());
            this.submodel.deleteSubmodelElement(elt.getIdShort());
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
    }

    public static String getSubmodelEndpoint(ServerAddress server, Aas aas, Submodel submodel) {
        return AbstractAas.getAasEndpoint(server, aas) + "/submodels/" + Tools.idToUrlPath(submodel.getIdShort()) + "/submodel";
    }
}

