/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.ExtensionBasedFileFormat;
import de.iip_ecosphere.platform.support.FileFormat;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractAas;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractPersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractSubmodel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.basyx.aas.factory.xml.MetamodelToXMLConverter;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.components.aas.aasx.AASXPackageManager;
import org.eclipse.basyx.support.bundle.AASBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class AasxPersistenceRecipe
extends AbstractPersistenceRecipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(AasxPersistenceRecipe.class);
    private static final FileFormat AASX = new ExtensionBasedFileFormat("aasx", "AASX", "AASX package");
    private static final Map<String, String> CONTENT_TYPES = new TreeMap<String, String>();

    AasxPersistenceRecipe() {
        super(AASX);
    }

    public void writeTo(List<Aas> aas, File file) throws IOException {
        if (aas.size() > 1) {
            LOGGER.warn("Writing multiple AAS to a single file may not be read back as BaSyx currently just supports one AAS to be read from an AASX package.");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));){
            out.putNextEntry(new ZipEntry("[Content Types].xml"));
            this.xmlToStream(out, transformerFactory, this.createContentTypesXML(factory));
            out.putNextEntry(new ZipEntry("_rels/.rels"));
            ArrayList<Relationship> rels = new ArrayList<Relationship>();
            rels.add(new Relationship("http://www.admin-shell.io/aasx/relationships/aasx-origin", "/aasx/aasx-origin"));
            this.xmlToStream(out, transformerFactory, this.createRelsXML(factory, rels));
            rels.clear();
            out.putNextEntry(new ZipEntry("aasx/aasx-origin"));
            this.textToStream(out, "Intentionally empty.");
            for (Aas a : aas) {
                this.aasToStream(out, factory, transformerFactory, a, rels);
            }
            out.putNextEntry(new ZipEntry("aasx/_rels/aasx-origin.rels"));
            this.xmlToStream(out, transformerFactory, this.createRelsXML(factory, rels));
        }
        catch (IOException e) {
            throw e;
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new IOException(e);
        }
    }

    private String toFileName(String idShort) {
        return idShort.replace(' ', '_');
    }

    private void aasToStream(ZipOutputStream out, DocumentBuilderFactory factory, TransformerFactory transformerFactory, Aas aas, List<Relationship> rels) throws IOException, ParserConfigurationException, TransformerException {
        String aasName = this.toFileName(aas.getIdShort());
        out.putNextEntry(new ZipEntry("aasx/" + aasName + "/" + aasName + ".aas.xml"));
        rels.add(new Relationship("http://www.admin-shell.io/aasx/relationships/aas-spec", "/aasx/" + aasName + "/" + aasName + ".aas.xml"));
        ArrayList basyxAas = new ArrayList();
        ArrayList basyxSubmodels = new ArrayList();
        ArrayList assetList = new ArrayList();
        ArrayList conceptDescriptionList = new ArrayList();
        Object origAas = ((AbstractAas)aas).getAas();
        if (null == origAas.getAsset()) {
            LOGGER.warn("AAS '" + aas.getIdShort() + "' may not be read back correctly as it does not have an Asset.");
        }
        if (null == origAas.getAssetReference()) {
            LOGGER.warn("AAS '" + aas.getIdShort() + "' may not be read back correctly as it does not have an Asset Reference.");
        }
        basyxAas.add(origAas);
        for (Submodel s : aas.submodels()) {
            basyxSubmodels.add(((AbstractSubmodel)s).getSubmodel());
        }
        AasxPersistenceRecipe.addAsset(aas, assetList, IAsset.class);
        MetamodelToXMLConverter.convertToXML(basyxAas, assetList, conceptDescriptionList, basyxSubmodels, (Result)new StreamResult(out));
        ArrayList<Relationship> aRels = new ArrayList<Relationship>();
        out.putNextEntry(new ZipEntry("aasx/" + aasName + "/_rels/" + aasName + ".aas.xml.rels"));
        this.xmlToStream(out, transformerFactory, this.createRelsXML(factory, aRels));
    }

    private Document createContentTypesXML(DocumentBuilderFactory factory) throws ParserConfigurationException {
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElementNS("http://schemas.openxmlformats.org/package/2006/content-types", "Types");
        for (Map.Entry<String, String> ent : CONTENT_TYPES.entrySet()) {
            Element dflt = doc.createElement("Default");
            dflt.setAttribute("Extension", ent.getKey());
            dflt.setAttribute("ContentType", ent.getValue());
            root.appendChild(dflt);
        }
        Element over = doc.createElement("Override");
        over.setAttribute("PartName", "/aasx/aasx-origin");
        over.setAttribute("ContentType", "text/plain");
        root.appendChild(over);
        doc.appendChild(root);
        return doc;
    }

    private Document createRelsXML(DocumentBuilderFactory factory, List<Relationship> rels) throws ParserConfigurationException {
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElementNS("http://schemas.openxmlformats.org/package/2006/relationships", "Relationships");
        for (Relationship r : rels) {
            Element rel = doc.createElement("Relationship");
            rel.setAttribute("Type", r.type);
            rel.setAttribute("Target", r.target);
            rel.setAttribute("Id", "I" + r.id);
            root.appendChild(rel);
        }
        doc.appendChild(root);
        return doc;
    }

    private void xmlToStream(ZipOutputStream out, TransformerFactory transformerFactory, Document doc) throws TransformerException {
        Transformer transf = transformerFactory.newTransformer();
        transf.setOutputProperty("encoding", "UTF-8");
        transf.setOutputProperty("indent", "yes");
        transf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        transf.transform(source, new StreamResult(out));
    }

    private void textToStream(ZipOutputStream out, String text) {
        PrintStream ps = new PrintStream(out);
        ps.println(text);
    }

    public List<Aas> readFrom(File file) throws IOException {
        ArrayList<Aas> result = new ArrayList<Aas>();
        try {
            AASXPackageManager apm = new AASXPackageManager(file.getAbsolutePath());
            Set bundles = apm.retrieveAASBundles();
            ArrayList<IAssetAdministrationShell> aas = new ArrayList<IAssetAdministrationShell>();
            ArrayList submodels = new ArrayList();
            ArrayList assets = new ArrayList();
            for (AASBundle b : bundles) {
                aas.add(b.getAAS());
                submodels.addAll(b.getSubmodels());
                this.transform(aas, submodels, assets, result);
                aas.clear();
                submodels.clear();
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        return result;
    }

    static {
        CONTENT_TYPES.put("rels", "application/vnd.openxmlformats-package.relationships+xml");
        CONTENT_TYPES.put("xml", "text/xml");
        CONTENT_TYPES.put("jpeg", "image/jpeg");
        CONTENT_TYPES.put("png", "image/png");
        CONTENT_TYPES.put("pdf", "application/pdf");
        CONTENT_TYPES.put("jpg", "image/jpeg");
        CONTENT_TYPES.put("zip", "text/plain");
    }

    private static class Relationship {
        private String type;
        private String target;
        private String id;

        private Relationship(String type, String target) {
            this.type = type;
            this.target = target;
            this.id = "I-" + (type + target).hashCode();
        }
    }
}

