/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.aas.AssetKind;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import org.eclipse.basyx.components.registry.configuration.RegistryBackend;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetypedef.PropertyValueTypeDef;
import org.junit.Assert;
import org.junit.Test;

public class ToolTests {
    private static int advanceIgnored(int pos, String name) {
        while (pos < name.length() && '_' == name.charAt(pos)) {
            ++pos;
        }
        return pos;
    }

    private static boolean equalsNormalized(String name1, String name2) {
        boolean equals = true;
        int pos1 = 0;
        int pos2 = 0;
        pos1 = ToolTests.advanceIgnored(pos1, name1);
        pos2 = ToolTests.advanceIgnored(pos2, name2);
        while (equals && pos1 < name1.length() && pos2 < name2.length()) {
            if (pos1 < name1.length() && pos2 < name2.length()) {
                equals = Character.toLowerCase(name1.charAt(pos1)) == Character.toLowerCase(name2.charAt(pos2));
                ++pos1;
                ++pos2;
            }
            pos1 = ToolTests.advanceIgnored(pos1, name1);
            pos2 = ToolTests.advanceIgnored(pos2, name2);
        }
        return pos1 == name1.length() && pos2 == name2.length();
    }

    private static void assertEquals(Enum<?> t1, Enum<?> t2) {
        Assert.assertTrue((String)(t1 + " " + t2), (boolean)ToolTests.equalsNormalized(t1.name(), t2.name()));
    }

    @Test
    public void testPropertyType() {
        for (Type type : Type.values()) {
            ToolTests.assertEquals(type, Tools.translate((Type)type));
        }
        for (Type type : PropertyValueTypeDef.values()) {
            ToolTests.assertEquals(type, Tools.translate((PropertyValueTypeDef)type));
        }
    }

    @Test
    public void testAssetKind() {
        for (org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind assetKind : org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind.values()) {
            ToolTests.assertEquals(assetKind, Tools.translate((org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind)assetKind));
        }
        for (org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind assetKind : AssetKind.values()) {
            ToolTests.assertEquals(assetKind, Tools.translate((AssetKind)assetKind));
        }
    }

    @Test
    public void testCheckId() {
        Tools.checkId((String)"id");
        try {
            Tools.checkId(null);
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Tools.checkId((String)"");
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Tools.checkId((String)"012ds_");
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Tools.checkId((String)"java.lang.String");
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Tools.checkId((String)"value");
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Tools.checkId((String)"invocationList");
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckUrn() {
        Tools.checkUrn((String)"urn");
        try {
            Tools.checkUrn(null);
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Tools.checkUrn((String)"");
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetOption() {
        String[] opts1 = new String[]{"a", "b", RegistryBackend.INMEMORY.name()};
        String[] opts2 = new String[]{"a", "b"};
        Assert.assertEquals((Object)RegistryBackend.INMEMORY, (Object)Tools.getOption((String[])opts1, (Enum)RegistryBackend.MONGODB, RegistryBackend.class));
        Assert.assertEquals((Object)RegistryBackend.MONGODB, (Object)Tools.getOption((String[])opts2, (Enum)RegistryBackend.MONGODB, RegistryBackend.class));
    }

    @Test
    public void testTranslateIdentifier() {
        ToolTests.assertIIdentifier("aas", IdentifierType.CUSTOM, Tools.translateIdentifier(null, (String)"aas"));
        ToolTests.assertIIdentifier("aas", IdentifierType.CUSTOM, Tools.translateIdentifier((String)"", (String)"aas"));
        ToolTests.assertIIdentifier("xyz", IdentifierType.CUSTOM, Tools.translateIdentifier((String)"xyz", (String)"aas"));
        ToolTests.assertIIdentifier("urn:::AAS:::testMachines#", IdentifierType.IRI, Tools.translateIdentifier((String)"urn:::AAS:::testMachines#", (String)"aas"));
    }

    private static void assertIIdentifier(String expectedId, IdentifierType expectedType, IIdentifier id) {
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((Object)expectedType, (Object)id.getIdType());
        Assert.assertEquals((Object)expectedId, (Object)id.getId());
    }
}

