/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.aas.basyx.server;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.server.BaSyxFullServerRecipe;
import org.junit.Assert;
import org.junit.Test;

public class BaSyxFullServerRecipeTest {
    @Test
    public void testRecipe() {
        ServerRecipe recipe = AasFactory.getInstance().createServerRecipe();
        Assert.assertNotNull((Object)recipe);
        Assert.assertTrue((boolean)(recipe instanceof BaSyxFullServerRecipe));
        Endpoint serverEp = new Endpoint(new ServerAddress(Schema.HTTP), "aas");
        Endpoint regEp = new Endpoint(new ServerAddress(Schema.HTTP), "registry");
        try {
            recipe.createRegistryServer(regEp, null, new String[]{""});
            Assert.fail((String)"PersistenceType not handled");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Server regServer = recipe.createRegistryServer(regEp, (ServerRecipe.PersistenceType)ServerRecipe.LocalPersistenceType.INMEMORY, new String[0]);
        regServer.start();
        try {
            recipe.createAasServer(serverEp, (ServerRecipe.PersistenceType)WrongPersistenceType.WRONG, regEp, new String[]{""});
            Assert.fail((String)"PersistenceType not handled");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        AasServer aasServer = recipe.createAasServer(serverEp, (ServerRecipe.PersistenceType)ServerRecipe.LocalPersistenceType.INMEMORY, regEp, new String[0]);
        aasServer.start();
        aasServer.stop(true);
        regServer.stop(true);
    }

    @Test
    public void testPersistenceType() {
        ServerRecipe rcp = AasFactory.getInstance().createServerRecipe();
        Assert.assertEquals((Object)ServerRecipe.LocalPersistenceType.INMEMORY, (Object)rcp.toPersistenceType(""));
        Assert.assertEquals((Object)ServerRecipe.LocalPersistenceType.INMEMORY, (Object)rcp.toPersistenceType(ServerRecipe.LocalPersistenceType.INMEMORY.name()));
        Assert.assertEquals((Object)BaSyxFullServerRecipe.ServerPersistenceType.MONGO, (Object)rcp.toPersistenceType(BaSyxFullServerRecipe.ServerPersistenceType.MONGO.name()));
        Assert.assertEquals((Object)BaSyxFullServerRecipe.ServerPersistenceType.MONGO, (Object)rcp.toPersistenceType(BaSyxFullServerRecipe.ServerPersistenceType.MONGO.name().toLowerCase()));
    }

    private static enum WrongPersistenceType implements ServerRecipe.PersistenceType
    {
        WRONG;

    }
}

