/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services;

import de.iip_ecosphere.platform.services.ServiceOperations;
import de.iip_ecosphere.platform.services.ServicesClient;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.support.aas.ElementsAccess;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.iip_aas.AasUtils;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.iip_aas.SubmodelElementsCollectionClient;
import de.iip_ecosphere.platform.support.iip_aas.json.JsonResultWrapper;
import de.iip_ecosphere.platform.support.iip_aas.json.JsonUtils;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class ServicesAasClient
extends SubmodelElementsCollectionClient
implements ServicesClient {
    private String appId = "";

    public ServicesAasClient(String resourceId) throws IOException {
        super("resources", resourceId);
    }

    public ServicesAasClient(String resourceId, String appId) throws IOException {
        super("resources", resourceId);
        this.appId = appId == null ? "" : appId;
    }

    protected SubmodelElementCollection getSubmodelElementCollection() {
        SubmodelElement se;
        SubmodelElementCollection m;
        SubmodelElementCollection result = super.getSubmodelElementCollection();
        String serviceMgrId = null;
        SubmodelElementCollection submodelElementCollection = m = null == result ? null : result.getSubmodelElementCollection("services");
        if (null != m) {
            for (SubmodelElement elt : m.elements()) {
                SubmodelElementCollection service;
                if (!(elt instanceof SubmodelElementCollection) || !AasUtils.getPropertyValueAsStringSafe((ElementsAccess)(service = (SubmodelElementCollection)elt), (String)"applicationId", (String)"").equals(this.appId)) continue;
                serviceMgrId = AasUtils.getPropertyValueAsStringSafe((ElementsAccess)service, (String)"serviceMgr", (String)"");
                break;
            }
            serviceMgrId = AasUtils.fixId(serviceMgrId);
        }
        SubmodelElementCollection submodelElementCollection2 = m = null == result ? null : result.getSubmodelElementCollection("serviceManagers");
        if (null != m && null != serviceMgrId && (se = m.getElement(serviceMgrId)) instanceof SubmodelElementCollection) {
            result = (SubmodelElementCollection)se;
        }
        if (null != m && null == result) {
            SubmodelElementCollection found = null;
            int foundServices = -1;
            SubmodelElementCollection fallback = null;
            int fallbackServices = -1;
            for (SubmodelElement elt : m.elements()) {
                if (!(elt instanceof SubmodelElementCollection)) continue;
                SubmodelElementCollection mgr = (SubmodelElementCollection)elt;
                String[] appIds = AasUtils.getPropertyValueAsStringSafe((ElementsAccess)mgr, (String)"supportedAppIds", (String)"").split(",");
                int instances = this.getServiceStateCount(mgr, ServiceState.RUNNING);
                if (!(appIds.length != 0 && !ServicesAasClient.contains(appIds, this.appId) || foundServices >= 0 && instances >= foundServices)) {
                    found = mgr;
                }
                if (fallbackServices >= 0 && instances >= fallbackServices) continue;
                fallback = mgr;
            }
            if (null == found) {
                found = fallback;
            }
            if (found != null) {
                result = found;
            }
        }
        return result;
    }

    private static boolean contains(String[] array, String elt) {
        boolean contains = false;
        for (int i = 0; !contains && i < array.length; ++i) {
            contains = elt.equals(array[i]);
        }
        return contains;
    }

    @Override
    public String addArtifact(URI location) throws ExecutionException {
        return JsonResultWrapper.fromJson((Object)this.getOperation("addArtifact").invoke(new Object[]{location.toString()}));
    }

    @Override
    public String addArtifactAsTask(String taskId, URI location) throws ExecutionException {
        String result = null == taskId ? this.addArtifact(location) : JsonResultWrapper.fromJson((Object)this.getOperation("addArtifactAsTask").invoke(new Object[]{location.toString(), taskId}));
        return result;
    }

    @Override
    public void removeArtifact(String artifactId) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("removeArtifact").invoke(new Object[]{artifactId}));
    }

    @Override
    public void removeArtifactAsTask(String taskId, String artifactId) throws ExecutionException {
        if (null == taskId) {
            this.removeArtifact(artifactId);
        } else {
            JsonResultWrapper.fromJson((Object)this.getOperation("removeArtifactAsTask").invoke(new Object[]{artifactId, taskId}));
        }
    }

    @Override
    public void updateService(String serviceId, URI location) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("updateService").invoke(new Object[]{serviceId, location.toString()}));
    }

    @Override
    public void switchToService(String serviceId, String targetId) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("switchToService").invoke(new Object[]{serviceId, targetId}));
    }

    @Override
    public void activateService(String serviceId) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("activateService").invoke(new Object[]{serviceId}));
    }

    @Override
    public void passivateService(String serviceId) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("passivateService").invoke(new Object[]{serviceId}));
    }

    @Override
    public void startService(String ... serviceId) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("startService").invoke(new Object[]{JsonUtils.toJson((Object)serviceId)}));
    }

    @Override
    public void startService(Map<String, String> options, String ... serviceId) throws ExecutionException {
        if (null == options) {
            options = new HashMap<String, String>();
        }
        JsonResultWrapper.fromJson((Object)this.getOperation("startServiceWithOptions").invoke(new Object[]{JsonUtils.toJson((Object)serviceId), AasUtils.writeMap(options)}));
    }

    @Override
    public void stopService(String ... serviceId) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("stopService").invoke(new Object[]{JsonUtils.toJson((Object)serviceId)}));
    }

    @Override
    public void migrateService(String serviceId, String resourceId) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("migrateService").invoke(new Object[]{serviceId, resourceId}));
    }

    @Override
    public void reconfigureService(String serviceId, Map<String, String> values) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("reconfigureService").invoke(new Object[]{serviceId, AasUtils.writeMap(values)}));
    }

    @Override
    public void setServiceState(String serviceId, ServiceState state) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("setServiceSate").invoke(new Object[]{serviceId, state.toString()}));
    }

    @Override
    public ServiceState getServiceState(String serviceId) {
        ServiceState result = ServiceState.UNKNOWN;
        try {
            String tmp = JsonResultWrapper.fromJson((Object)this.getOperation("getServiceSate").invoke(new Object[]{serviceId}));
            if (null != tmp) {
                result = ServiceState.valueOf((String)tmp);
            }
        }
        catch (ExecutionException e) {
            this.getLogger().error("Requesting service state: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.getLogger().error("Requesting service state, illegal response value: " + e.getMessage());
        }
        return result;
    }

    @Override
    public String streamLog(String serviceId, ServiceOperations.StreamLogMode mode) throws ExecutionException {
        String result = "";
        try {
            result = JsonResultWrapper.fromJson((Object)this.getOperation("serviceStreamLog").invoke(new Object[]{serviceId, mode.name()}));
        }
        catch (ExecutionException e) {
            this.getLogger().error("Requesting service state: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.getLogger().error("Requesting service state, illegal response value: " + e.getMessage());
        }
        return result;
    }

    @Override
    public String[] getServices(String artifactId, boolean topLevelOnly) {
        ArrayList<String> result = new ArrayList<String>();
        SubmodelElementCollection coll = this.getServices();
        if (null != coll) {
            this.getServices(coll, artifactId, result, topLevelOnly);
        }
        String[] tmp = new String[result.size()];
        return result.toArray(tmp);
    }

    private void getServices(SubmodelElementCollection coll, String artifactId, List<String> serviceIds, boolean topLevelOnly) {
        for (SubmodelElement elt : coll.elements()) {
            if (!(elt instanceof SubmodelElementCollection)) continue;
            SubmodelElementCollection service = (SubmodelElementCollection)elt;
            Property id = service.getProperty("id");
            Property art = service.getProperty("artifact");
            Property topLevel = null;
            if (topLevelOnly) {
                topLevel = service.getProperty("topLevel");
            }
            if (null == id || null == art) continue;
            try {
                Object serId;
                Object artId = art.getValue();
                if (!artifactId.equals(artId)) continue;
                boolean tlOk = true;
                if (topLevel != null) {
                    tlOk = Boolean.TRUE.equals(topLevel.getValue());
                }
                if (null == (serId = id.getValue()) || !tlOk) continue;
                serviceIds.add(serId.toString());
            }
            catch (ExecutionException executionException) {}
        }
    }

    @Override
    public SubmodelElementCollection getArtifacts() {
        SubmodelElementCollection result;
        try {
            result = ActiveAasBase.getSubmodel((String)"services").getSubmodelElementCollection("artifacts");
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    @Override
    public SubmodelElementCollection getServices() {
        SubmodelElementCollection result;
        try {
            result = ActiveAasBase.getSubmodel((String)"services").getSubmodelElementCollection("services");
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    public SubmodelElementCollection getRelations() {
        SubmodelElementCollection result;
        try {
            result = ActiveAasBase.getSubmodel((String)"services").getSubmodelElementCollection("relations");
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    @Override
    public void startServiceAsTask(String taskId, String ... serviceId) throws ExecutionException {
        if (null == taskId) {
            this.startService(serviceId);
        } else {
            JsonResultWrapper.fromJson((Object)this.getOperation("startServiceAsTask").invoke(new Object[]{JsonUtils.toJson((Object)serviceId), taskId}));
        }
    }

    @Override
    public void startServiceAsTask(String taskId, Map<String, String> options, String ... serviceId) throws ExecutionException {
        if (null == taskId) {
            this.startService(options, serviceId);
        } else {
            if (null == options) {
                options = new HashMap<String, String>();
            }
            JsonResultWrapper.fromJson((Object)this.getOperation("startServiceWithOptionsAsTask").invoke(new Object[]{JsonUtils.toJson((Object)serviceId), taskId, AasUtils.writeMap(options)}));
        }
    }

    @Override
    public void stopServiceAsTask(String taskId, String ... serviceId) throws ExecutionException {
        if (null == taskId) {
            this.stopService(serviceId);
        } else {
            JsonResultWrapper.fromJson((Object)this.getOperation("stopServiceAsTask").invoke(new Object[]{JsonUtils.toJson((Object)serviceId), taskId}));
        }
    }

    private int getServiceStateCount(SubmodelElementCollection resource, ServiceState state) {
        int result = 0;
        try {
            Operation op = resource.getOperation("getServiceStateCount");
            if (null == op) {
                throw new ExecutionException("Operation `getServiceStateCount` on resource `" + resource.getIdShort() + "` not found.", null);
            }
            String tmp = JsonResultWrapper.fromJson((Object)op.invoke(new Object[]{state.name()}));
            if (null != tmp) {
                result = Integer.parseInt(tmp);
            }
        }
        catch (NumberFormatException | ExecutionException e) {
            this.getLogger().error("Requesting state instance count: " + e.getMessage());
        }
        return result;
    }

    @Override
    public int getServiceInstanceCount(String serviceId) {
        int result = 0;
        try {
            String tmp = JsonResultWrapper.fromJson((Object)this.getOperation("getServiceInstanceCount").invoke(new Object[]{serviceId}));
            if (null != tmp) {
                result = Integer.parseInt(tmp);
            }
        }
        catch (NumberFormatException | ExecutionException e) {
            this.getLogger().error("Requesting service instance count: " + e.getMessage());
        }
        return result;
    }
}

