/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services;

import de.iip_ecosphere.platform.services.ServiceFactoryDescriptor;
import de.iip_ecosphere.platform.services.ServiceManager;
import de.iip_ecosphere.platform.services.ServiceSetup;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.config.AbstractSetup;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.net.NetworkManagerSetup;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import java.io.IOException;
import java.util.Optional;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ServiceFactory.class.getName());
    private static ServiceFactoryDescriptor desc;
    private static ServiceManager manager;
    private static ServiceSetup service;
    private static AasPartRegistry.AasSetup setup;
    private static TransportSetup transport;
    private static NetworkManagerSetup netwMgrSetup;

    private static void init() {
        if (null == desc) {
            ServiceLoader<ServiceFactoryDescriptor> loader = ServiceLoader.load(ServiceFactoryDescriptor.class);
            Optional first = ServiceLoaderUtils.findFirst(loader);
            if (first.isPresent()) {
                desc = (ServiceFactoryDescriptor)first.get();
            } else {
                LOGGER.warn("No Service manager implementation known.");
            }
        }
    }

    public static ServiceManager getServiceManager() {
        if (null == manager) {
            ServiceFactory.init();
            if (null != desc && null != (manager = desc.createInstance())) {
                LOGGER.info("Service manager implementation registered: " + manager.getClass().getName());
            }
        }
        return manager;
    }

    public static ServiceSetup getSetup() {
        if (null == service) {
            ServiceFactory.init();
            if (null != desc) {
                service = desc.getSetup();
            }
            if (null == service) {
                try {
                    service = (ServiceSetup)AbstractSetup.readFromYaml(ServiceSetup.class);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(ServiceFactory.class).warn("Cannot read setup: " + e.getMessage());
                }
                if (null == service) {
                    service = new ServiceSetup();
                }
            }
        }
        return service;
    }

    public static AasPartRegistry.AasSetup getAasSetup() {
        if (null == setup) {
            ServiceFactory.init();
            if (null != desc) {
                setup = desc.getAasSetup();
            }
            if (null == setup) {
                try {
                    ServiceSetup cfg = (ServiceSetup)AbstractSetup.readFromYaml(ServiceSetup.class);
                    setup = cfg.getAas();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(ServiceFactory.class).warn("Cannot read setup: " + e.getMessage());
                }
                if (null == setup) {
                    setup = new AasPartRegistry.AasSetup();
                }
            }
        }
        return setup;
    }

    public static NetworkManagerSetup getNetworkManagerSetup() {
        if (null == netwMgrSetup) {
            ServiceFactory.init();
            try {
                ServiceSetup cfg = (ServiceSetup)AbstractSetup.readFromYaml(ServiceSetup.class);
                netwMgrSetup = cfg.getNetMgr();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(ServiceFactory.class).warn("Cannot read setup: " + e.getMessage());
            }
            if (null == setup) {
                netwMgrSetup = new NetworkManagerSetup();
            }
        }
        return netwMgrSetup;
    }

    public static TransportSetup getTransport() {
        if (null == transport) {
            ServiceFactory.init();
            if (null != desc) {
                transport = desc.getTransport();
            }
            if (null == transport) {
                try {
                    ServiceSetup cfg = (ServiceSetup)AbstractSetup.readFromYaml(ServiceSetup.class);
                    transport = cfg.getTransport();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(ServiceFactory.class).warn("Cannot read setup: " + e.getMessage());
                }
                if (null == transport) {
                    transport = new TransportSetup();
                }
            }
        }
        return transport;
    }

    public static void setAasSetup(AasPartRegistry.AasSetup instance) {
        setup = instance;
    }

    public static void setNetworkManagerSetup(NetworkManagerSetup instance) {
        netwMgrSetup = instance;
    }

    static {
        manager = null;
    }
}

