/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services;

import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.TimeUtils;

public class ServerWrapper
implements Server {
    private Server server;
    private Thread thread;
    private boolean running;

    public ServerWrapper(Server server) {
        this.server = server;
    }

    protected boolean requiresThread() {
        return this.server.getClass().getPackage().getName().equals("iip.servers");
    }

    public Server start() {
        if (this.requiresThread()) {
            this.running = true;
            this.thread = new Thread(() -> {
                this.server.start();
                while (this.running && this.thread.isAlive()) {
                    TimeUtils.sleep((int)1000);
                }
            });
            this.thread.start();
        } else {
            this.server.start();
        }
        return this;
    }

    public void stop(boolean dispose) {
        this.running = false;
        this.server.stop(dispose);
    }
}

