/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services;

import de.iip_ecosphere.platform.services.ArtifactDescriptor;
import de.iip_ecosphere.platform.services.ServiceDescriptor;
import de.iip_ecosphere.platform.services.TypedDataConnectorDescriptor;
import de.iip_ecosphere.platform.services.TypedDataDescriptor;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.ServiceStub;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceDescriptor<A extends ArtifactDescriptor>
implements ServiceDescriptor {
    private String id;
    private String applicationId;
    private String name;
    private String description;
    private Version version;
    private A artifact;
    private ServiceState state;
    private ServiceKind kind = ServiceKind.TRANSFORMATION_SERVICE;
    private boolean isDeployable = true;
    private boolean isTopLevel = true;
    private List<TypedDataDescriptor> parameters = new ArrayList<TypedDataDescriptor>();
    private List<TypedDataConnectorDescriptor> input = new ArrayList<TypedDataConnectorDescriptor>();
    private List<TypedDataConnectorDescriptor> output = new ArrayList<TypedDataConnectorDescriptor>();
    private ServiceStub stub;
    private List<String> additionalArgs;

    protected AbstractServiceDescriptor(String id, String applicationId, String name, String description, Version version) {
        this.id = id;
        this.applicationId = applicationId;
        this.name = name;
        this.description = description;
        this.version = version;
        this.state = ServiceState.AVAILABLE;
    }

    protected void instantiateFrom(AbstractServiceDescriptor<A> template) {
        this.instantiateFrom(template, true, true);
    }

    protected void instantiateFrom(AbstractServiceDescriptor<A> template, boolean addParameters, boolean addConnectors) {
        this.artifact = template.artifact;
        this.kind = template.kind;
        this.isDeployable = template.isDeployable;
        this.isTopLevel = template.isTopLevel;
        if (addParameters) {
            this.parameters.addAll(template.parameters);
        }
        if (addConnectors) {
            this.input.addAll(template.input);
            this.input.addAll(template.output);
        }
    }

    protected abstract Class<A> getArtifactDescriptorClass();

    protected void setArtifact(ArtifactDescriptor artifact) {
        Class<A> cls = this.getArtifactDescriptorClass();
        if (!cls.isInstance(artifact)) {
            throw new IllegalArgumentException("artifact is not of type " + this.getArtifactDescriptorClass().getClass().getName());
        }
        this.artifact = (ArtifactDescriptor)cls.cast(artifact);
    }

    protected void setClassification(ServiceKind kind, boolean isDeployable, boolean isTopLevel) {
        this.kind = kind;
        this.isDeployable = isDeployable;
        this.isTopLevel = isTopLevel;
    }

    @Override
    public ServiceDescriptor getEnsembleLeader() {
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ServiceState getState() {
        ServiceState result;
        if (null != this.stub) {
            result = this.stub.getState();
            if (null == result) {
                result = this.state;
            } else {
                this.state = result;
            }
        } else {
            result = this.state;
        }
        return result;
    }

    @Override
    public void setState(ServiceState state) throws ExecutionException {
        block3: {
            ServiceState.validateTransition((ServiceState)this.state, (ServiceState)state);
            if (null != this.stub) {
                try {
                    this.stub.setState(state);
                    state = this.stub.getState();
                }
                catch (Throwable e) {
                    if (state == ServiceState.STOPPED || state == ServiceState.UNDEPLOYING) break block3;
                    LoggerFactory.getLogger(this.getClass()).info("Cannot set state {} for service '{}' via AAS. Falling back to local state. Resason: {} {}", new Object[]{state, this.getId(), e.getClass(), e.getMessage()});
                }
            }
        }
        this.state = state;
    }

    @Override
    public boolean isDeployable() {
        return this.isDeployable;
    }

    @Override
    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    @Override
    public ServiceKind getKind() {
        return this.kind;
    }

    public A getArtifact() {
        return this.artifact;
    }

    @Override
    public List<TypedDataDescriptor> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public List<TypedDataConnectorDescriptor> getInputDataConnectors() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public List<TypedDataConnectorDescriptor> getOutputDataConnectors() {
        return Collections.unmodifiableList(this.output);
    }

    @Override
    public List<TypedDataConnectorDescriptor> getDataConnectors() {
        ArrayList<TypedDataConnectorDescriptor> result = new ArrayList<TypedDataConnectorDescriptor>();
        result.addAll(this.input);
        result.addAll(this.output);
        return result;
    }

    protected ServiceStub getStub() {
        return this.stub;
    }

    protected void setStub(ServiceStub stub) {
        this.stub = stub;
    }

    protected void addParameter(TypedDataDescriptor parameter) {
        this.parameters.add(parameter);
    }

    protected void addInputDataConnector(TypedDataConnectorDescriptor input) {
        this.input.add(input);
    }

    protected void addOutputDataConnector(TypedDataConnectorDescriptor output) {
        this.output.add(output);
    }

    @Override
    public void setAdditionalArguments(List<String> additionalArgs) {
        this.additionalArgs = additionalArgs;
    }

    @Override
    public List<String> getAdditionalArguments() {
        return this.additionalArgs;
    }

    public static Set<ServiceDescriptor> ensemble(ServiceDescriptor service) {
        HashSet<ServiceDescriptor> result = new HashSet<ServiceDescriptor>();
        result.add(service);
        ServiceDescriptor leader = service.getEnsembleLeader();
        if (null != leader) {
            result.add(leader);
        } else {
            leader = service;
        }
        for (ServiceDescriptor serviceDescriptor : service.getArtifact().getServices()) {
            if (leader != serviceDescriptor.getEnsembleLeader()) continue;
            result.add(serviceDescriptor);
        }
        return result;
    }

    public static Set<String> ensembleConnectorNames(ServiceDescriptor service) {
        return AbstractServiceDescriptor.internalConnectorNames(AbstractServiceDescriptor.ensemble(service));
    }

    public static Set<String> internalConnectorNames(Collection<? extends ServiceDescriptor> services) {
        HashSet<String> in = new HashSet<String>();
        HashSet<String> out = new HashSet<String>();
        for (ServiceDescriptor serviceDescriptor : services) {
            in.addAll(AbstractServiceDescriptor.connectorIds(serviceDescriptor.getInputDataConnectors()));
            out.addAll(AbstractServiceDescriptor.connectorIds(serviceDescriptor.getOutputDataConnectors()));
        }
        in.retainAll(out);
        return in;
    }

    public static Set<String> connectorIds(Collection<TypedDataConnectorDescriptor> cons) {
        return cons.stream().filter(c -> c.getId() != null && c.getId().length() > 0).map(c -> c.getId()).collect(Collectors.toSet());
    }
}

