/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services;

import de.iip_ecosphere.platform.services.AbstractServiceDescriptor;
import de.iip_ecosphere.platform.services.ArtifactDescriptor;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AbstractArtifactDescriptor<S extends AbstractServiceDescriptor<?>>
implements ArtifactDescriptor {
    private String id;
    private String name;
    private URI uri;
    private int usageCount = 0;
    private Map<String, S> services = Collections.synchronizedMap(new HashMap());
    private Map<String, S> servers = Collections.synchronizedMap(new HashMap());

    protected AbstractArtifactDescriptor(String id, String name, URI uri, List<S> services, List<S> servers) {
        this.id = id;
        this.name = name;
        this.uri = null == uri ? null : uri.normalize();
        this.services = this.createMapping(services);
        this.servers = this.createMapping(servers);
    }

    @Override
    public int getUsageCount() {
        return this.usageCount;
    }

    @Override
    public int increaseUsageCount() {
        return ++this.usageCount;
    }

    @Override
    public int decreaseUsageCount() {
        if (this.usageCount > 0) {
            --this.usageCount;
        }
        return this.usageCount;
    }

    protected Map<String, S> createMapping(List<S> services) {
        HashMap<String, AbstractServiceDescriptor> result = new HashMap<String, AbstractServiceDescriptor>();
        for (AbstractServiceDescriptor s : services) {
            result.put(s.getId(), s);
            s.setArtifact(this);
        }
        return result;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Set<String> getServiceIds() {
        return this.services.keySet();
    }

    public Collection<? extends S> getServices() {
        return this.services.values();
    }

    public Collection<? extends S> getServers() {
        return this.servers.values();
    }

    public S getService(String serviceId) {
        return (S)(null == serviceId ? null : (AbstractServiceDescriptor)this.services.get(serviceId));
    }

    public S getServer(String serverId) {
        return (S)(null == serverId ? null : (AbstractServiceDescriptor)this.servers.get(serverId));
    }

    protected void addService(S service) {
        this.services.put(((AbstractServiceDescriptor)service).getId(), service);
    }
}

