/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services;

import de.iip_ecosphere.platform.services.AbstractServiceManager;
import de.iip_ecosphere.platform.services.ArtifactDescriptor;
import de.iip_ecosphere.platform.services.ServiceDescriptor;
import de.iip_ecosphere.platform.services.ServiceFactory;
import de.iip_ecosphere.platform.services.ServiceManager;
import de.iip_ecosphere.platform.services.TypedDataConnectorDescriptor;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.MyArtifactDescriptor;
import test.de.iip_ecosphere.platform.services.MyServiceDescriptor;
import test.de.iip_ecosphere.platform.services.MyServiceManager;
import test.de.iip_ecosphere.platform.services.MyTypedDataConnectorDescriptor;

public class ServiceManagerTest {
    @Test
    public void testMgr() throws ExecutionException, URISyntaxException {
        ActiveAasBase.NotificationMode oldM = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.NONE);
        URI dummy = new URI("file:///dummy");
        ServiceManager mgr = ServiceFactory.getServiceManager();
        Assert.assertNotNull((Object)mgr);
        try {
            mgr.addArtifact(null);
            Assert.fail((String)"No exception");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        String aId = mgr.addArtifact(dummy);
        Assert.assertNotNull((Object)aId);
        ArtifactDescriptor aDesc = mgr.getArtifact(aId);
        Assert.assertNotNull((Object)aId);
        Assert.assertTrue((boolean)mgr.getArtifactIds().contains(aId));
        Assert.assertTrue((boolean)mgr.getArtifacts().contains(aDesc));
        Assert.assertEquals((Object)aId, (Object)aDesc.getId());
        Assert.assertTrue((aDesc.getName().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((aDesc.getServiceIds().size() > 0 ? 1 : 0) != 0);
        List sIds = CollectionUtils.toList(aDesc.getServiceIds().iterator());
        String sId = (String)sIds.get(0);
        Assert.assertNotNull((Object)sId);
        ServiceDescriptor sDesc = aDesc.getService(sId);
        Assert.assertNotNull((Object)sDesc);
        Assert.assertTrue((boolean)aDesc.getServiceIds().contains(sDesc.getId()));
        Assert.assertTrue((boolean)aDesc.getServices().contains(sDesc));
        Assert.assertEquals((Object)ServiceState.AVAILABLE, (Object)sDesc.getState());
        mgr.startService(new String[]{sId});
        Assert.assertEquals((Object)ServiceState.RUNNING, (Object)sDesc.getState());
        mgr.passivateService(sId);
        Assert.assertEquals((Object)ServiceState.PASSIVATED, (Object)sDesc.getState());
        mgr.activateService(sId);
        Assert.assertEquals((Object)ServiceState.RUNNING, (Object)sDesc.getState());
        mgr.reconfigureService(sId, new HashMap());
        Assert.assertEquals((Object)ServiceState.RUNNING, (Object)sDesc.getState());
        mgr.setServiceState(sId, ServiceState.RUNNING);
        mgr.stopService(new String[]{sId});
        Assert.assertEquals((Object)ServiceState.STOPPED, (Object)sDesc.getState());
        ServiceManagerTest.assertException(() -> mgr.cloneArtifact(aId, dummy));
        ServiceManagerTest.assertException(() -> mgr.migrateService(aId, "other"));
        ServiceManagerTest.assertException(() -> mgr.switchToService(aId, sId));
        mgr.updateService(aId, dummy);
        mgr.removeArtifact(aId);
        Assert.assertFalse((boolean)mgr.getArtifactIds().contains(aId));
        Assert.assertFalse((boolean)mgr.getArtifacts().contains(aDesc));
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)oldM);
    }

    @Test
    public void testExternalConnections() throws ExecutionException, URISyntaxException {
        MyServiceManager mgr = new MyServiceManager(false);
        URI dummy = new URI("file:///dummy");
        mgr.addArtifact(dummy);
        Set conn = AbstractServiceManager.determineExternalConnections((ServiceManager)mgr, (String[])new String[0]);
        ServiceManagerTest.assertContains(conn, new String[0]);
        conn = AbstractServiceManager.determineExternalConnections((ServiceManager)mgr, (String[])new String[]{"service_0"});
        ServiceManagerTest.assertContains(conn, "conn-1");
        conn = AbstractServiceManager.determineExternalConnections((ServiceManager)mgr, (String[])new String[]{"service_2"});
        ServiceManagerTest.assertContains(conn, "conn-2");
        conn = AbstractServiceManager.determineExternalConnections((ServiceManager)mgr, (String[])new String[]{"service_3"});
        ServiceManagerTest.assertContains(conn, "conn-3");
        conn = AbstractServiceManager.determineExternalConnections((ServiceManager)mgr, (String[])new String[]{"service_1"});
        ServiceManagerTest.assertContains(conn, "conn-1", "conn-2", "conn-3");
        conn = AbstractServiceManager.determineExternalConnections((ServiceManager)mgr, (String[])new String[]{"service_0", "service_1"});
        ServiceManagerTest.assertContains(conn, "conn-2", "conn-3");
    }

    @Test
    public void testInternalConnections() throws ExecutionException, URISyntaxException {
        MyServiceManager mgr = new MyServiceManager(false);
        URI dummy = new URI("file:///dummy");
        mgr.addArtifact(dummy);
        Set conn = AbstractServiceManager.determineInternalConnections((ServiceManager)mgr, (String[])new String[0]);
        ServiceManagerTest.assertContains(conn, new String[0]);
        conn = AbstractServiceManager.determineInternalConnections((ServiceManager)mgr, (String[])new String[]{"service_0"});
        ServiceManagerTest.assertContains(conn, "conn-1");
        conn = AbstractServiceManager.determineInternalConnections((ServiceManager)mgr, (String[])new String[]{"service_2"});
        ServiceManagerTest.assertContains(conn, new String[0]);
        conn = AbstractServiceManager.determineInternalConnections((ServiceManager)mgr, (String[])new String[]{"service_3"});
        ServiceManagerTest.assertContains(conn, new String[0]);
        conn = AbstractServiceManager.determineInternalConnections((ServiceManager)mgr, (String[])new String[]{"service_1"});
        ServiceManagerTest.assertContains(conn, "conn-2", "conn-3");
        conn = AbstractServiceManager.determineInternalConnections((ServiceManager)mgr, (String[])new String[]{"service_0", "service_1"});
        ServiceManagerTest.assertContains(conn, "conn-1", "conn-2", "conn-3");
    }

    @Test
    public void testFunctionalConnections() throws ExecutionException, URISyntaxException {
        MyServiceManager mgr = new MyServiceManager(false);
        URI dummy = new URI("file:///dummy");
        mgr.addArtifact(dummy);
        Set conn = AbstractServiceManager.determineFunctionalConnections((ServiceManager)mgr, (String[])new String[0]);
        ServiceManagerTest.assertContains(conn, new String[0]);
        conn = AbstractServiceManager.determineFunctionalConnections((ServiceManager)mgr, (String[])new String[]{"service_0"});
        ServiceManagerTest.assertContains(conn, "conn-0");
        conn = AbstractServiceManager.determineFunctionalConnections((ServiceManager)mgr, (String[])new String[]{"service_2"});
        ServiceManagerTest.assertContains(conn, "conn-3");
        conn = AbstractServiceManager.determineFunctionalConnections((ServiceManager)mgr, (String[])new String[]{"service_3"});
        ServiceManagerTest.assertContains(conn, "conn-3");
        conn = AbstractServiceManager.determineFunctionalConnections((ServiceManager)mgr, (String[])new String[]{"service_1"});
        ServiceManagerTest.assertContains(conn, "conn-1");
        conn = AbstractServiceManager.determineInternalConnections((ServiceManager)mgr, (String[])new String[]{"service_0", "service_1"});
        ServiceManagerTest.assertContains(conn, "conn-1", "conn-2", "conn-3");
    }

    private static void assertContains(Set<AbstractServiceManager.TypedDataConnection> conn, String ... cIds) {
        Assert.assertTrue((null != conn && conn.size() == cIds.length ? 1 : 0) != 0);
        if (cIds.length > 0) {
            Set expected = CollectionUtils.addAll(new HashSet(), (Object[])cIds);
            int found = 0;
            for (TypedDataConnectorDescriptor typedDataConnectorDescriptor : conn) {
                if (!expected.contains(typedDataConnectorDescriptor.getId())) continue;
                ++found;
            }
            Assert.assertTrue((String)("Not found all of " + Arrays.toString(cIds) + " in " + conn), (found == cIds.length ? 1 : 0) != 0);
        }
    }

    static void assertException(WithExecutionException func) {
        try {
            func.run();
            Assert.fail((String)"No Exception");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void testSortByDependencyBasic() {
        AvailableTrue av = new AvailableTrue();
        ArrayList<MyServiceDescriptor> services = new ArrayList<MyServiceDescriptor>();
        ArrayList localServices = new ArrayList();
        List result = AbstractServiceManager.sortByDependency(services, localServices, (Predicate)av, (boolean)false);
        Assert.assertTrue((boolean)result.isEmpty());
        av.assertTested(new String[0]);
        MyServiceDescriptor s1 = new MyServiceDescriptor("s1", "s1", "", null);
        services.add(s1);
        new MyArtifactDescriptor("a1", "a1", new File("a1.jar").toURI(), services);
        result = AbstractServiceManager.sortByDependency(services, localServices, (Predicate)av, (boolean)false);
        ServiceManagerTest.assertList(result, s1);
        av.assertTested(new String[0]);
        services.clear();
        s1 = new MyServiceDescriptor("s1", "s1", "", null);
        MyServiceDescriptor s2 = new MyServiceDescriptor("s2", "s2", "", null);
        services.add(s1);
        services.add(s2);
        new MyArtifactDescriptor("a1", "a1", new File("a1.jar").toURI(), services);
        result = AbstractServiceManager.sortByDependency(services, localServices, (Predicate)av, (boolean)false);
        ServiceManagerTest.assertCollection(result, s1, s2);
        av.assertTested(new String[0]);
    }

    @Test
    public void testSortByDependency() throws URISyntaxException {
        AvailableTrue av = new AvailableTrue();
        ArrayList<MyServiceDescriptor> services = new ArrayList<MyServiceDescriptor>();
        ArrayList<MyServiceDescriptor> localServices = new ArrayList<MyServiceDescriptor>();
        MyServiceDescriptor s11 = new MyServiceDescriptor("s1.1", "s1.2", "", null);
        s11.addOutputDataConnector(new MyTypedDataConnectorDescriptor("output", "output", "", Integer.class, "s1.2", null));
        MyServiceDescriptor s12 = new MyServiceDescriptor("s1.2", "s1.2", "", null);
        s12.addInputDataConnector(new MyTypedDataConnectorDescriptor("input", "input", "", Integer.class, null, null));
        localServices.add(s11);
        localServices.add(s12);
        new MyArtifactDescriptor("a1", "a1", new File("a1.jar").toURI(), localServices);
        MyServiceDescriptor s21 = new MyServiceDescriptor("s2.1", "s2.2", "", null);
        s21.addInputDataConnector(new MyTypedDataConnectorDescriptor("input", "input", "", Integer.class, null, null));
        s21.addOutputDataConnector(new MyTypedDataConnectorDescriptor("im1", "im1", "", Integer.class, "s2.2", null));
        MyServiceDescriptor s22 = new MyServiceDescriptor("s2.2", "s2.2", "", null);
        s22.addInputDataConnector(new MyTypedDataConnectorDescriptor("im1", "im1", "", Integer.class, null, null));
        s22.addOutputDataConnector(new MyTypedDataConnectorDescriptor("output", "output", "", Integer.class, "s1.2", null));
        services.add(s21);
        services.add(s22);
        new MyArtifactDescriptor("a2", "a2", new File("a2.jar").toURI(), services);
        localServices.addAll(services);
        List result = AbstractServiceManager.sortByDependency(services, localServices, (Predicate)av, (boolean)false);
        ServiceManagerTest.assertList(result, s22, s21);
        av.assertTested("output", "im1");
        Collections.reverse(services);
        result = AbstractServiceManager.sortByDependency(services, localServices, (Predicate)av, (boolean)false);
        ServiceManagerTest.assertList(result, s22, s21);
        av.assertTested("output", "im1");
        result = AbstractServiceManager.sortByDependency(services, localServices, (Predicate)av, (boolean)true);
        ServiceManagerTest.assertList(result, s21, s22);
        result = AbstractServiceManager.sortByDependency(services, localServices, c -> !c.getId().equals("im1"), (boolean)false);
        ServiceManagerTest.assertList(result, s22, s21);
    }

    @Test
    public void testSortByDependencyEnsemble() throws URISyntaxException {
        AvailableTrue av = new AvailableTrue();
        ArrayList<MyServiceDescriptor> services = new ArrayList<MyServiceDescriptor>();
        ArrayList<MyServiceDescriptor> localServices = new ArrayList<MyServiceDescriptor>();
        MyServiceDescriptor s11 = new MyServiceDescriptor("s1.1", "s1.2", "", null);
        s11.addInputDataConnector(new MyTypedDataConnectorDescriptor("input", "input", "", Integer.class, null, null));
        s11.addOutputDataConnector(new MyTypedDataConnectorDescriptor("intl1", "intl1", "", Integer.class, "s1.2", null));
        MyServiceDescriptor s12 = new MyServiceDescriptor("s1.2", "s1.2", "", null);
        s12.addOutputDataConnector(new MyTypedDataConnectorDescriptor("output", "output", "", Integer.class, null, null));
        s12.addInputDataConnector(new MyTypedDataConnectorDescriptor("intl1", "intl1", "", Integer.class, null, null));
        s11.setEnsembleLeader(s12);
        services.add(s11);
        services.add(s12);
        MyServiceDescriptor s21 = new MyServiceDescriptor("s2.1", "s2.1", "", null);
        s21.addInputDataConnector(new MyTypedDataConnectorDescriptor("input", "input", "", Integer.class, null, null));
        s21.addOutputDataConnector(new MyTypedDataConnectorDescriptor("output", "output", "", Integer.class, "s2.2", null));
        s21.addOutputDataConnector(new MyTypedDataConnectorDescriptor("im1", "im1", "", Integer.class, "s2.2", null));
        s21.addInputDataConnector(new MyTypedDataConnectorDescriptor("im2", "im2", "", Integer.class, null, null));
        MyServiceDescriptor s22 = new MyServiceDescriptor("s2.2", "s2.2", "", null);
        s22.addInputDataConnector(new MyTypedDataConnectorDescriptor("im1", "im1", "", Integer.class, null, null));
        s22.addOutputDataConnector(new MyTypedDataConnectorDescriptor("im2", "im2", "", Integer.class, null, null));
        s22.setEnsembleLeader(s21);
        services.add(s21);
        services.add(s22);
        new MyArtifactDescriptor("a", "a", new File("a.jar").toURI(), services);
        localServices.addAll(services);
        List result = AbstractServiceManager.sortByDependency(services, localServices, (Predicate)av, (boolean)false);
        ServiceManagerTest.assertCollection(result, s12, s21, s22, s11);
        Assert.assertTrue((result.indexOf((Object)s12) < result.indexOf((Object)s11) ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf((Object)s21) < result.indexOf((Object)s22) ? 1 : 0) != 0);
        av.assertTested("output");
        Collections.reverse(services);
        result = AbstractServiceManager.sortByDependency(services, localServices, (Predicate)av, (boolean)false);
        ServiceManagerTest.assertCollection(result, s12, s21, s22, s11);
        Assert.assertTrue((result.indexOf((Object)s12) < result.indexOf((Object)s11) ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf((Object)s21) < result.indexOf((Object)s22) ? 1 : 0) != 0);
        av.assertTested("output");
    }

    static <T> void assertList(List<T> list, T ... expected) {
        Assert.assertNotNull(list);
        Assert.assertEquals((long)expected.length, (long)list.size());
        for (int t = 0; t < expected.length; ++t) {
            Assert.assertEquals(expected[t], list.get(t));
        }
    }

    static <T> void assertCollection(Collection<T> collection, T ... expected) {
        Assert.assertNotNull(collection);
        Assert.assertEquals((long)expected.length, (long)collection.size());
        for (int t = 0; t < expected.length; ++t) {
            Assert.assertTrue((boolean)collection.contains(expected[t]));
        }
    }

    private static class AvailableTrue
    implements Predicate<TypedDataConnectorDescriptor> {
        private Set<String> tested = new HashSet<String>();

        private AvailableTrue() {
        }

        @Override
        public boolean test(TypedDataConnectorDescriptor conn) {
            this.tested.add(conn.getName());
            return true;
        }

        public void assertTested(String ... expected) {
            if (expected.length == 0) {
                Assert.assertTrue((String)("Not expected tested: " + this.tested), (boolean)this.tested.isEmpty());
            } else {
                Assert.assertEquals((long)expected.length, (long)this.tested.size());
                for (String e : expected) {
                    Assert.assertTrue((String)("Not tested " + e), (boolean)this.tested.contains(e));
                }
                this.tested.clear();
            }
        }
    }

    static interface WithExecutionException {
        public void run() throws ExecutionException;
    }
}

