/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services;

import de.iip_ecosphere.platform.services.AbstractArtifactDescriptor;
import de.iip_ecosphere.platform.services.AbstractServiceManager;
import de.iip_ecosphere.platform.services.ServiceDescriptor;
import de.iip_ecosphere.platform.services.TypedDataConnectorDescriptor;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import test.de.iip_ecosphere.platform.services.MyArtifactDescriptor;
import test.de.iip_ecosphere.platform.services.MyServiceDescriptor;
import test.de.iip_ecosphere.platform.services.MyTypedDataConnectorDescriptor;
import test.de.iip_ecosphere.platform.services.MyTypedDataDescriptor;

class MyServiceManager
extends AbstractServiceManager<MyArtifactDescriptor, MyServiceDescriptor> {
    private static int connectorCount;
    private int artifactId;
    private int serviceId;
    private boolean small;

    MyServiceManager(boolean small) {
        this.small = small;
        connectorCount = 0;
    }

    private String createArtifactId() {
        return "art_" + this.artifactId++;
    }

    private String createServiceId() {
        return "service_" + this.serviceId++;
    }

    public String addArtifact(URI location) throws ExecutionException {
        if (null == location) {
            throw new ExecutionException("location must not be null", null);
        }
        String aId = this.createArtifactId();
        ArrayList<MyServiceDescriptor> services = new ArrayList<MyServiceDescriptor>();
        String text = location.toString();
        MyServiceDescriptor sd1 = new MyServiceDescriptor(this.createServiceId(), "name " + text, "desc " + text, new Version(new int[]{1, 0}));
        MyServiceDescriptor sd2 = new MyServiceDescriptor(this.createServiceId(), "name " + text, "desc " + text, new Version(new int[]{1, 1}));
        services.add(this.setupData(sd1, sd2));
        if (this.small) {
            services.add(this.setupData(sd2, new MyServiceDescriptor[0]));
        } else {
            MyServiceDescriptor sd3 = new MyServiceDescriptor(this.createServiceId(), "name " + text, "desc " + text, new Version(new int[]{1, 2}));
            MyServiceDescriptor sd4 = new MyServiceDescriptor(this.createServiceId(), "name " + text, "desc " + text, new Version(new int[]{1, 3}));
            services.add(this.setupData(sd2, sd3, sd4));
            services.add(this.setupData(sd3, new MyServiceDescriptor[0]));
            services.add(this.setupData(sd4, new MyServiceDescriptor[0]));
        }
        super.addArtifact(aId, (AbstractArtifactDescriptor)new MyArtifactDescriptor(aId, text, location, services));
        return aId;
    }

    private MyServiceDescriptor setupData(MyServiceDescriptor sd, MyServiceDescriptor ... out) {
        sd.addParameter(new MyTypedDataDescriptor("NAME", "reconfigures the name", String.class));
        sd.addInputDataConnector(new MyTypedDataConnectorDescriptor("conn-" + connectorCount, "conn-" + connectorCount, "", Integer.TYPE, null, null));
        for (MyServiceDescriptor o : out) {
            sd.addOutputDataConnector(new MyTypedDataConnectorDescriptor("conn-" + ++connectorCount, "conn-" + connectorCount, "", Integer.TYPE, o.getId(), "func-" + connectorCount));
        }
        return sd;
    }

    public void startService(String ... serviceIds) throws ExecutionException {
        this.startService((Map<String, String>)null, serviceIds);
    }

    public void startService(Map<String, String> options, String ... serviceIds) throws ExecutionException {
        for (String s : serviceIds) {
            this.setState((ServiceDescriptor)this.getServiceDescriptor(s, "serviceId", "start"), ServiceState.STARTING);
            this.setState((ServiceDescriptor)this.getServiceDescriptor(s, "serviceId", "start"), ServiceState.RUNNING);
        }
    }

    public void stopService(String ... serviceIds) throws ExecutionException {
        for (String s : serviceIds) {
            this.setState((ServiceDescriptor)this.getServiceDescriptor(s, "serviceId", "stop"), ServiceState.STOPPING);
            this.setState((ServiceDescriptor)this.getServiceDescriptor(s, "serviceId", "stop"), ServiceState.STOPPED);
        }
    }

    public void updateService(String id, URI location) throws ExecutionException {
    }

    public void removeArtifact(String id) throws ExecutionException {
        super.removeArtifact(id);
    }

    public void switchToService(String id, String targetId) throws ExecutionException {
        super.switchToService(id, targetId);
    }

    public void migrateService(String id, String resourceId) throws ExecutionException {
        super.migrateService(id, resourceId);
    }

    public void cloneArtifact(String artifactId, URI location) throws ExecutionException {
        throw new ExecutionException("Not implemented", null);
    }

    public void activateService(String serviceId) throws ExecutionException {
        MyServiceDescriptor service = (MyServiceDescriptor)this.getServiceDescriptor(serviceId, "serviceId", "activate");
        if (ServiceState.PASSIVATED != service.getState()) {
            throw new ExecutionException("Cannot passivate as service is in state " + service.getState(), null);
        }
        this.setState((ServiceDescriptor)service, ServiceState.ACTIVATING);
        this.setState((ServiceDescriptor)service, ServiceState.RUNNING);
    }

    public void passivateService(String serviceId) throws ExecutionException {
        MyServiceDescriptor service = (MyServiceDescriptor)this.getServiceDescriptor(serviceId, "serviceId", "passivate");
        if (ServiceState.RUNNING != service.getState()) {
            throw new ExecutionException("Cannot passivate as service is in state " + service.getState(), null);
        }
        this.setState((ServiceDescriptor)service, ServiceState.PASSIVATING);
        this.setState((ServiceDescriptor)service, ServiceState.PASSIVATED);
    }

    public void reconfigureService(String serviceId, Map<String, String> values) throws ExecutionException {
        MyServiceDescriptor service = (MyServiceDescriptor)this.getServiceDescriptor(serviceId, "serviceId", "reconfigure");
        ServiceState state = service.getState();
        this.setState((ServiceDescriptor)service, ServiceState.RECONFIGURING);
        this.setState((ServiceDescriptor)service, state);
    }

    protected Predicate<TypedDataConnectorDescriptor> getAvailablePredicate() {
        return c -> true;
    }
}

