/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services;

import de.iip_ecosphere.platform.services.AbstractServiceDescriptor;
import de.iip_ecosphere.platform.services.ServiceDescriptor;
import de.iip_ecosphere.platform.services.TypedDataConnectorDescriptor;
import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.MyArtifactDescriptor;
import test.de.iip_ecosphere.platform.services.MyServiceDescriptor;
import test.de.iip_ecosphere.platform.services.MyTypedDataConnectorDescriptor;
import test.de.iip_ecosphere.platform.services.ServiceManagerTest;

public class AbstractServiceDescriptorTest {
    @Test
    public void testEnsemble() {
        ArrayList<MyServiceDescriptor> services = new ArrayList<MyServiceDescriptor>();
        MyServiceDescriptor s0 = new MyServiceDescriptor("s0", "s0", "", null);
        services.add(s0);
        MyServiceDescriptor s11 = new MyServiceDescriptor("s1.1", "s1.2", "", null);
        MyServiceDescriptor s12 = new MyServiceDescriptor("s1.2", "s1.2", "", null);
        s11.setEnsembleLeader(s12);
        services.add(s11);
        services.add(s12);
        MyServiceDescriptor s21 = new MyServiceDescriptor("s2.1", "s2.1", "", null);
        MyServiceDescriptor s22 = new MyServiceDescriptor("s2.2", "s2.2", "", null);
        s22.setEnsembleLeader(s21);
        MyServiceDescriptor s23 = new MyServiceDescriptor("s2.3", "s2.3", "", null);
        s23.setEnsembleLeader(s21);
        services.add(s21);
        services.add(s22);
        services.add(s23);
        new MyArtifactDescriptor("a", "a", new File("a.jar").toURI(), services);
        ServiceManagerTest.assertCollection(AbstractServiceDescriptor.ensemble((ServiceDescriptor)s0), new ServiceDescriptor[]{s0});
        ServiceManagerTest.assertCollection(AbstractServiceDescriptor.ensemble((ServiceDescriptor)s11), new ServiceDescriptor[]{s11, s12});
        ServiceManagerTest.assertCollection(AbstractServiceDescriptor.ensemble((ServiceDescriptor)s12), new ServiceDescriptor[]{s11, s12});
        ServiceManagerTest.assertCollection(AbstractServiceDescriptor.ensemble((ServiceDescriptor)s21), new ServiceDescriptor[]{s21, s22, s23});
        ServiceManagerTest.assertCollection(AbstractServiceDescriptor.ensemble((ServiceDescriptor)s22), new ServiceDescriptor[]{s21, s22, s23});
        ServiceManagerTest.assertCollection(AbstractServiceDescriptor.ensemble((ServiceDescriptor)s23), new ServiceDescriptor[]{s21, s22, s23});
    }

    @Test
    public void testConnectorNames() {
        ArrayList<MyTypedDataConnectorDescriptor> conns = new ArrayList<MyTypedDataConnectorDescriptor>();
        ServiceManagerTest.assertCollection(AbstractServiceDescriptor.connectorIds(conns), new String[0]);
        conns.add(new MyTypedDataConnectorDescriptor("c1", "conn1", "", Integer.class, null, null));
        ServiceManagerTest.assertCollection(AbstractServiceDescriptor.connectorIds(conns), "c1");
        conns.add(new MyTypedDataConnectorDescriptor("c2", "conn2", "", Integer.class, "s2", null));
        ServiceManagerTest.assertCollection(AbstractServiceDescriptor.connectorIds(conns), "c1", "c2");
        Assert.assertNull((Object)((TypedDataConnectorDescriptor)conns.get(0)).getService());
        Assert.assertEquals((Object)"s2", (Object)((TypedDataConnectorDescriptor)conns.get(1)).getService());
    }

    @Test
    public void testEnsembleConnectionNames() {
        ArrayList<MyServiceDescriptor> services = new ArrayList<MyServiceDescriptor>();
        MyServiceDescriptor s0 = new MyServiceDescriptor("s0", "s0", "", null);
        s0.addOutputDataConnector(new MyTypedDataConnectorDescriptor("output", "output", "", Integer.class, "s1.1", null));
        services.add(s0);
        MyServiceDescriptor s11 = new MyServiceDescriptor("s1.1", "s1.2", "", null);
        s11.addOutputDataConnector(new MyTypedDataConnectorDescriptor("int1", "int1", "", Integer.class, "s1.2", null));
        MyServiceDescriptor s12 = new MyServiceDescriptor("s1.2", "s1.2", "", null);
        s12.addInputDataConnector(new MyTypedDataConnectorDescriptor("int1", "int1", "", Integer.class, null, null));
        s12.addOutputDataConnector(new MyTypedDataConnectorDescriptor("output", "output", "", Integer.class, "s2.1", null));
        s11.setEnsembleLeader(s12);
        services.add(s11);
        services.add(s12);
        MyServiceDescriptor s21 = new MyServiceDescriptor("s2.1", "s2.1", "", null);
        s21.addInputDataConnector(new MyTypedDataConnectorDescriptor("input", "input", "", Integer.class, null, null));
        s21.addOutputDataConnector(new MyTypedDataConnectorDescriptor("int20", "int20", "", Integer.class, "s2.2", null));
        MyServiceDescriptor s22 = new MyServiceDescriptor("s2.2", "s2.2", "", null);
        s22.addInputDataConnector(new MyTypedDataConnectorDescriptor("int20", "int20", "", Integer.class, null, null));
        s22.addOutputDataConnector(new MyTypedDataConnectorDescriptor("int21", "int21", "", Integer.class, "s2.3", null));
        s22.setEnsembleLeader(s21);
        MyServiceDescriptor s23 = new MyServiceDescriptor("s2.3", "s2.3", "", null);
        s23.addInputDataConnector(new MyTypedDataConnectorDescriptor("int21", "int21", "", Integer.class, null, null));
        s23.addOutputDataConnector(new MyTypedDataConnectorDescriptor("output", "output", "", Integer.class, null, null));
        s23.setEnsembleLeader(s21);
        services.add(s21);
        services.add(s22);
        services.add(s23);
        new MyArtifactDescriptor("a", "a", new File("a.jar").toURI(), services);
        ServiceManagerTest.assertCollection(AbstractServiceDescriptor.ensembleConnectorNames((ServiceDescriptor)s0), new String[0]);
        ServiceManagerTest.assertCollection(AbstractServiceDescriptor.ensembleConnectorNames((ServiceDescriptor)s11), "int1");
        ServiceManagerTest.assertCollection(AbstractServiceDescriptor.ensembleConnectorNames((ServiceDescriptor)s12), "int1");
        ServiceManagerTest.assertCollection(AbstractServiceDescriptor.ensembleConnectorNames((ServiceDescriptor)s21), "int20", "int21");
        ServiceManagerTest.assertCollection(AbstractServiceDescriptor.ensembleConnectorNames((ServiceDescriptor)s22), "int20", "int21");
        ServiceManagerTest.assertCollection(AbstractServiceDescriptor.ensembleConnectorNames((ServiceDescriptor)s23), "int20", "int21");
    }
}

