/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.spring.yaml;

import de.iip_ecosphere.platform.services.spring.descriptor.Endpoint;

public class YamlEndpoint
implements Endpoint {
    private String portArg = "";
    private String hostArg = "";

    @Override
    public String getPortArg() {
        return this.portArg;
    }

    @Override
    public boolean isPortArgGeneric() {
        return YamlEndpoint.containsSafe(this.portArg, "${port}");
    }

    @Override
    public String getPortArg(int port) {
        return this.replaceSafe(this.portArg, "${port}", String.valueOf(port));
    }

    @Override
    public String getHostArg() {
        return this.hostArg;
    }

    @Override
    public boolean isHostArgGeneric() {
        return YamlEndpoint.containsSafe(this.hostArg, "${host}");
    }

    @Override
    public String getHostArg(String hostname) {
        return this.replaceSafe(this.hostArg, "${host}", hostname);
    }

    private static boolean containsSafe(String text, String target) {
        return null != text && null != target && text.contains(target);
    }

    private String replaceSafe(String text, String target, String replacement) {
        String result = null == text ? "" : (null == replacement ? text : text.replace(target, replacement));
        return result;
    }

    public void setPortArg(String portArg) {
        this.portArg = portArg;
    }

    public void setHostArg(String hostArg) {
        this.hostArg = hostArg;
    }
}

