/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.spring.descriptor;

import de.iip_ecosphere.platform.services.spring.descriptor.Field;
import de.iip_ecosphere.platform.services.spring.descriptor.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import org.apache.logging.log4j.LogManager;

public class TypeResolver {
    private static final Map<String, Class<?>> PRIMITIVES = new HashMap();
    private Map<String, Class<?>> classes = new HashMap();
    private ClassLoader loader;

    public TypeResolver(List<? extends Type> declarations) {
        List<Type> unresolved = this.createClasses(declarations);
        if (!unresolved.isEmpty()) {
            Object msg = "";
            for (Type t : unresolved) {
                if (((String)msg).length() > 0) {
                    msg = (String)msg + ", ";
                }
                msg = (String)msg + t.getName();
            }
            LogManager.getLogger(this.getClass()).error("Cannot resolve " + (String)msg + ", potentially due to cyclic dependencies");
        }
    }

    private List<Type> createClasses(List<? extends Type> declarations) {
        int lastSize;
        int thisSize;
        ArrayList<Type> decls = new ArrayList<Type>();
        decls.addAll(declarations);
        do {
            lastSize = decls.size();
            for (int d = decls.size() - 1; d >= 0; --d) {
                if (!this.createClasses((Type)decls.get(d))) continue;
                decls.remove(d);
            }
        } while ((thisSize = decls.size()) > 0 && lastSize != thisSize);
        return decls;
    }

    public static boolean isPrimitive(String name) {
        return PRIMITIVES.get(name) != null;
    }

    private boolean createClasses(Type type) {
        boolean resolvable = true;
        for (Field field : type.getFields()) {
            if (this.resolve(field.getType()) != null) continue;
            resolvable = false;
            break;
        }
        if (resolvable) {
            DynamicType.Builder typeBuilder = new ByteBuddy().subclass(Object.class).name(type.getName());
            for (Field field : type.getFields()) {
                typeBuilder = typeBuilder.defineField(field.getName(), this.resolve(field.getType()), new ModifierContributor.ForField[]{Visibility.PUBLIC});
            }
            DynamicType.Unloaded unloaded = typeBuilder.make();
            Class clazz = unloaded.load(null == this.loader ? this.getClass().getClassLoader() : this.loader).getLoaded();
            if (null == this.loader) {
                this.loader = clazz.getClassLoader();
            }
            this.classes.put(type.getName(), clazz);
        }
        return resolvable;
    }

    public Class<?> resolve(String name) {
        Class<?> result = PRIMITIVES.get(name);
        if (null == result) {
            try {
                result = Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (null == result) {
            result = this.classes.get(name);
        }
        return result;
    }

    static {
        PRIMITIVES.put("String", String.class);
        PRIMITIVES.put("int", Integer.TYPE);
        PRIMITIVES.put("boolean", Boolean.TYPE);
        PRIMITIVES.put("byte", Byte.TYPE);
        PRIMITIVES.put("double", Double.TYPE);
        PRIMITIVES.put("float", Float.TYPE);
        PRIMITIVES.put("char", Character.TYPE);
        PRIMITIVES.put("short", Short.TYPE);
        PRIMITIVES.put("long", Long.TYPE);
    }
}

