/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.ServiceFactory;
import de.iip_ecosphere.platform.services.spring.ClasspathJavaCommandBuilder;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceSetup;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.net.NetworkManagerSetup;
import java.util.List;
import org.springframework.cloud.deployer.spi.app.AppDeployer;

public class SpringInstances {
    private static AppDeployer deployer;
    private static SpringCloudServiceSetup config;
    private static List<String> serviceCmdArgs;

    static AppDeployer getDeployer() {
        return deployer;
    }

    public static SpringCloudServiceSetup getConfig() {
        return config;
    }

    static void setDeployer(AppDeployer depl) {
        deployer = depl;
        ClasspathJavaCommandBuilder.installInto(deployer);
    }

    public static void setConfig(SpringCloudServiceSetup cfg) {
        config = cfg;
        if (null != cfg) {
            ServiceFactory.setAasSetup((AasPartRegistry.AasSetup)cfg.getAas());
            ServiceFactory.setNetworkManagerSetup((NetworkManagerSetup)cfg.getNetMgr());
            if (null != serviceCmdArgs) {
                config.setServiceCmdArgs(serviceCmdArgs);
            }
        }
    }

    public static void setServiceCmdArgs(List<String> arguments) {
        if (null == config) {
            serviceCmdArgs = arguments;
        } else {
            config.setServiceCmdArgs(arguments);
        }
    }
}

