/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.AbstractArtifactDescriptor;
import de.iip_ecosphere.platform.services.AbstractServiceDescriptor;
import de.iip_ecosphere.platform.services.AbstractServiceManager;
import de.iip_ecosphere.platform.services.ArtifactDescriptor;
import de.iip_ecosphere.platform.services.ServerWrapper;
import de.iip_ecosphere.platform.services.ServiceDescriptor;
import de.iip_ecosphere.platform.services.ServiceFactoryDescriptor;
import de.iip_ecosphere.platform.services.ServiceManager;
import de.iip_ecosphere.platform.services.ServicesAas;
import de.iip_ecosphere.platform.services.ServicesAasClient;
import de.iip_ecosphere.platform.services.TypedDataConnectorDescriptor;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.services.spring.DescriptorUtils;
import de.iip_ecosphere.platform.services.spring.SpringCloudArtifactDescriptor;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceDescriptor;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceSetup;
import de.iip_ecosphere.platform.services.spring.SpringInstances;
import de.iip_ecosphere.platform.services.spring.descriptor.Server;
import de.iip_ecosphere.platform.services.spring.yaml.YamlArtifact;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.iip_aas.NetworkManagerAasClient;
import de.iip_ecosphere.platform.support.iip_aas.json.JsonUtils;
import de.iip_ecosphere.platform.support.net.NetworkManager;
import de.iip_ecosphere.platform.support.net.NetworkManagerFactory;
import de.iip_ecosphere.platform.support.net.UriResolver;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;

@Component
@Import(value={SpringCloudServiceSetup.class})
public class SpringCloudServiceManager
extends AbstractServiceManager<SpringCloudArtifactDescriptor, SpringCloudServiceDescriptor> {
    public static final String OPT_SERVICE_PREFIX = "iip.service.";
    private static final String PROGRESS_COMPONENT_ID = "Spring Cloud Service Manager";
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringCloudServiceManager.class);
    private Predicate<TypedDataConnectorDescriptor> available = c -> true;
    private Map<SpringCloudServiceDescriptor, de.iip_ecosphere.platform.support.Server> runningServers = new HashMap<SpringCloudServiceDescriptor, de.iip_ecosphere.platform.support.Server>();
    private Supplier<NetworkManager> networkManagerSupplier = () -> {
        NetworkManagerAasClient result = null;
        try {
            result = new NetworkManagerAasClient();
        }
        catch (IOException e) {
            LOGGER.warn("Cannot create network manager AAS client. Using factory-provided network manager, which may be local. AAS server running? {}", (Object)e.getMessage());
            result = NetworkManagerFactory.getInstance();
        }
        return result;
    };

    private SpringCloudServiceManager() {
    }

    public Supplier<NetworkManager> setNetworkManagerClientSupplier(Supplier<NetworkManager> supplier) {
        Supplier<NetworkManager> old = this.networkManagerSupplier;
        if (null != supplier) {
            this.networkManagerSupplier = supplier;
        }
        return old;
    }

    protected Predicate<TypedDataConnectorDescriptor> getAvailablePredicate() {
        if (null == this.available) {
            this.available = ServicesAas.createAvailabilityPredicate((int)SpringInstances.getConfig().getWaitingTime(), (int)SpringInstances.getConfig().getAvailabilityRetryDelay(), (boolean)false);
        }
        return this.available;
    }

    public String addArtifact(URI location) throws ExecutionException {
        LOGGER.info("Adding " + location);
        Transport.sendProcessStatus((String)PROGRESS_COMPONENT_ID, (int)0, (int)1, (String)("Adding artifact " + location));
        try {
            File jarFile = UriResolver.resolveToFile((URI)location, (File)SpringInstances.getConfig().getDownloadDir());
            YamlArtifact yamlArtifact = null;
            if (null != jarFile) {
                yamlArtifact = DescriptorUtils.readFromFile(jarFile);
            } else {
                DescriptorUtils.throwExecutionException("Adding " + location, "Cannot load " + location + ". Must be a (resolved) file.");
            }
            SpringCloudArtifactDescriptor artifact = SpringCloudArtifactDescriptor.createInstance(yamlArtifact, location, jarFile);
            String artifactId = super.addArtifact(artifact.getId(), (AbstractArtifactDescriptor)artifact);
            Transport.sendProcessStatus((String)PROGRESS_COMPONENT_ID, (int)1, (int)1, (String)("Added artifact " + location + "  " + artifactId));
            return artifactId;
        }
        catch (IOException e) {
            DescriptorUtils.throwExecutionException("Adding " + location, e);
            return null;
        }
    }

    private List<String> determineBindingServiceArgs(String ... serviceIds) {
        Set tmp = SpringCloudServiceManager.determineExternalConnections((ServiceManager)this, (String[])serviceIds).stream().filter(c -> SpringCloudServiceManager.isValidId((String)c.getName()) && c.isInput()).map(c -> "--spring.cloud.stream.bindings." + c.getName() + ".binder=external").collect(Collectors.toSet());
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(tmp);
        return result;
    }

    private String determineCloudFunctionArg(String ... serviceIds) {
        return "--spring.cloud.function.definition=" + SpringCloudServiceDescriptor.toFunctionDefinition(SpringCloudServiceManager.determineFunctionalConnections((ServiceManager)this, (String[])serviceIds));
    }

    public static List<String> determineSpringConditionals(ServiceManager mgr, String ... serviceIds) {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<ArtifactDescriptor> artifacts = new HashSet<ArtifactDescriptor>();
        HashSet<String> activeServices = new HashSet<String>();
        for (String id : serviceIds) {
            ServiceDescriptor service = mgr.getService(id);
            artifacts.add(service.getArtifact());
            activeServices.add(id);
        }
        HashSet allServices = new HashSet();
        for (ArtifactDescriptor a : artifacts) {
            allServices.addAll(a.getServiceIds());
        }
        if (activeServices.size() != allServices.size()) {
            for (String id : allServices) {
                result.add("--iip.service." + id + "=" + activeServices.contains(id));
            }
        }
        return result;
    }

    private String[] serviceAndEnsemble(String id, String[] serviceIds) {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(id);
        for (String sId : serviceIds) {
            SpringCloudServiceDescriptor service;
            SpringCloudServiceDescriptor leader;
            if (sId.equals(id) || null == (leader = (service = (SpringCloudServiceDescriptor)this.getService(sId)).getEnsembleLeader()) || !leader.getId().equals(id)) continue;
            tmp.add(service.getId());
        }
        return tmp.toArray(new String[0]);
    }

    public void startService(String ... serviceIds) throws ExecutionException {
        this.startService((Map<String, String>)null, serviceIds);
    }

    private void handleOptions(Map<String, String> options, String[] serviceIds) {
        SpringCloudServiceManager.handleOptions(options, (ServiceManager)this, serviceIds);
    }

    public static void handleOptions(Map<String, String> options, ServiceManager mgr, String ... serviceIds) {
        if (null != options) {
            String opt = options.get("ensemble");
            if (null != opt) {
                SpringCloudServiceManager.handleOptionEnsemble(opt, serviceIds, mgr);
            }
            opt = options.get("args");
            ArrayList<String> argList = null;
            if (null != opt) {
                List tmp = (List)JsonUtils.fromJson((Object)opt, List.class);
                argList = new ArrayList<String>();
                for (Object t : tmp) {
                    argList.add(t.toString());
                }
            }
            for (String sId : serviceIds) {
                mgr.getService(sId).setAdditionalArguments(argList);
            }
        }
    }

    private static void handleOptionEnsemble(String opt, String[] serviceIds, ServiceManager mgr) {
        Map optMap = (Map)JsonUtils.fromJson((Object)opt, Map.class);
        HashSet actServices = new HashSet();
        CollectionUtils.addAll(actServices, (Object[])serviceIds);
        if (null != optMap) {
            for (Map.Entry ent : optMap.entrySet()) {
                String ensemble = ent.getKey().toString();
                String leader = ent.getValue().toString();
                if (!actServices.contains(ensemble)) continue;
                ServiceDescriptor ensDesc = mgr.getService(ensemble);
                ServiceDescriptor leaderDesc = mgr.getService(leader);
                if (!(ensDesc instanceof SpringCloudServiceDescriptor) || !ensDesc.isTopLevel() || leaderDesc != null && !(leaderDesc instanceof SpringCloudServiceDescriptor)) continue;
                LOGGER.info("Changing ensemble leader of {} to {}", (Object)ensDesc.getId(), (Object)(leaderDesc == null ? null : leaderDesc.getId()));
                ((SpringCloudServiceDescriptor)ensDesc).setEnsembleLeader((SpringCloudServiceDescriptor)leaderDesc);
            }
        }
    }

    public static void addAppId(String serviceId, List<String> cmdArgs) {
        String appId = ServiceBase.getApplicationId((String)serviceId) + ServiceBase.getApplicationInstanceId((String)serviceId);
        if (appId.length() > 0) {
            cmdArgs.add("--iip.appId=" + appId);
        }
    }

    private static Set<String> getThisDeviceHostIds() {
        HashSet<String> thisDevice = new HashSet<String>();
        thisDevice.add("localhost");
        thisDevice.add("127.0.0.1");
        thisDevice.add(NetUtils.getOwnHostname());
        thisDevice.add(NetUtils.getOwnIP());
        thisDevice.add(Id.getDeviceId());
        thisDevice.add(Id.getDeviceIdAas());
        return thisDevice;
    }

    private void startServers(Map<String, String> options) {
        NetworkManager netClient;
        String id;
        String opt;
        HashMap<String, String> hostMap = new HashMap<String, String>();
        if (null != options && null != (opt = options.get("servers"))) {
            Map optMap = (Map)JsonUtils.fromJson((Object)opt, Map.class);
            for (Map.Entry ent : optMap.entrySet()) {
                hostMap.put(ent.getKey().toString(), ent.getValue().toString());
            }
        }
        String myHost = NetUtils.getOwnHostname();
        HashMap<String, SpringCloudServiceDescriptor> servers = new HashMap<String, SpringCloudServiceDescriptor>();
        Set<String> thisDevice = SpringCloudServiceManager.getThisDeviceHostIds();
        HashSet<String> knownServers = new HashSet<String>();
        for (SpringCloudArtifactDescriptor desc : this.getArtifacts()) {
            for (SpringCloudServiceDescriptor s : desc.getServers()) {
                id = s.getId();
                knownServers.add(id);
                String host = (String)hostMap.get(id);
                if (null == host) {
                    host = s.getServer().getHost();
                }
                if (!thisDevice.contains(host)) continue;
                servers.put(id, s);
            }
        }
        if (knownServers.size() > 0) {
            LOGGER.info("Preparing server start: Of known servers {} starting {} on this host ({})", new Object[]{knownServers, servers, thisDevice});
        }
        if (servers.size() > 0 && null != (netClient = this.networkManagerSupplier.get())) {
            HashMap<SpringCloudArtifactDescriptor, ClassLoader> loaders = new HashMap<SpringCloudArtifactDescriptor, ClassLoader>();
            for (SpringCloudServiceDescriptor s : servers.values()) {
                id = s.getId();
                if (null != netClient.getPort(id)) continue;
                try {
                    Object o;
                    Server ser = s.getServer();
                    ClassLoader loader = (ClassLoader)loaders.get(s.getArtifact());
                    if (null == loader) {
                        loader = DescriptorUtils.determineArtifactClassLoader(s);
                        loaders.put((SpringCloudArtifactDescriptor)s.getArtifact(), loader);
                    }
                    Class<?> cls = Class.forName(ser.getCls(), true, loader);
                    try {
                        List<String> cmdLine = s.collectCmdArguments(SpringInstances.getConfig(), ser.getPort(), "");
                        o = cls.getConstructor(String[].class).newInstance(new Object[]{cmdLine.toArray(new String[0])});
                    }
                    catch (NoSuchMethodException e) {
                        o = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    if (o instanceof de.iip_ecosphere.platform.support.Server) {
                        ServerWrapper sv = new ServerWrapper((de.iip_ecosphere.platform.support.Server)o);
                        this.setStateSafe((ServiceDescriptor)s, ServiceState.STARTING);
                        ServerAddress adr = new ServerAddress(Schema.IGNORE, myHost, ser.getPort());
                        adr = netClient.reservePort(id, adr);
                        sv.start();
                        this.runningServers.put(s, (de.iip_ecosphere.platform.support.Server)sv);
                        this.setStateSafe((ServiceDescriptor)s, ServiceState.RUNNING);
                        LOGGER.info("Started server {} ", (Object)id);
                        continue;
                    }
                    LOGGER.error("Starting server {}. Specified class does not implement support.Server. Cannot start.", (Object)id);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Starting server {}: Cannot find class {}", (Object)id, (Object)e.getMessage());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LOGGER.error("Starting server {}, cannot invoke constructor: {}", (Object)id, (Object)e.getMessage());
                }
            }
        }
    }

    private void stopServers() {
        NetworkManager netClient;
        ArrayList<SpringCloudServiceDescriptor> servers = new ArrayList<SpringCloudServiceDescriptor>();
        for (SpringCloudArtifactDescriptor desc : this.getArtifacts()) {
            for (SpringCloudServiceDescriptor s : desc.getServers()) {
                if (!this.runningServers.containsKey((Object)s)) continue;
                servers.add(s);
            }
        }
        if (servers.size() > 0 && null != (netClient = this.networkManagerSupplier.get())) {
            for (SpringCloudServiceDescriptor s : servers) {
                String id = s.getId();
                if (netClient.getRegisteredInstances(id) != 0) continue;
                this.setStateSafe((ServiceDescriptor)s, ServiceState.STOPPING);
                de.iip_ecosphere.platform.support.Server sv = this.runningServers.remove((Object)s);
                sv.stop(true);
                netClient.releasePort(id);
                this.setStateSafe((ServiceDescriptor)s, ServiceState.STOPPED);
                LOGGER.info("Stopped server {} ", (Object)id);
            }
        }
    }

    private NetworkManager markServerUse(boolean started, SpringCloudServiceDescriptor service, boolean register, NetworkManager netClient) {
        String id = service.getSvc().getNetMgtKey();
        if (id != null) {
            if (netClient == null) {
                netClient = this.networkManagerSupplier.get();
            }
            if (null != netClient) {
                if (register) {
                    netClient.registerInstance(id, NetUtils.getOwnHostname());
                } else {
                    netClient.unregisterInstance(id, NetUtils.getOwnHostname());
                }
            }
        }
        return netClient;
    }

    private static void reconfigure(SpringCloudServiceDescriptor service, boolean started, Map<String, String> options) throws ExecutionException {
        Map allParams;
        Object tmp;
        String txt;
        if (started && null != options && null != (txt = options.get("params")) && (tmp = (allParams = (Map)JsonUtils.fromJson((Object)txt, Map.class)).get(service.getId())) instanceof Map) {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                for (Map.Entry e : ((Map)tmp).entrySet()) {
                    params.put(e.getKey().toString(), e.getValue().toString());
                }
                ServicesAasClient client = new ServicesAasClient(Id.getDeviceIdAas());
                client.reconfigureService(service.getId(), params);
            }
            catch (IOException e) {
                throw new ExecutionException(e);
            }
        }
    }

    public void startService(Map<String, String> options, String ... serviceIds) throws ExecutionException {
        this.startServers(options);
        serviceIds = SpringCloudServiceManager.pruneServers((ServiceManager)this, (String[])serviceIds);
        this.checkServiceInstances(serviceIds);
        serviceIds = SpringCloudServiceManager.topLevel((ServiceManager)this, (String[])serviceIds);
        this.handleOptions(options, serviceIds);
        AppDeployer deployer = SpringInstances.getDeployer();
        ArrayList<String> errors = new ArrayList<String>();
        LOGGER.info("Starting services {} (options {})", (Object)Arrays.toString(serviceIds), options);
        SpringCloudServiceSetup config = SpringInstances.getConfig();
        int step = 0;
        this.handleFamilyProcesses(serviceIds, true);
        NetworkManager netClient = null;
        List<String> commonServiceArgs = this.determineBindingServiceArgs(serviceIds);
        commonServiceArgs.addAll(config.getServiceCmdArgs());
        for (String sId : this.sortByDependency(serviceIds, true)) {
            Transport.sendProcessStatus((String)PROGRESS_COMPONENT_ID, (int)step, (int)(serviceIds.length + 1), (String)("Starting " + sId));
            SpringCloudServiceDescriptor service = (SpringCloudServiceDescriptor)this.getService(sId);
            if (null == service) {
                errors.add("No service for id '" + sId + "' known.");
            } else {
                LOGGER.info("Preparing {} for start", (Object)sId);
                String[] sIdEns = this.serviceAndEnsemble(sId, serviceIds);
                ArrayList<String> externalServiceArgs = new ArrayList<String>(commonServiceArgs);
                SpringCloudServiceManager.addAppId(sId, externalServiceArgs);
                externalServiceArgs.add(this.determineCloudFunctionArg(sIdEns));
                externalServiceArgs.addAll(SpringCloudServiceManager.determineSpringConditionals((ServiceManager)this, sIdEns));
                AppDeploymentRequest req = service.createDeploymentRequest(config, externalServiceArgs);
                boolean started = false;
                if (null != req) {
                    this.setState((ServiceDescriptor)service, ServiceState.DEPLOYING);
                    LOGGER.info("Starting " + sId);
                    String dId = deployer.deploy(req);
                    this.waitFor(dId, null, s -> null == s || s == DeploymentState.deploying);
                    LOGGER.info("Started " + dId + ": " + deployer.status(dId));
                    service.waitForAdminServer(SpringInstances.getConfig().getWaitingTime());
                    AppStatus status = deployer.status(dId);
                    service.setDeploymentId(dId);
                    if (DeploymentState.deployed == status.getState()) {
                        service.attachStub();
                        this.setState((ServiceDescriptor)service, ServiceState.STARTING);
                        LOGGER.info("Starting " + sId + " completed");
                        started = true;
                    } else {
                        this.setState((ServiceDescriptor)service, ServiceState.FAILED);
                        errors.add("Starting service id '" + sId + "' failed:\n" + SpringInstances.getDeployer().getLog(dId));
                        LOGGER.info("Starting " + dId + " failed");
                    }
                } else {
                    LOGGER.info("Starting ensemble service " + sId);
                    ServiceState ensState = service.getEnsembleLeader().getState();
                    if (ServiceState.RUNNING == ensState) {
                        service.attachStub();
                        this.setState((ServiceDescriptor)service, ServiceState.STARTING);
                        LOGGER.info("Starting ensemble service " + sId + " completed");
                        started = true;
                    } else {
                        this.setState((ServiceDescriptor)service, ServiceState.FAILED);
                        errors.add("Starting ensemble service id '" + sId + "' failed: See " + service.getEnsembleLeader().getId());
                        LOGGER.info("Starting ensemble service " + sId + " failed");
                    }
                }
                SpringCloudServiceManager.reconfigure(service, started, options);
                netClient = this.markServerUse(started, service, true, netClient);
            }
            Transport.sendProcessStatus((String)PROGRESS_COMPONENT_ID, (int)step++, (int)(serviceIds.length + 1), (String)("Started " + sId));
        }
        this.checkErrors(errors);
        LOGGER.info("Started services " + Arrays.toString(serviceIds));
    }

    protected SpringCloudServiceDescriptor instantiateFromTemplate(SpringCloudServiceDescriptor template, String serviceId) {
        SpringCloudServiceDescriptor result = template.instantiate(serviceId);
        ((SpringCloudArtifactDescriptor)result.getArtifact()).addService(result);
        return result;
    }

    private void handleFamilyProcesses(String[] serviceIds, boolean start) throws ExecutionException {
        HashSet<ArtifactDescriptor> artifacts = new HashSet<ArtifactDescriptor>();
        HashSet<String> activeServices = new HashSet<String>();
        for (String id : serviceIds) {
            AbstractServiceDescriptor service = this.getService(id);
            artifacts.add(service.getArtifact());
            activeServices.add(id);
        }
        for (ArtifactDescriptor a : artifacts) {
            for (ServiceDescriptor s : a.getServices()) {
                if (s.isTopLevel() || s.getEnsembleLeader() == null || !activeServices.contains(s.getEnsembleLeader().getId())) continue;
                SpringCloudServiceDescriptor famMember = (SpringCloudServiceDescriptor)this.getService(s.getId());
                LoggerFactory.getLogger(SpringCloudServiceManager.class).info("Preparing processes for non-top-level ensemble service {}", (Object)s.getId());
                if (start) {
                    famMember.startProcess(SpringInstances.getConfig(), famMember.getSvc().getProcess());
                    continue;
                }
                famMember.setState(ServiceState.STOPPING);
            }
        }
    }

    private void checkErrors(List<String> errors) throws ExecutionException {
        if (errors.size() > 0) {
            Object result = "";
            for (String s : errors) {
                if (((String)result).length() > 0) {
                    result = (String)result + "\n";
                }
                result = (String)result + s;
            }
            throw new ExecutionException((String)result, null);
        }
    }

    private DeploymentState waitFor(String id, DeploymentState initState, Predicate<DeploymentState> endCond) {
        AppDeployer deployer = SpringInstances.getDeployer();
        int waitingTime = SpringInstances.getConfig().getWaitingTime();
        long start = System.currentTimeMillis();
        DeploymentState state = null;
        do {
            if (endCond.test(state)) {
                state = deployer.status(id).getState();
                TimeUtils.sleep((int)500);
            }
            if (System.currentTimeMillis() - start <= (long)waitingTime) continue;
            LoggerFactory.getLogger(SpringCloudServiceManager.class).error("While deploying {}: timeout {}", (Object)id, (Object)waitingTime);
            break;
        } while (endCond.test(state));
        return state;
    }

    public void stopService(String ... serviceIds) throws ExecutionException {
        serviceIds = SpringCloudServiceManager.topLevel((ServiceManager)this, (String[])SpringCloudServiceManager.pruneServers((ServiceManager)this, (String[])serviceIds));
        ArrayList<String> errors = new ArrayList<String>();
        AppDeployer deployer = SpringInstances.getDeployer();
        LOGGER.info("Stopping services " + Arrays.toString(serviceIds));
        int step = 0;
        this.handleFamilyProcesses(serviceIds, false);
        NetworkManager netClient = null;
        for (String ids : this.sortByDependency(serviceIds, false)) {
            Transport.sendProcessStatus((String)PROGRESS_COMPONENT_ID, (int)step, (int)(serviceIds.length + 1), (String)("Stopping service " + ids));
            SpringCloudServiceDescriptor service = (SpringCloudServiceDescriptor)this.getService(ids);
            String id = service.getDeploymentId();
            if (null != id) {
                AppStatus status = deployer.status(id);
                if (null != status) {
                    DeploymentState state = status.getState();
                    if (state != null) {
                        this.setState((ServiceDescriptor)service, ServiceState.STOPPING);
                        LOGGER.info("Stopping " + id + "... ");
                        deployer.undeploy(id);
                        state = this.waitFor(id, state, s -> DeploymentState.deployed == s);
                        LOGGER.info("Stopping " + id + "... ");
                        if (null == state || state == DeploymentState.undeployed) {
                            this.setState((ServiceDescriptor)service, ServiceState.STOPPED);
                        } else if (state == DeploymentState.error || state == DeploymentState.failed) {
                            this.setState((ServiceDescriptor)service, ServiceState.FAILED);
                        }
                    } else {
                        this.setState((ServiceDescriptor)service, ServiceState.STOPPING);
                    }
                }
            } else {
                this.setState((ServiceDescriptor)service, ServiceState.STOPPING);
            }
            service.detachStub();
            Transport.sendProcessStatus((String)PROGRESS_COMPONENT_ID, (int)step++, (int)(serviceIds.length + 1), (String)("Stopped service " + ids));
            netClient = this.markServerUse(true, service, false, netClient);
        }
        this.checkErrors(errors);
        LOGGER.info("Stopped services " + Arrays.toString(serviceIds));
        this.stopServers();
    }

    public void migrateService(String serviceId, String resourceId) throws ExecutionException {
        super.migrateService(serviceId, resourceId);
        throw new ExecutionException("not implemented", null);
    }

    public void removeArtifact(String artifactId) throws ExecutionException {
        LOGGER.info("Removing artifact " + artifactId);
        Transport.sendProcessStatus((String)PROGRESS_COMPONENT_ID, (int)0, (int)1, (String)("Removing artifact " + artifactId));
        SpringCloudServiceManager.checkId((String)artifactId, (String)"artifactId");
        SpringCloudArtifactDescriptor desc = (SpringCloudArtifactDescriptor)this.getArtifact(artifactId);
        super.removeArtifact(artifactId);
        if (null != desc) {
            File jar = desc.getJar();
            File downloadDir = SpringInstances.getConfig().getDownloadDir();
            if (null != jar && null != downloadDir && jar.toPath().startsWith(downloadDir.toPath()) && SpringInstances.getConfig().getDeleteArtifacts()) {
                FileUtils.deleteQuietly((File)desc.getJar());
            }
        }
        LOGGER.info("Removed artifact " + artifactId);
        Transport.sendProcessStatus((String)PROGRESS_COMPONENT_ID, (int)1, (int)1, (String)("Removied artifact " + artifactId));
    }

    public void updateService(String serviceId, URI location) throws ExecutionException {
        throw new ExecutionException("not implemented", null);
    }

    public void switchToService(String serviceId, String target) throws ExecutionException {
        super.switchToService(serviceId, target);
        throw new ExecutionException("not implemented", null);
    }

    public void cloneArtifact(String artifactId, URI location) throws ExecutionException {
        throw new ExecutionException("not implemented", null);
    }

    protected void setStateSafe(ServiceDescriptor service, ServiceState state) {
        try {
            this.setState(service, state);
        }
        catch (ExecutionException e) {
            LOGGER.warn("While setting service {} state: {}", (Object)service.getId(), (Object)e.getMessage());
        }
    }

    protected void setState(ServiceDescriptor service, ServiceState state) throws ExecutionException {
        ServiceState old = service.getState();
        ServicesAas.notifyServiceStateChanged((ServiceState)old, (ServiceState)state, (ServiceDescriptor)service, (ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS);
        service.setState(state);
        ServiceState further = service.getState();
        if (further != state) {
            ServicesAas.notifyServiceStateChanged((ServiceState)state, (ServiceState)further, (ServiceDescriptor)service, (ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS);
        }
    }

    public void clear() {
        AppDeployer deployer = SpringInstances.getDeployer();
        for (SpringCloudServiceDescriptor desc : this.getServices()) {
            String deploymentId = desc.getDeploymentId();
            AppStatus status = deployer.status(deploymentId);
            if (DeploymentState.deployed != status.getState()) continue;
            SpringInstances.getDeployer().undeploy(deploymentId);
        }
        super.clear();
    }

    public static class SpringCloudServiceFactoryDescriptor
    implements ServiceFactoryDescriptor {
        public ServiceManager createInstance() {
            return new SpringCloudServiceManager();
        }

        public AasPartRegistry.AasSetup getAasSetup() {
            return null != SpringInstances.getConfig() ? SpringInstances.getConfig().getAas() : null;
        }

        public TransportSetup getTransport() {
            return null != SpringInstances.getConfig() ? SpringInstances.getConfig().getTransport() : null;
        }
    }
}

