/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.AbstractServiceDescriptor;
import de.iip_ecosphere.platform.services.AbstractServiceManager;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.ServiceStub;
import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.services.spring.DescriptorUtils;
import de.iip_ecosphere.platform.services.spring.SpringCloudArtifactDescriptor;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceSetup;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceTypedConnectorData;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceTypedData;
import de.iip_ecosphere.platform.services.spring.SpringInstances;
import de.iip_ecosphere.platform.services.spring.Utils;
import de.iip_ecosphere.platform.services.spring.descriptor.Endpoint;
import de.iip_ecosphere.platform.services.spring.descriptor.ProcessSpec;
import de.iip_ecosphere.platform.services.spring.descriptor.Relation;
import de.iip_ecosphere.platform.services.spring.descriptor.Server;
import de.iip_ecosphere.platform.services.spring.descriptor.Service;
import de.iip_ecosphere.platform.services.spring.descriptor.TypeResolver;
import de.iip_ecosphere.platform.services.spring.descriptor.TypedData;
import de.iip_ecosphere.platform.services.spring.yaml.YamlProcess;
import de.iip_ecosphere.platform.services.spring.yaml.YamlService;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import de.iip_ecosphere.platform.support.net.ManagedServerAddress;
import de.iip_ecosphere.platform.support.net.NetworkManager;
import de.iip_ecosphere.platform.support.net.NetworkManagerFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class SpringCloudServiceDescriptor
extends AbstractServiceDescriptor<SpringCloudArtifactDescriptor> {
    private Service service;
    private SpringCloudServiceDescriptor ensembleLeader;
    private String deploymentId;
    private List<String> portKeys = new ArrayList<String>();
    private Process process;
    private File processDir;
    private String serviceProtocol;
    private ManagedServerAddress adminAddr;
    private Server server;

    public SpringCloudServiceDescriptor(Service service, TypeResolver resolver) {
        super(service.getId(), service.getApplicationId(), service.getName(), service.getDescription(), service.getVersion());
        this.setClassification(service.getKind(), service.isDeployable(), service.isTopLevel());
        this.service = service;
        for (TypedData typedData : service.getParameters()) {
            this.addParameter(new SpringCloudServiceTypedData(typedData.getName(), typedData.getDescription(), resolver.resolve(typedData.getType())));
        }
        for (Relation relation : service.getRelations()) {
            if (Relation.Direction.IN == relation.getDirection()) {
                this.addInputDataConnector(new SpringCloudServiceTypedConnectorData(relation.getId(), relation.getChannel(), relation.getDescription(), resolver.resolve(relation.getType()), relation.getService(), relation.getFunction()));
                continue;
            }
            if (Relation.Direction.OUT != relation.getDirection()) continue;
            this.addOutputDataConnector(new SpringCloudServiceTypedConnectorData(relation.getId(), relation.getChannel(), relation.getDescription(), resolver.resolve(relation.getType()), relation.getService(), relation.getFunction()));
        }
    }

    protected SpringCloudServiceDescriptor(String id, String applicationId, String name, String description, Version version) {
        super(id, applicationId, name, description, version);
    }

    static SpringCloudServiceDescriptor createFor(Server server) {
        de.iip_ecosphere.platform.services.environment.YamlService svc = server.toService();
        YamlService ssvc = new YamlService();
        ssvc.setDeployable(true);
        ssvc.setDescription(svc.getDescription());
        ssvc.setVersion(svc.getVersion());
        ssvc.setKind(svc.getKind());
        ssvc.setId(svc.getId());
        ssvc.setName(svc.getName());
        ssvc.setTopLevel(svc.isTopLevel());
        YamlProcess sprc = new YamlProcess();
        sprc.setExecutable(server.getExecutable());
        sprc.setExecutablePath(server.getExecutablePath());
        sprc.setHomePath(server.getHomePath());
        sprc.setArtifacts(server.getArtifacts());
        sprc.setWaitTime(server.getWaitTime());
        ssvc.setProcess(sprc);
        ssvc.setTransportChannel(svc.getTransportChannel());
        ssvc.setCmdArg(svc.getProcess().getCmdArg());
        SpringCloudServiceDescriptor result = new SpringCloudServiceDescriptor(svc.getId(), svc.getApplicationId(), svc.getName(), svc.getDescription(), svc.getVersion());
        result.service = ssvc;
        result.setClassification(svc.getKind(), svc.isDeployable(), svc.isTopLevel());
        result.server = server;
        return result;
    }

    Server getServer() {
        return this.server;
    }

    SpringCloudServiceDescriptor instantiate(String sId) {
        SpringCloudServiceDescriptor result = new SpringCloudServiceDescriptor(sId, this.getApplicationId(), this.getName(), this.getDescription(), this.getVersion());
        result.instantiateFrom(this);
        result.service = this.service;
        if (null != this.ensembleLeader) {
            String ensId = this.ensembleLeader.getServiceId();
            String appInstanceId = ServiceBase.getApplicationInstanceId((String)sId);
            String appId = ServiceBase.getApplicationId((String)sId);
            ensId = ServiceBase.composeId((String)ensId, (String)appId, (String)appInstanceId);
            result.ensembleLeader = (SpringCloudServiceDescriptor)((SpringCloudArtifactDescriptor)this.getArtifact()).getService(ensId);
            if (null == result.ensembleLeader) {
                result = this.ensembleLeader.instantiate(ensId);
                ((SpringCloudArtifactDescriptor)this.getArtifact()).addService(result);
            }
        }
        return result;
    }

    protected Class<SpringCloudArtifactDescriptor> getArtifactDescriptorClass() {
        return SpringCloudArtifactDescriptor.class;
    }

    public void setState(ServiceState state) throws ExecutionException {
        super.setState(state);
        if (ServiceState.STOPPING == state) {
            this.release();
        }
    }

    private void release() {
        if (null != this.process) {
            this.process.destroy();
            this.process = null;
        }
        if (null != this.processDir) {
            FileUtils.deleteQuietly((File)this.processDir);
        }
        NetworkManager mgr = NetworkManagerFactory.getInstance();
        for (String key : this.portKeys) {
            mgr.releasePort(key);
        }
        this.portKeys.clear();
        this.adminAddr = null;
    }

    private ManagedServerAddress registerPort(NetworkManager mgr, String key) {
        ManagedServerAddress result = mgr.obtainPort(key);
        if (result.isNew()) {
            this.portKeys.add(key);
        }
        return result;
    }

    void setEnsembleLeader(SpringCloudServiceDescriptor ensembleLeader) {
        this.ensembleLeader = ensembleLeader;
    }

    public String getGroup() {
        return ((SpringCloudArtifactDescriptor)this.getArtifact()).getId();
    }

    public SpringCloudServiceDescriptor getEnsembleLeader() {
        return this.ensembleLeader;
    }

    AppDeploymentRequest createDeploymentRequest(SpringCloudServiceSetup config, List<String> cmdArgs) throws ExecutionException {
        AppDeploymentRequest result = null;
        if (null == this.ensembleLeader) {
            NetworkManager mgr = NetworkManagerFactory.getInstance();
            HashMap<String, String> appProps = new HashMap<String, String>();
            HashMap<String, String> deployProps = new HashMap<String, String>();
            FileSystemResource res = new FileSystemResource(((SpringCloudArtifactDescriptor)this.getArtifact()).getJar());
            deployProps.put("spring.cloud.deployer.group", this.getGroup());
            Utils.addPropertyIfPositiveToInt(deployProps, "spring.cloud.deployer.count", this.service.getInstances(), "1");
            deployProps.put("spring.cloud.deployer.indexed", "false");
            Utils.addPropertyIfPositiveToMeBi(deployProps, "spring.cloud.deployer.memory", this.service.getMemory(), null);
            Utils.addPropertyIfPositiveToMeBi(deployProps, "spring.cloud.deployer.disk", this.service.getDisk(), null);
            Utils.addPropertyIfPositiveToInt(deployProps, "spring.cloud.deployer.cpu", this.service.getCpus(), "1");
            ManagedServerAddress springAddr = this.registerPort(mgr, "spring_" + this.getId());
            appProps.put("server.port", String.valueOf(springAddr.getPort()));
            this.adminAddr = this.registerPort(mgr, Starter.getServiceCommandNetworkMgrKey((String)this.getId()));
            this.serviceProtocol = config.getServiceProtocol();
            List<String> cmdLine = this.collectCmdArguments(config, this.adminAddr.getPort(), this.serviceProtocol);
            for (Relation relation : this.service.getRelations()) {
                Endpoint endpoint = relation.getEndpoint();
                if (relation.getChannel().length() == 0) {
                    DescriptorUtils.addEndpointArgs(cmdLine, endpoint, this.getTransportPort(config), this.getTransportHost(config));
                    continue;
                }
                ManagedServerAddress adr = this.registerPort(mgr, relation.getChannel());
                DescriptorUtils.addEndpointArgs(cmdLine, endpoint, (ServerAddress)adr);
            }
            ProcessSpec pSpec = this.service.getProcess();
            if (null != pSpec) {
                ManagedServerAddress managedServerAddress = this.registerPort(mgr, this.getStreamingNetmanagerKey());
                DescriptorUtils.addEndpointArgs(cmdLine, pSpec.getServiceStreamEndpoint(), (ServerAddress)managedServerAddress);
                ArrayList procCmdLine = new ArrayList();
                procCmdLine.addAll(pSpec.getCmdArg());
                DescriptorUtils.addEndpointArgs(cmdLine, pSpec.getStreamEndpoint(), (ServerAddress)managedServerAddress);
                ManagedServerAddress adrAas = this.registerPort(mgr, this.getAasNetmanagerKey());
                DescriptorUtils.addEndpointArgs(cmdLine, pSpec.getAasEndpoint(), (ServerAddress)adrAas);
                int procPort = this.startProcess(config, pSpec);
                if (procPort > 0) {
                    cmdLine.add(Starter.composeArgument((String)Starter.getServicePortName((String)this.getId()), (Object)procPort));
                }
            }
            if (null != cmdArgs) {
                cmdLine.addAll(cmdArgs);
            }
            Starter.addAppEnvironment(cmdLine);
            if (null != this.getAdditionalArguments()) {
                cmdLine.addAll(this.getAdditionalArguments());
            }
            AppDefinition appDefinition = new AppDefinition(this.getId(), appProps);
            result = new AppDeploymentRequest(appDefinition, (Resource)res, deployProps, cmdLine);
        }
        return result;
    }

    List<String> collectCmdArguments(SpringCloudServiceSetup config, int port, String protocol) {
        ArrayList<String> cmdLine = new ArrayList<String>();
        if (null != config.getJavaOpts()) {
            cmdLine.addAll(config.getJavaOpts());
        }
        cmdLine.addAll(this.service.getCmdArg(port, protocol));
        return cmdLine;
    }

    private String getTransportHost(SpringCloudServiceSetup setup) {
        String result = setup.getTransport().getHost() == null ? setup.getBrokerHost() : setup.getTransport().getHost();
        return result;
    }

    private int getTransportPort(SpringCloudServiceSetup setup) {
        int result = setup.getTransport().getHost() == null ? setup.getBrokerPort() : setup.getTransport().getPort();
        return result;
    }

    void attachStub() {
        InvocablesCreator iCreator = this.getInvocablesCreator();
        if (null != iCreator) {
            this.setStub(new ServiceStub(iCreator, this.getId()));
        }
    }

    void waitForAdminServer(int waitingTime) {
        if (null != this.adminAddr) {
            ProtocolServerBuilder psb = AasFactory.getInstance().createProtocolServerBuilder(this.serviceProtocol, this.adminAddr.getPort());
            psb.isAvailable(this.adminAddr.getHost(), waitingTime);
        }
    }

    void detachStub() {
        this.setStub(null);
    }

    public InvocablesCreator getInvocablesCreator() {
        String proto;
        ManagedServerAddress addr;
        InvocablesCreator iCreator = null;
        SpringCloudServiceDescriptor leader = this.getEnsembleLeader();
        if (null != leader) {
            addr = leader.adminAddr;
            proto = leader.serviceProtocol;
        } else {
            addr = this.adminAddr;
            proto = this.serviceProtocol;
        }
        if (null != addr) {
            iCreator = AasFactory.getInstance().createInvocablesCreator(proto, addr.getHost(), addr.getPort());
        }
        return iCreator;
    }

    int startProcess(SpringCloudServiceSetup config, ProcessSpec pSpec) throws ExecutionException {
        int result = -1;
        try {
            this.processDir = Starter.extractProcessArtifacts((String)this.getId(), (de.iip_ecosphere.platform.services.environment.ProcessSpec)pSpec, (File)((SpringCloudArtifactDescriptor)this.getArtifact()).getJar(), (File)SpringInstances.getConfig().getDownloadDir());
            if (!pSpec.isStarted()) {
                NetworkManager mgr = NetworkManagerFactory.getInstance();
                String serviceProtocol = config.getServiceProtocol();
                ManagedServerAddress procAdr = this.registerPort(mgr, Starter.getServiceProcessNetworkMgrKey((String)this.getId()));
                ArrayList<String> args = new ArrayList<String>();
                args.add(config.getExecutable(pSpec.getExecutable()));
                args.addAll(pSpec.getCmdArg(procAdr.getPort(), serviceProtocol));
                ProcessBuilder processBuilder = new ProcessBuilder(args);
                processBuilder.directory(this.processDir);
                processBuilder.inheritIO();
                this.process = processBuilder.start();
                if (pSpec.getWaitTime() > 0) {
                    TimeUtils.sleep((int)pSpec.getWaitTime());
                }
                result = procAdr.getPort();
            }
        }
        catch (IOException e) {
            this.release();
            throw new ExecutionException(e);
        }
        return result;
    }

    private String getStreamingNetmanagerKey() {
        return this.getId() + "_stream";
    }

    String getAasNetmanagerKey() {
        return this.getId() + "_aas";
    }

    void setDeploymentId(String id) {
        this.deploymentId = id;
    }

    String getDeploymentId() {
        return this.deploymentId;
    }

    public Service getSvc() {
        return this.service;
    }

    public static String toFunctionDefinition(Set<AbstractServiceManager.TypedDataConnection> conn) {
        return conn.stream().filter(c -> c.getFunction() != null && c.getFunction().length() > 0).map(c -> c.getFunction()).distinct().collect(Collectors.joining(";"));
    }
}

