/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.AbstractArtifactDescriptor;
import de.iip_ecosphere.platform.services.AbstractServiceDescriptor;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceDescriptor;
import de.iip_ecosphere.platform.services.spring.descriptor.Server;
import de.iip_ecosphere.platform.services.spring.descriptor.TypeResolver;
import de.iip_ecosphere.platform.services.spring.yaml.YamlArtifact;
import de.iip_ecosphere.platform.services.spring.yaml.YamlService;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SpringCloudArtifactDescriptor
extends AbstractArtifactDescriptor<SpringCloudServiceDescriptor> {
    private File jar;

    SpringCloudArtifactDescriptor(YamlArtifact artifact, URI uri, File jar, List<SpringCloudServiceDescriptor> services) {
        super(artifact.getId(), artifact.getName(), uri, services, SpringCloudArtifactDescriptor.createServersList(artifact));
        this.jar = jar;
    }

    private static List<SpringCloudServiceDescriptor> createServersList(YamlArtifact artifact) {
        ArrayList<SpringCloudServiceDescriptor> result = new ArrayList<SpringCloudServiceDescriptor>();
        for (Server server : artifact.getServers()) {
            result.add(SpringCloudServiceDescriptor.createFor(server));
        }
        return result;
    }

    public File getJar() {
        return this.jar;
    }

    public static SpringCloudArtifactDescriptor createInstance(YamlArtifact artifact, URI uri, File jarFile) {
        ArrayList<SpringCloudServiceDescriptor> services = new ArrayList<SpringCloudServiceDescriptor>();
        TypeResolver resolver = new TypeResolver(artifact.getTypes());
        HashMap<String, SpringCloudServiceDescriptor> descriptors = new HashMap<String, SpringCloudServiceDescriptor>();
        for (YamlService s : artifact.getServices()) {
            SpringCloudServiceDescriptor desc = new SpringCloudServiceDescriptor(s, resolver);
            descriptors.put(desc.getId(), desc);
            services.add(desc);
        }
        for (YamlService s : artifact.getServices()) {
            if (null == s.getEnsembleWith()) continue;
            SpringCloudServiceDescriptor service = (SpringCloudServiceDescriptor)((Object)descriptors.get(s.getId()));
            SpringCloudServiceDescriptor ensembleLeader = (SpringCloudServiceDescriptor)((Object)descriptors.get(s.getEnsembleWith()));
            if (null == ensembleLeader || null == service) continue;
            service.setEnsembleLeader(ensembleLeader);
        }
        return new SpringCloudArtifactDescriptor(artifact, uri, jarFile, services);
    }

    protected void addService(SpringCloudServiceDescriptor service) {
        super.addService((AbstractServiceDescriptor)service);
    }
}

