/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.environment.ProcessSpec;
import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.services.spring.SpringCloudArtifactDescriptor;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceDescriptor;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceManager;
import de.iip_ecosphere.platform.services.spring.SpringInstances;
import de.iip_ecosphere.platform.services.spring.descriptor.Endpoint;
import de.iip_ecosphere.platform.services.spring.descriptor.Relation;
import de.iip_ecosphere.platform.services.spring.descriptor.Validator;
import de.iip_ecosphere.platform.services.spring.yaml.YamlArtifact;
import de.iip_ecosphere.platform.services.spring.yaml.YamlProcess;
import de.iip_ecosphere.platform.services.spring.yaml.YamlService;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.JarUtils;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.ZipUtils;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.support.setup.CmdLine;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.loader.JarLauncher;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.JarFileArchive;

public class DescriptorUtils {
    public static YamlArtifact readFromFile(File file) throws ExecutionException {
        YamlArtifact result;
        block7: {
            result = null;
            if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
                try {
                    String descName = DescriptorUtils.getDescriptorName();
                    DescriptorUtils.getLogger().info("Reading artifact " + file + ", descriptor " + descName);
                    InputStream descStream = JarUtils.findFile((InputStream)new FileInputStream(file), (String)("BOOT-INF/classes/" + descName));
                    if (null == descStream) {
                        descStream = JarUtils.findFile((InputStream)new FileInputStream(file), (String)descName);
                    }
                    if (null != descStream) {
                        result = YamlArtifact.readFromYaml(descStream);
                        FileUtils.closeQuietly((Closeable)descStream);
                        Validator val = new Validator();
                        val.validate(result);
                        if (val.hasMessages()) {
                            DescriptorUtils.throwExecutionException("Adding " + file, "Problems in descriptor:\n" + val.getMessages());
                        }
                        break block7;
                    }
                    DescriptorUtils.throwExecutionException("Reading artifact " + file, descName + " does not exist in " + file);
                }
                catch (IOException e) {
                    DescriptorUtils.throwExecutionException("Reading artifact " + file, e);
                }
            } else {
                DescriptorUtils.throwExecutionException("Reading artifact " + file, file + " is not considered as service artifact (JAR, ZIP)");
            }
        }
        return result;
    }

    private static String getDescriptorName() {
        String descName = "deployment.yml";
        if (null != SpringInstances.getConfig()) {
            descName = SpringInstances.getConfig().getDescriptorName();
        }
        return descName;
    }

    public static YamlArtifact readFromClasspath() throws ExecutionException {
        YamlArtifact result = null;
        String descName = DescriptorUtils.getDescriptorName();
        InputStream descStream = ResourceLoader.getResourceAsStream(DescriptorUtils.class, (String)descName, (ResourceResolver[])new ResourceResolver[0]);
        if (null != descStream) {
            try {
                result = YamlArtifact.readFromYaml(descStream);
            }
            catch (IOException e) {
                DescriptorUtils.throwExecutionException("Reading deployment descriptor " + descName, e);
            }
            FileUtils.closeQuietly((Closeable)descStream);
        } else {
            DescriptorUtils.throwExecutionException("Reading deployment descriptor", descName + " not found on classpath");
        }
        return result;
    }

    public static void throwExecutionException(String action, Throwable th) throws ExecutionException {
        DescriptorUtils.getLogger().error(action + ": " + th.getMessage());
        throw new ExecutionException(th);
    }

    public static void throwExecutionException(String action, String message) throws ExecutionException {
        DescriptorUtils.getLogger().error(action + ": " + message);
        throw new ExecutionException(message, null);
    }

    public static void addEndpointArgs(List<String> cmdLine, Endpoint endpoint, ServerAddress addr) {
        DescriptorUtils.addEndpointArgs(cmdLine, endpoint, addr.getPort(), addr.getHost());
    }

    public static void addEndpointArgs(List<String> cmdLine, Endpoint endpoint, int port, String host) {
        if (null != endpoint) {
            CmdLine.parseToArgs((String)endpoint.getPortArg(port), cmdLine);
            if (endpoint.getHostArg().length() > 0) {
                CmdLine.parseToArgs((String)endpoint.getHostArg(host), cmdLine);
            }
        }
    }

    public static List<String> createStandaloneCommandArgs(File jar, int brokerPort, String brokerHost, int adminPort, String serviceProtocol) throws IOException, ExecutionException {
        return DescriptorUtils.createStandaloneCommandArgs(jar, brokerPort, brokerHost, adminPort, serviceProtocol, -1);
    }

    public static List<String> createStandaloneCommandArgs(File jar, int brokerPort, String brokerHost, int adminPort, String serviceProtocol, int springPort) throws IOException, ExecutionException {
        if (springPort < 0) {
            springPort = NetUtils.getEphemeralPort();
        }
        if (!jar.exists()) {
            throw new IOException("Cannot find Spring service binary '" + jar.getAbsolutePath() + "'. Did you run the instantiation process?");
        }
        YamlArtifact art = DescriptorUtils.readFromFile(jar);
        ArrayList<String> result = new ArrayList<String>();
        result.add("java");
        result.add("-jar");
        result.add("-Dlog4j2.formatMsgNoLookups=true");
        Starter.addAppEnvironment(result);
        result.add(jar.getAbsolutePath());
        result.add("--iip.test.service.autostart=true");
        result.add("--iip.test.transport.port=" + brokerPort);
        result.add("--amqp.port=" + brokerPort);
        result.add("--mqtt.port=" + brokerPort);
        result.add("--server.port=" + springPort);
        ArrayList<String> tmp = new ArrayList<String>();
        for (YamlService service : art.getServices()) {
            YamlProcess proc = service.getProcess();
            if (null != proc) {
                File d = Starter.extractProcessArtifacts((String)service.getId(), (ProcessSpec)proc, (File)jar, null);
                FileUtils.deleteOnExit((File)d);
            }
            for (Relation relation : service.getRelations()) {
                DescriptorUtils.addEndpointArgs(tmp, relation.getEndpoint(), brokerPort, brokerHost);
            }
            tmp.addAll(service.getCmdArg(adminPort, serviceProtocol));
        }
        HashSet tmp2 = new HashSet(tmp);
        result.addAll(tmp2);
        return result;
    }

    public static ClassLoader createClassLoader(File jarFile) throws Exception {
        AccessibleJarLauncher launcher = new AccessibleJarLauncher((Archive)new JarFileArchive(jarFile));
        return launcher.createClassLoader();
    }

    public static ClassLoader determineArtifactClassLoader(SpringCloudArtifactDescriptor artifact, File homeDir) {
        ClassLoader loader = SpringCloudServiceManager.class.getClassLoader();
        String artId = artifact.getId();
        File jar = artifact.getJar();
        String jarName = jar.getName();
        if (jarName.endsWith(".jar")) {
            DescriptorUtils.getLogger().info("Creating Spring classloader for {}/{}", (Object)artId, (Object)jar);
            try {
                loader = DescriptorUtils.createClassLoader(jar);
            }
            catch (Exception e) {
                DescriptorUtils.getLogger().warn("Cannot create Spring classloader for {}: {}", (Object)jar, (Object)e.getMessage());
            }
        } else if (jarName.endsWith(".zip")) {
            try {
                File tmp = homeDir;
                if (null == tmp) {
                    tmp = FileUtils.createTmpFolder((String)FileUtils.sanitizeFileName((String)artId), (boolean)true);
                }
                DescriptorUtils.getLogger().info("Creating URL classloader for {}/{} unpacked to {}", new Object[]{artId, jar, tmp});
                tmp.deleteOnExit();
                ZipUtils.extractZip((InputStream)new FileInputStream(jar), (Path)tmp.toPath());
                ArrayList jars = new ArrayList();
                FileUtils.listFiles((File)tmp, f -> f.isDirectory() || f.getName().endsWith(".jar"), f -> DescriptorUtils.addUrlSafe(jars, f));
                DescriptorUtils.getLogger().info("Jars in classpath for {}: {}", (Object)artId, jars);
                loader = new URLClassLoader(jars.toArray(new URL[jars.size()]));
            }
            catch (IOException e) {
                DescriptorUtils.getLogger().warn("Cannot unpack ZIP {}. Classloading may fail", (Object)jar, (Object)e.getMessage());
            }
        }
        return loader;
    }

    private static void addUrlSafe(List<URL> urls, File file) {
        if (file.isFile()) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                DescriptorUtils.getLogger().warn("Cannot turn file {} into URL. Classpath may be incomplete: {}", (Object)file, (Object)e.getMessage());
            }
        }
    }

    public static ClassLoader determineArtifactClassLoader(SpringCloudServiceDescriptor service) {
        File homePath = null;
        if (null != service.getSvc() && null != service.getSvc().getProcess()) {
            homePath = service.getSvc().getProcess().getHomePath();
        }
        return DescriptorUtils.determineArtifactClassLoader((SpringCloudArtifactDescriptor)service.getArtifact(), homePath);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(DescriptorUtils.class);
    }

    public static class AccessibleJarLauncher
    extends JarLauncher {
        public AccessibleJarLauncher(Archive archive) {
            super(archive);
        }

        public ClassLoader createClassLoader() throws Exception {
            return this.createClassLoader(this.getClassPathArchivesIterator());
        }
    }
}

