/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.spring.SpringCloudServiceSetup;
import de.iip_ecosphere.platform.services.spring.StartupApplicationListener;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import java.util.concurrent.ExecutionException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.local.LocalAppDeployer;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;
import test.de.iip_ecosphere.platform.services.spring.AbstractTestServiceManager;

@SpringBootTest(classes={Config.class})
@TestPropertySource(locations={"classpath:iipecosphere.yml"})
@ContextConfiguration(initializers={Initializer.class})
@Import(value={SpringCloudServiceSetup.class})
@RunWith(value=SpringRunner.class)
public class ZipCpServiceManagerTest
extends AbstractTestServiceManager {
    private static final ServerAddress BROKER = new ServerAddress(Schema.IGNORE);

    @BeforeClass
    public static void init() {
        ZipCpServiceManagerTest.init(BROKER);
    }

    @AfterClass
    public static void shutdown() {
        AbstractTestServiceManager.shutdown();
    }

    @Ignore(value="Instable termination")
    @Test
    public void testWithZipArchiveAndClasspath() throws ExecutionException {
        this.testWithZipArchive(true);
        ZipCpServiceManagerTest.assertReceiverLog();
    }

    @Configuration
    @EnableConfigurationProperties(value={LocalDeployerProperties.class})
    public static class Config {
        @Bean
        public AppDeployer appDeployer(LocalDeployerProperties properties) {
            return new LocalAppDeployer(properties);
        }

        @Component
        class Startup
        extends StartupApplicationListener {
            Startup() {
            }
        }
    }

    @Import(value={SpringCloudServiceSetup.class})
    public static class Initializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        public void initialize(ConfigurableApplicationContext applicationContext) {
            TestPropertyValues.of((String[])new String[]{"service-mgr.brokerPort=" + BROKER.getPort()}).applyTo(applicationContext);
        }
    }
}

