/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.ArtifactDescriptor;
import de.iip_ecosphere.platform.services.ServiceDescriptor;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceDescriptor;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceSetup;
import de.iip_ecosphere.platform.services.spring.StartupApplicationListener;
import de.iip_ecosphere.platform.services.spring.descriptor.ProcessSpec;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.local.LocalAppDeployer;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;
import test.de.iip_ecosphere.platform.services.spring.AbstractTestServiceManager;

@SpringBootTest(classes={Config.class})
@TestPropertySource(locations={"classpath:iipecosphere.yml"})
@ContextConfiguration(initializers={Initializer.class})
@Import(value={SpringCloudServiceSetup.class})
@RunWith(value=SpringRunner.class)
public class SimpleStartStopServiceManagerTest
extends AbstractTestServiceManager {
    private static final ServerAddress BROKER = new ServerAddress(Schema.IGNORE);

    @BeforeClass
    public static void init() {
        SimpleStartStopServiceManagerTest.init(BROKER);
    }

    @AfterClass
    public static void shutdown() {
        AbstractTestServiceManager.shutdown();
    }

    @Test
    public void testSimpleStartStop() throws ExecutionException, IOException {
        this.doTestStartStop("deployment.yml", new AbstractTestServiceManager.ArtifactAsserter(){
            private File homePath;

            @Override
            public void testDeployment(ArtifactDescriptor aDesc) {
                ServiceDescriptor sDesc = aDesc.getService("simpleStream-create");
                Assert.assertTrue((boolean)(sDesc instanceof SpringCloudServiceDescriptor));
                ProcessSpec pspec = ((SpringCloudServiceDescriptor)sDesc).getSvc().getProcess();
                Assert.assertNotNull((Object)pspec);
                Assert.assertTrue((boolean)pspec.isStarted());
                Assert.assertNotNull((Object)pspec.getArtifacts());
                Assert.assertEquals((long)2L, (long)pspec.getArtifacts().size());
                this.homePath = pspec.getHomePath();
                Assert.assertNotNull((Object)this.homePath);
                Assert.assertTrue((this.homePath.toString().indexOf("${tmp}") < 0 ? 1 : 0) != 0);
                Assert.assertNotNull((Object)pspec.getExecutablePath());
                Assert.assertTrue((pspec.getExecutablePath().toString().indexOf("${tmp}") < 0 ? 1 : 0) != 0);
                AbstractTestServiceManager.assertFileExists(new File(this.homePath, "test.txt"));
                AbstractTestServiceManager.assertFileExists(new File(this.homePath, "test2.txt"));
                sDesc = aDesc.getServer("java-server");
                Assert.assertTrue((boolean)(sDesc instanceof SpringCloudServiceDescriptor));
                Assert.assertEquals((Object)ServiceState.RUNNING, (Object)sDesc.getState());
            }

            @Override
            public void cleanup(ArtifactDescriptor aDesc) {
                FileUtils.deleteQuietly((File)this.homePath);
                ServiceDescriptor sDesc = aDesc.getServer("java-server");
                Assert.assertTrue((boolean)(sDesc instanceof SpringCloudServiceDescriptor));
                Assert.assertEquals((Object)ServiceState.STOPPED, (Object)sDesc.getState());
            }
        }, false);
    }

    @Test
    public void testSetup() {
        Assert.assertNotNull((Object)this.getConfig().getJavaOpts());
        Assert.assertTrue((this.getConfig().getJavaOpts().size() > 0 ? 1 : 0) != 0);
    }

    @Configuration
    @EnableConfigurationProperties(value={LocalDeployerProperties.class})
    public static class Config {
        @Bean
        public AppDeployer appDeployer(LocalDeployerProperties properties) {
            return new LocalAppDeployer(properties);
        }

        @Component
        class Startup
        extends StartupApplicationListener {
            Startup() {
            }
        }
    }

    @Import(value={SpringCloudServiceSetup.class})
    public static class Initializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        public void initialize(ConfigurableApplicationContext applicationContext) {
            TestPropertyValues.of((String[])new String[]{"service-mgr.brokerPort=" + BROKER.getPort()}).applyTo(applicationContext);
        }
    }
}

