/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.AbstractServiceManager;
import de.iip_ecosphere.platform.services.ArtifactDescriptor;
import de.iip_ecosphere.platform.services.ServiceDescriptor;
import de.iip_ecosphere.platform.services.ServiceManager;
import de.iip_ecosphere.platform.services.TypedDataConnectorDescriptor;
import de.iip_ecosphere.platform.services.TypedDataDescriptor;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.services.spring.SpringCloudArtifactDescriptor;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceDescriptor;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceManager;
import de.iip_ecosphere.platform.services.spring.yaml.YamlArtifact;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.iip_aas.config.CmdLine;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;

public class ServiceMgrAndDescriptorTest {
    static ServiceManager createServiceManager(File descriptor) throws IOException {
        YamlArtifact art = YamlArtifact.readFromYaml((InputStream)new FileInputStream(descriptor));
        SpringCloudArtifactDescriptor aDesc = SpringCloudArtifactDescriptor.createInstance((YamlArtifact)art, (URI)descriptor.toURI(), (File)descriptor);
        return new MockServiceManager(aDesc);
    }

    private static void assertFunctionDef(String expected, ServiceManager mgr, String ... serviceId) {
        Set conn = AbstractServiceManager.determineInternalConnections((ServiceManager)mgr, (String[])serviceId);
        String tmp = SpringCloudServiceDescriptor.toFunctionDefinition((Set)conn);
        String[] exp = expected.split(";");
        if (exp.length == 1) {
            Assert.assertEquals((Object)expected, (Object)tmp);
        } else {
            for (String e : exp) {
                Assert.assertTrue((tmp.startsWith(e) || tmp.endsWith(e) || tmp.contains(";" + e + ";") ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testInternalConnections() throws IOException {
        ServiceManager mgr = ServiceMgrAndDescriptorTest.createServiceManager(new File("src/test/resources/ServiceMesh3Deployment.yml"));
        ServiceMgrAndDescriptorTest.assertFunctionDef("receiveRec13_SimpleReceiver3", mgr, "SimpleReceiver3");
        ServiceMgrAndDescriptorTest.assertFunctionDef("createRec13_SimpleSource3", mgr, "SimpleSource3");
        ServiceMgrAndDescriptorTest.assertFunctionDef("transformRec13Rec13_SimpleTransformer3", mgr, "SimpleTransformer3");
        ServiceMgrAndDescriptorTest.assertFunctionDef("receiveRec13_SimpleReceiver3;transformRec13Rec13_SimpleTransformer3", mgr, "SimpleReceiver3", "SimpleTransformer3");
        ServiceMgrAndDescriptorTest.assertFunctionDef("createRec13_SimpleSource3;transformRec13Rec13_SimpleTransformer3", mgr, "SimpleSource3", "SimpleTransformer3");
        ServiceMgrAndDescriptorTest.assertFunctionDef("receiveRec13_SimpleReceiver3;createRec13_SimpleSource3;transformRec13Rec13_SimpleTransformer3", mgr, "SimpleSource3", "SimpleReceiver3", "SimpleTransformer3");
    }

    @Test
    public void testSpringConditionals() throws IOException {
        ServiceManager mgr = ServiceMgrAndDescriptorTest.createServiceManager(new File("src/test/resources/ServiceMesh3Deployment.yml"));
        List args = SpringCloudServiceManager.determineSpringConditionals((ServiceManager)mgr, (String[])new String[]{"SimpleTransformer3", "SimpleReceiver3"});
        String[] tmp = args.toArray(new String[0]);
        Assert.assertTrue((args.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)CmdLine.getBooleanArg((String[])tmp, (String)"iip.service.SimpleTransformer3", (boolean)false));
        Assert.assertTrue((boolean)CmdLine.getBooleanArg((String[])tmp, (String)"iip.service.SimpleReceiver3", (boolean)false));
        Assert.assertFalse((boolean)CmdLine.getBooleanArg((String[])tmp, (String)"iip.service.SimpleSource3", (boolean)true));
        args = SpringCloudServiceManager.determineSpringConditionals((ServiceManager)mgr, (String[])new String[]{"SimpleSource3"});
        tmp = args.toArray(new String[0]);
        Assert.assertTrue((args.size() == 3 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)CmdLine.getBooleanArg((String[])tmp, (String)"iip.service.SimpleTransformer3", (boolean)true));
        Assert.assertFalse((boolean)CmdLine.getBooleanArg((String[])tmp, (String)"iip.service.SimpleReceiver3", (boolean)true));
        Assert.assertTrue((boolean)CmdLine.getBooleanArg((String[])tmp, (String)"iip.service.SimpleSource3", (boolean)false));
    }

    @Test
    public void testOptions() throws IOException {
        ServiceManager mgr = ServiceMgrAndDescriptorTest.createServiceManager(new File("src/test/resources/ServiceMesh3Deployment.yml"));
        HashMap<String, String> opts = new HashMap<String, String>();
        opts.put("DONTKNOW", null);
        opts.put("ensemble", "{\"SimpleReceiver3\":\"SimpleTransformer3\", \"a\":\"b\", \"SimpleSource3\":\"c\"}");
        SpringCloudServiceManager.handleOptions(opts, (ServiceManager)mgr, (String[])new String[]{"SimpleTransformer3", "SimpleReceiver3"});
        Assert.assertEquals((Object)mgr.getService("SimpleReceiver3").getEnsembleLeader(), (Object)mgr.getService("SimpleTransformer3"));
        Assert.assertNull((Object)mgr.getService("SimpleTransformer3").getEnsembleLeader());
        Assert.assertNull((Object)mgr.getService("SimpleSource3").getEnsembleLeader());
        opts.put("ensemble", "{\"SimpleReceiver3\":\"\", \"a\":\"b\", \"SimpleSource3\":\"c\"}");
        SpringCloudServiceManager.handleOptions(opts, (ServiceManager)mgr, (String[])new String[]{"SimpleTransformer3", "SimpleReceiver3"});
        Assert.assertNull((Object)mgr.getService("SimpleReceiver3").getEnsembleLeader());
        Assert.assertNull((Object)mgr.getService("SimpleTransformer3").getEnsembleLeader());
        Assert.assertNull((Object)mgr.getService("SimpleSource3").getEnsembleLeader());
    }

    @Test
    public void testTopLevel() throws IOException {
        ServiceManager mgr = ServiceMgrAndDescriptorTest.createServiceManager(new File("src/test/resources/ServiceMesh3Deployment.yml"));
        Object[] res = SpringCloudServiceManager.topLevel((ServiceManager)mgr, (String[])new String[]{"SimpleTransformer3", "SimpleReceiver3"});
        ArrayList resList = new ArrayList();
        CollectionUtils.addAll(resList, (Object[])res);
        Assert.assertTrue((resList.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)resList.contains("SimpleTransformer3"));
        Assert.assertTrue((boolean)resList.contains("SimpleReceiver3"));
    }

    @Test
    public void testAppId() {
        ArrayList cmdArgs = new ArrayList();
        SpringCloudServiceManager.addAppId((String)ServiceBase.composeId((String)"service", (String)"", (String)""), cmdArgs);
        Assert.assertEquals((long)0L, (long)cmdArgs.size());
        SpringCloudServiceManager.addAppId((String)ServiceBase.composeId((String)"service", (String)"application", (String)""), cmdArgs);
        Assert.assertEquals((long)1L, (long)cmdArgs.size());
        SpringCloudServiceManager.addAppId((String)ServiceBase.composeId((String)"service", (String)"application", (String)"001"), cmdArgs);
        Assert.assertEquals((long)2L, (long)cmdArgs.size());
    }

    private static class MockServiceManager
    implements ServiceManager {
        private Map<String, SpringCloudArtifactDescriptor> arts = new HashMap<String, SpringCloudArtifactDescriptor>();
        private Map<String, SpringCloudServiceDescriptor> svc = new HashMap<String, SpringCloudServiceDescriptor>();

        private MockServiceManager(SpringCloudArtifactDescriptor aDesc) {
            this.arts.put(aDesc.getId(), aDesc);
            for (SpringCloudServiceDescriptor s : aDesc.getServices()) {
                this.svc.put(s.getId(), s);
            }
        }

        public void updateService(String serviceId, URI location) throws ExecutionException {
        }

        public void switchToService(String serviceId, String targetId) throws ExecutionException {
        }

        public void stopService(String ... serviceId) throws ExecutionException {
        }

        public void startService(String ... serviceId) throws ExecutionException {
            this.startService((Map<String, String>)null, serviceId);
        }

        public void startService(Map<String, String> options, String ... serviceId) throws ExecutionException {
        }

        public void setServiceState(String serviceId, ServiceState state) throws ExecutionException {
        }

        public void removeArtifact(String artifactId) throws ExecutionException {
        }

        public void reconfigureService(String serviceId, Map<String, String> values) throws ExecutionException {
        }

        public void passivateService(String serviceId) throws ExecutionException {
        }

        public void migrateService(String serviceId, String resourceId) throws ExecutionException {
        }

        public ServiceState getServiceState(String serviceId) {
            return null;
        }

        public String addArtifact(URI location) throws ExecutionException {
            return null;
        }

        public void activateService(String serviceId) throws ExecutionException {
        }

        public Collection<? extends ServiceDescriptor> getServices() {
            return this.svc.values();
        }

        public Set<String> getServiceIds() {
            return null;
        }

        public ServiceDescriptor getService(String serviceId) {
            return (ServiceDescriptor)this.svc.get(serviceId);
        }

        public List<TypedDataDescriptor> getParameters(String serviceId) {
            return null;
        }

        public List<TypedDataConnectorDescriptor> getOutputDataConnectors(String serviceId) {
            return null;
        }

        public List<TypedDataConnectorDescriptor> getInputDataConnectors(String serviceId) {
            return null;
        }

        public Collection<? extends ArtifactDescriptor> getArtifacts() {
            return this.arts.values();
        }

        public Set<String> getArtifactIds() {
            return null;
        }

        public ArtifactDescriptor getArtifact(String artifactId) {
            return (ArtifactDescriptor)this.arts.get(artifactId);
        }

        public void cloneArtifact(String artifactId, URI location) throws ExecutionException {
        }

        public int getServiceInstanceCount(String serviceId) {
            return 0;
        }
    }
}

