/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.ServiceFactory;
import de.iip_ecosphere.platform.services.ServiceManager;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceManager;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceSetup;
import de.iip_ecosphere.platform.services.spring.StartupApplicationListener;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.net.LocalNetworkManagerImpl;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.local.LocalAppDeployer;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;
import test.de.iip_ecosphere.platform.services.spring.AbstractTestServiceManager;
import test.de.iip_ecosphere.platform.services.spring.TestServer;

@SpringBootTest(classes={Config.class})
@TestPropertySource(locations={"classpath:iipecosphere.yml"})
@ContextConfiguration(initializers={Initializer.class})
@Import(value={SpringCloudServiceSetup.class})
@RunWith(value=SpringRunner.class)
public class ServerStartStopServiceManagerTest
extends AbstractTestServiceManager {
    @AfterClass
    public static void shutdown() {
        AbstractTestServiceManager.shutdown();
    }

    @Test
    public void testSimpleStartStop() throws ExecutionException, IOException {
        ActiveAasBase.NotificationMode oldM = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.NONE);
        this.getConfig().setDescriptorName("deployment.yml");
        ServiceManager mgr = ServiceFactory.getServiceManager();
        Assert.assertTrue((boolean)(mgr instanceof SpringCloudServiceManager));
        SpringCloudServiceManager sMgr = (SpringCloudServiceManager)mgr;
        sMgr.clear();
        Supplier oldSupp = sMgr.setNetworkManagerClientSupplier(() -> new LocalNetworkManagerImpl());
        File f = new File("./src/test/resources/serverStartStop.jar");
        Assert.assertTrue((String)("Test cannot be executed as " + f + " does not exist."), (boolean)f.exists());
        String aId = mgr.addArtifact(f.toURI());
        sMgr.startService(new String[0]);
        sMgr.stopService(new String[0]);
        sMgr.removeArtifact(aId);
        sMgr.setNetworkManagerClientSupplier(oldSupp);
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)oldM);
        Assert.assertEquals((long)1L, (long)TestServer.getAndResetCreatedCount());
        Assert.assertEquals((long)1L, (long)TestServer.getAndResetStoppedCount());
    }

    @Configuration
    @EnableConfigurationProperties(value={LocalDeployerProperties.class})
    public static class Config {
        @Bean
        public AppDeployer appDeployer(LocalDeployerProperties properties) {
            return new LocalAppDeployer(properties);
        }

        @Component
        class Startup
        extends StartupApplicationListener {
            Startup() {
            }
        }
    }

    @Import(value={SpringCloudServiceSetup.class})
    public static class Initializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        public void initialize(ConfigurableApplicationContext applicationContext) {
        }
    }
}

