/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.spring.DescriptorUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.JarFileArchive;

public class JarTest
extends DescriptorUtils.AccessibleJarLauncher {
    protected JarTest(Archive archive) {
        super(archive);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Spring boot archive tester");
        if (args.length < 2) {
            System.out.println("Help:");
            System.out.println(" - file name or Spring-packaged JAR file");
            System.out.println(" - Java class name to search for");
            System.out.println(" - optional folder with jars to load with");
        } else {
            String fileName = args[0];
            System.out.println("Loading Spring archive " + fileName);
            JarTest test = new JarTest((Archive)new JarFileArchive(new File(fileName)));
            System.out.println("Creating class loader... ");
            ClassLoader cl = test.createClassLoader();
            if (args.length >= 3) {
                StringTokenizer t = new StringTokenizer(args[2].replace(";", ":"), ";");
                while (t.hasMoreTokens()) {
                    String jarFolder = t.nextToken();
                    System.out.println("Scanning " + jarFolder + " for shared libraries");
                    File jf = new File(jarFolder);
                    File[] files = jf.listFiles();
                    if (null == files) continue;
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (File f : files) {
                        if (!f.getName().endsWith(".jar")) continue;
                        try {
                            urls.add(f.toURI().toURL());
                        }
                        catch (MalformedURLException e) {
                            System.out.println("Cannot turn shared JAR file " + f + " to URL");
                        }
                    }
                    if (urls.size() <= 0) continue;
                    System.out.println("Configuring shared libraries: " + urls);
                    cl = new URLClassLoader(urls.toArray(new URL[0]), cl);
                }
            }
            System.out.println("Loading class " + cl.loadClass(args[1]));
            System.out.println("Ok.");
        }
    }
}

