/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.spring.SpringCloudServiceSetup;
import de.iip_ecosphere.platform.services.spring.StartupApplicationListener;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.SystemUtils;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.local.LocalAppDeployer;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;
import test.de.iip_ecosphere.platform.services.spring.AbstractTestServiceManager;

@SpringBootTest(classes={Config.class})
@TestPropertySource(locations={"classpath:iipecosphere.yml"})
@ContextConfiguration(initializers={Initializer.class})
@Import(value={SpringCloudServiceSetup.class})
@RunWith(value=SpringRunner.class)
public class EnsembleStartStopServiceManagerTest
extends AbstractTestServiceManager {
    private static final ServerAddress BROKER = new ServerAddress(Schema.IGNORE);

    @BeforeClass
    public static void init() {
        EnsembleStartStopServiceManagerTest.init(BROKER);
    }

    @AfterClass
    public static void shutdown() {
        AbstractTestServiceManager.shutdown();
    }

    @Test
    public void testEnsembleStartStop() throws ExecutionException, IOException {
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_WINDOWS);
        this.doTestStartStop("deployment1.yml", new AbstractTestServiceManager.ArtifactAsserter(){}, false);
    }

    @Configuration
    @EnableConfigurationProperties(value={LocalDeployerProperties.class})
    public static class Config {
        @Bean
        public AppDeployer appDeployer(LocalDeployerProperties properties) {
            return new LocalAppDeployer(properties);
        }

        @Component
        class Startup
        extends StartupApplicationListener {
            Startup() {
            }
        }
    }

    @Import(value={SpringCloudServiceSetup.class})
    public static class Initializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        public void initialize(ConfigurableApplicationContext applicationContext) {
            TestPropertyValues.of((String[])new String[]{"service-mgr.brokerPort=" + BROKER.getPort()}).applyTo(applicationContext);
        }
    }
}

