/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.spring.DescriptorUtils;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceSetup;
import de.iip_ecosphere.platform.services.spring.SpringInstances;
import de.iip_ecosphere.platform.services.spring.yaml.YamlArtifact;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;

public class DescriptorUtilsTest {
    @Test
    public void testReadFromClasspath() throws ExecutionException {
        SpringCloudServiceSetup setup = SpringInstances.getConfig();
        SpringCloudServiceSetup testSetup = new SpringCloudServiceSetup();
        testSetup.setDescriptorName("test.yml");
        SpringInstances.setConfig((SpringCloudServiceSetup)testSetup);
        YamlArtifact art = DescriptorUtils.readFromClasspath();
        Assert.assertNotNull((Object)art);
        SpringInstances.setConfig((SpringCloudServiceSetup)setup);
    }

    @Test
    public void testCreateStandaloneCommandArgs() throws ExecutionException {
        File f = new File("src/main/resources/void.jar");
        try {
            DescriptorUtils.createStandaloneCommandArgs((File)f, (int)6234, (String)"localhost", (int)6235, (String)"");
            Assert.fail((String)"No exception thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        f = new File("src/main/resources/descriptorUtilsTest.jar");
        try {
            List args = DescriptorUtils.createStandaloneCommandArgs((File)f, (int)6234, (String)"localhost", (int)6235, (String)"");
            Assert.assertNotNull((Object)args);
            Assert.assertTrue((args.size() > 0 ? 1 : 0) != 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testResourceLoader() {
        InputStream in = ResourceLoader.getResourceAsStream((String)"spring.test.txt", (ResourceResolver[])new ResourceResolver[0]);
        Assert.assertNotNull((Object)in);
    }
}

