/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.AbstractServiceDescriptor;
import de.iip_ecosphere.platform.services.TypedDataConnectorDescriptor;
import de.iip_ecosphere.platform.services.TypedDataDescriptor;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.spring.SpringCloudArtifactDescriptor;
import de.iip_ecosphere.platform.services.spring.descriptor.Artifact;
import de.iip_ecosphere.platform.services.spring.descriptor.Validator;
import de.iip_ecosphere.platform.services.spring.yaml.YamlArtifact;
import de.iip_ecosphere.platform.services.spring.yaml.YamlEndpoint;
import de.iip_ecosphere.platform.services.spring.yaml.YamlField;
import de.iip_ecosphere.platform.services.spring.yaml.YamlProcess;
import de.iip_ecosphere.platform.services.spring.yaml.YamlRelation;
import de.iip_ecosphere.platform.services.spring.yaml.YamlServer;
import de.iip_ecosphere.platform.services.spring.yaml.YamlService;
import de.iip_ecosphere.platform.services.spring.yaml.YamlType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.spring.DescriptorTest;

public class ArtifactInfoTest {
    @Test
    public void testYaml() throws IOException {
        YamlArtifact info = YamlArtifact.readFromYaml(null);
        Assert.assertTrue((boolean)info.getServices().isEmpty());
        info = YamlArtifact.readFromYaml((InputStream)this.getClass().getClassLoader().getResourceAsStream("test-error.yml"));
        info = YamlArtifact.readFromYaml((InputStream)this.getClass().getClassLoader().getResourceAsStream("test.yml"));
        Assert.assertEquals((Object)"art", (Object)info.getId());
        Assert.assertEquals((Object)"art-name", (Object)info.getName());
        Assert.assertFalse((boolean)info.getServices().isEmpty());
        Assert.assertEquals((long)2L, (long)info.getServices().size());
        Assert.assertEquals((long)2L, (long)info.getTypes().size());
        Assert.assertEquals((Object)"myType", (Object)((YamlType)info.getTypes().get(0)).getName());
        Assert.assertEquals((long)2L, (long)((YamlType)info.getTypes().get(0)).getFields().size());
        Assert.assertEquals((Object)"a", (Object)((YamlField)((YamlType)info.getTypes().get(0)).getFields().get(0)).getName());
        Assert.assertEquals((Object)"String", (Object)((YamlField)((YamlType)info.getTypes().get(0)).getFields().get(0)).getType());
        Assert.assertEquals((Object)"myType1", (Object)((YamlType)info.getTypes().get(1)).getName());
        Assert.assertEquals((long)2L, (long)((YamlType)info.getTypes().get(1)).getFields().size());
        YamlService service = (YamlService)info.getServices().get(0);
        ArtifactInfoTest.assertServiceBasics(service, "id-0", "name-0", "1.0.2", "desc desc-0");
        ArtifactInfoTest.assertServiceCharacteristics(service, true, ServiceKind.SOURCE_SERVICE);
        ArtifactInfoTest.assertStringList(service.getCmdArg(), "arg-0-1", "arg-0-2", "--arg3=${protocol}@${port}");
        ArtifactInfoTest.assertStringList(service.getCmdArg(1234, "TCP"), "arg-0-1", "arg-0-2", "--arg3=TCP@1234");
        Assert.assertEquals((Object)service.getEnsembleWith(), (Object)"id-1");
        Assert.assertEquals((long)2L, (long)service.getRelations().size());
        ArtifactInfoTest.assertRelation((YamlRelation)service.getRelations().get(0), "", 1234, "localhost");
        ArtifactInfoTest.assertRelation((YamlRelation)service.getRelations().get(1), "input", 9872, "me.here.de");
        Assert.assertNull((Object)service.getProcess());
        service = (YamlService)info.getServices().get(1);
        ArtifactInfoTest.assertServiceBasics(service, "id-1", "name-1", "1.0.3", "desc desc-1");
        ArtifactInfoTest.assertServiceCharacteristics(service, true, ServiceKind.SINK_SERVICE);
        ArtifactInfoTest.assertStringList(service.getCmdArg(), new String[0]);
        Assert.assertNull((Object)service.getEnsembleWith());
        Assert.assertEquals((long)1L, (long)service.getRelations().size());
        ArtifactInfoTest.assertRelation((YamlRelation)service.getRelations().get(0), "output", 9872, "me.here.de");
        Assert.assertNotNull((Object)service.getProcess());
        ArtifactInfoTest.assertProcess(service.getProcess(), "/impl/python-id-0.zip", "python", false, 250, "MyServiceWrapper.py", "--port=${port}", "--protocol=${protocol}");
        ArtifactInfoTest.assertStringList(service.getProcess().getCmdArg(1224, "HTTP"), "MyServiceWrapper.py", "--port=1224", "--protocol=HTTP");
        Assert.assertEquals((long)2L, (long)service.getInstances());
        Assert.assertEquals((long)1024L, (long)service.getMemory());
        Assert.assertEquals((long)500L, (long)service.getDisk());
        Assert.assertEquals((long)2L, (long)service.getCpus());
        Assert.assertEquals((long)1L, (long)info.getServers().size());
        YamlServer ser = (YamlServer)info.getServers().get(0);
        Assert.assertEquals((Object)"test-Server", (Object)ser.getId());
        Validator val = new Validator();
        val.validate((Artifact)info);
        Assert.assertFalse((boolean)val.hasMessages());
        val.clear();
    }

    @Test
    public void testResolution() throws IOException {
        YamlArtifact info = YamlArtifact.readFromYaml((InputStream)this.getClass().getClassLoader().getResourceAsStream("test.yml"));
        Validator val = new Validator();
        val.validate((Artifact)info);
        SpringCloudArtifactDescriptor aDesc = SpringCloudArtifactDescriptor.createInstance((YamlArtifact)info, (URI)new File("test.yml").toURI(), null);
        Assert.assertNotNull((Object)aDesc);
        AbstractServiceDescriptor sDesc = aDesc.getService("id-0");
        TypedDataDescriptor param = (TypedDataDescriptor)sDesc.getParameters().get(0);
        ArtifactInfoTest.assertTypedData(param, "param1", "", String.class.getName());
        param = (TypedDataDescriptor)sDesc.getParameters().get(1);
        Class<?> paramType = ArtifactInfoTest.assertTypedData(param, "param2", "", "myType1");
        try {
            Assert.assertEquals(String.class, paramType.getDeclaredField("a").getType());
            Assert.assertEquals((Object)"myType", (Object)paramType.getDeclaredField("b").getType().getName());
        }
        catch (NoSuchFieldException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)1L, (long)sDesc.getOutputDataConnectors().size());
        ArtifactInfoTest.assertTypedData((TypedDataConnectorDescriptor)sDesc.getOutputDataConnectors().get(0), "intern", "input", "", "myType");
        sDesc = aDesc.getService("id-1");
        Assert.assertEquals((long)1L, (long)sDesc.getInputDataConnectors().size());
        ArtifactInfoTest.assertTypedData((TypedDataConnectorDescriptor)sDesc.getInputDataConnectors().get(0), "intern", "output", "", "int");
    }

    private static Class<?> assertTypedData(TypedDataConnectorDescriptor desc, String id, String name, String description, String type) {
        if (null != id) {
            Assert.assertEquals((Object)id, (Object)desc.getId());
        }
        return ArtifactInfoTest.assertTypedData((TypedDataDescriptor)desc, name, description, type);
    }

    private static Class<?> assertTypedData(TypedDataDescriptor desc, String name, String description, String type) {
        Assert.assertEquals((Object)name, (Object)desc.getName());
        Assert.assertEquals((Object)description, (Object)desc.getDescription());
        if (null != type) {
            Assert.assertNotNull((Object)desc.getType());
            Assert.assertEquals((Object)type, (Object)desc.getType().getName());
        }
        return desc.getType();
    }

    @Test
    public void testInvalidYaml() throws IOException {
        YamlArtifact info = YamlArtifact.readFromYaml((InputStream)this.getClass().getClassLoader().getResourceAsStream("test-invalid.yml"));
        Validator val = new Validator();
        val.validate((Artifact)info);
        Assert.assertTrue((boolean)val.hasMessages());
        System.out.println("> Validation output for test-invalid.yml:");
        System.out.println(val.getMessages());
        System.out.println("< Validation output for test-invalid.yml:");
        val.clear();
    }

    private static void assertStringList(List<String> list, String ... expected) {
        Assert.assertNotNull(list);
        Assert.assertEquals((long)expected.length, (long)list.size());
        int a = 0;
        for (String e : expected) {
            Assert.assertEquals((Object)e, (Object)list.get(a));
            ++a;
        }
    }

    private static void assertServiceBasics(YamlService service, String id, String name, String version, String descr) {
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)id, (Object)service.getId());
        Assert.assertEquals((Object)name, (Object)service.getName());
        Assert.assertEquals((Object)version, (Object)service.getVersion().toString());
        Assert.assertEquals((Object)descr, (Object)service.getDescription());
    }

    private static void assertServiceCharacteristics(YamlService service, boolean deployable, ServiceKind kind) {
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)deployable, (Object)service.isDeployable());
        Assert.assertEquals((Object)kind, (Object)service.getKind());
    }

    private static void assertRelation(YamlRelation relation, String channel, int port, String host) {
        Assert.assertNotNull((Object)relation);
        Assert.assertEquals((Object)channel, (Object)relation.getChannel());
        ArtifactInfoTest.assertEndpoint(relation.getEndpoint(), port, host);
    }

    private static void assertEndpoint(YamlEndpoint endpoint, int port, String host) {
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)endpoint.getPortArg().replace("${port}", String.valueOf(port)), (Object)endpoint.getPortArg(port));
        Assert.assertEquals((Object)endpoint.getHostArg().replace("${host}", host), (Object)endpoint.getHostArg(host));
    }

    private static void assertProcess(YamlProcess process, String artifact, String executable, boolean started, int waitTime, String ... cmdArgs) {
        ArtifactInfoTest.assertStringList(process.getArtifacts(), artifact);
        Assert.assertEquals((Object)executable, (Object)process.getExecutable());
        ArtifactInfoTest.assertEndpoint(process.getStreamEndpoint(), 1234, "localhost");
        ArtifactInfoTest.assertEndpoint(process.getAasEndpoint(), 1235, "aas.de");
        ArtifactInfoTest.assertStringList(process.getCmdArg(), cmdArgs);
        Assert.assertEquals((Object)started, (Object)process.isStarted());
        Assert.assertEquals((long)waitTime, (long)process.getWaitTime());
    }

    @Test
    public void testFileDescriptorTest() throws IOException {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("test.yml");
        Assert.assertNotNull((Object)in);
        File f = File.createTempFile("services.spring", ".xml");
        Files.copy(in, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
        DescriptorTest.main(f.getAbsolutePath());
        f = new File("./target/jars/simpleStream.spring.jar");
        DescriptorTest.main(f.getAbsolutePath());
    }
}

