/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.ArtifactDescriptor;
import de.iip_ecosphere.platform.services.ServiceDescriptor;
import de.iip_ecosphere.platform.services.ServiceFactory;
import de.iip_ecosphere.platform.services.ServiceManager;
import de.iip_ecosphere.platform.services.ServicesAas;
import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceMapper;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.MeterRepresentation;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsAasConstructor;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceManager;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceSetup;
import de.iip_ecosphere.platform.services.spring.SpringInstances;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasPrintVisitor;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.AasUtils;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.iip_aas.config.CmdLine;
import de.iip_ecosphere.platform.support.net.ManagedServerAddress;
import de.iip_ecosphere.platform.support.net.NetworkManager;
import de.iip_ecosphere.platform.support.net.NetworkManagerFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import test.de.iip_ecosphere.platform.test.amqp.qpid.TestQpidServer;

public class AbstractTestServiceManager {
    protected static final Predicate<Object> POSITIVE_GAUGE_VALUE = o -> {
        if (o instanceof Number) {
            return ((Number)o).doubleValue() > 0.0;
        }
        if (o != null) {
            Meter meter = MeterRepresentation.parseMeter((String)o.toString(), (String[])new String[0]);
            Assert.assertTrue((boolean)(meter instanceof Gauge));
            return ((Gauge)meter).value() > 0.0;
        }
        System.out.println("Warning: Predicate value is null. For Jenkins, assuming all is fine.");
        return true;
    };
    private static Server server;
    private static ActiveAasBase.NotificationMode oldM;
    private static AasPartRegistry.AasSetup oldSetup;
    private static Server implServer;
    private static Server aasServer;
    @Autowired
    private SpringCloudServiceSetup config;
    private List<String> netKeyToRelease = new ArrayList<String>();
    private List<Server> serversToRelease = new ArrayList<Server>();

    protected SpringCloudServiceSetup getConfig() {
        return this.config;
    }

    public static void init(ServerAddress broker) {
        server = new TestQpidServer(broker);
        TransportSetup setup = ServiceFactory.getTransport();
        setup.setPort(broker.getPort());
        setup.setHost("localhost");
        setup.setAuthenticationKey("amqp");
        server.start();
        System.out.println("AMQP broker on port " + broker.getPort());
        oldM = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS);
        Assert.assertTrue((boolean)AasPartRegistry.contributorClasses().contains(ServicesAas.class));
        oldSetup = AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)AasPartRegistry.AasSetup.createLocalEphemeralSetup());
        AasPartRegistry.AasBuildResult res = AasPartRegistry.build(c -> c instanceof ServicesAas);
        implServer = (Server)res.getProtocolServerBuilder().build();
        implServer.start();
        System.out.println("AAS Imp server on port " + AasPartRegistry.getSetup().getImplementation().getPort());
        aasServer = AasPartRegistry.deploy((List)res.getAas(), (String[])new String[0]);
        aasServer.start();
        int aasRegPort = AasPartRegistry.getSetup().getRegistry().getPort();
        int aasPort = AasPartRegistry.getSetup().getServer().getPort();
        System.out.println("AAS registry on port " + aasRegPort);
        System.out.println("AAS server on port " + aasPort);
        SpringInstances.setServiceCmdArgs((List)CollectionUtils.toList((Object[])new String[]{CmdLine.composeArgument((String)"iip.test.aas.port", (Object)aasPort), CmdLine.composeArgument((String)"iip.test.aasRegistry.port", (Object)aasRegPort)}));
    }

    public static void shutdown() {
        MetricsAasConstructor.clear();
        if (null != server) {
            server.stop(false);
            aasServer.stop(true);
            implServer.stop(true);
        }
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)oldSetup);
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)oldM);
    }

    protected static final void assertFileExists(File file) {
        Assert.assertTrue((String)("File " + file + " does not exist"), (boolean)file.exists());
    }

    protected void doTestStartStop(String descriptorName, ArtifactAsserter asserter, boolean fakeServer) throws ExecutionException, IOException {
        this.config.setDescriptorName(descriptorName);
        ServiceManager mgr = ServiceFactory.getServiceManager();
        Assert.assertTrue((boolean)(mgr instanceof SpringCloudServiceManager));
        ((SpringCloudServiceManager)mgr).clear();
        File f = new File("./target/jars/simpleStream.spring.jar");
        Assert.assertTrue((String)("Test cannot be executed, " + f + " does not exist. Downloaded by Maven?"), (boolean)f.exists());
        String aId = mgr.addArtifact(f.toURI());
        Assert.assertNotNull((Object)aId);
        Assert.assertTrue((aId.length() > 0 ? 1 : 0) != 0);
        ArtifactDescriptor aDesc = mgr.getArtifact(aId);
        Assert.assertNotNull((Object)aDesc);
        Assert.assertTrue((boolean)mgr.getArtifactIds().contains(aId));
        Assert.assertTrue((boolean)mgr.getArtifacts().contains(aDesc));
        Assert.assertTrue((aDesc.getServiceIds().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)aDesc.getServiceIds().contains("simpleStream-create"));
        Assert.assertTrue((boolean)aDesc.getServiceIds().contains("simpleStream-log"));
        Assert.assertTrue((aDesc.getServices().size() == 2 ? 1 : 0) != 0);
        ServiceDescriptor inputService = aDesc.getService("simpleStream-create");
        ServiceDescriptor outputService = aDesc.getService("simpleStream-log");
        Assert.assertTrue((boolean)aDesc.getServices().contains(inputService));
        Assert.assertTrue((boolean)aDesc.getServices().contains(outputService));
        asserter.testDescriptor(aDesc);
        for (ServiceDescriptor sDesc : aDesc.getServices()) {
            Assert.assertNotNull((Object)sDesc.getId());
            Assert.assertTrue((sDesc.getId().length() > 0 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)sDesc.getVersion());
            Assert.assertNotNull((Object)sDesc.getName());
            Assert.assertTrue((sDesc.getName().length() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)ServiceState.AVAILABLE, (Object)sDesc.getState());
        }
        HashSet sIds = new HashSet();
        sIds.addAll(aDesc.getServiceIds());
        String[] serviceIds = sIds.toArray(new String[0]);
        sIds.addAll(aDesc.getServers().stream().map(s -> s.getServiceId()).collect(Collectors.toSet()));
        Object[] allIds = sIds.toArray(new String[0]);
        if (fakeServer) {
            this.startFakeServiceCommandServers(mgr, serviceIds);
        }
        System.out.println("STARTING " + mgr + " " + Arrays.toString(allIds));
        mgr.startService((String[])allIds);
        for (ServiceDescriptor sDesc : aDesc.getServices()) {
            Assert.assertEquals((String)("Service " + sDesc.getId() + " " + sDesc.getName() + " not running: " + sDesc.getState()), (Object)ServiceState.RUNNING, (Object)sDesc.getState());
        }
        Aas aas = AasPartRegistry.retrieveIipAas();
        Submodel sub = aas.getSubmodel("services");
        Assert.assertNotNull((Object)sub);
        sub.accept((AasVisitor)new AasPrintVisitor());
        TimeUtils.sleep((int)8000);
        HashMap<String, Predicate<Object>> expectedMetrics = new HashMap<String, Predicate<Object>>();
        expectedMetrics.put("Memory_Capacity", POSITIVE_GAUGE_VALUE);
        expectedMetrics.put("Allocated_Memory", POSITIVE_GAUGE_VALUE);
        this.assertMetrics(serviceIds, expectedMetrics);
        asserter.testDeployment(aDesc);
        mgr.stopService((String[])allIds);
        this.releaseFakeServiceCommandServers();
        for (ServiceDescriptor sDesc : aDesc.getServices()) {
            Assert.assertEquals((String)("Service " + sDesc.getId() + " " + sDesc.getName() + " not stopped: " + sDesc.getState()), (Object)ServiceState.STOPPED, (Object)sDesc.getState());
        }
        asserter.cleanup(aDesc);
        mgr.removeArtifact(aId);
        Assert.assertFalse((boolean)mgr.getArtifactIds().contains(aId));
        Assert.assertFalse((boolean)mgr.getArtifacts().contains(aDesc));
        Assert.assertNull((Object)mgr.getArtifact(aId));
        AbstractTestServiceManager.assertReceiverLog();
        MetricsAasConstructor.clear();
    }

    protected static void assertReceiverLog() {
        File f = new File(FileUtils.getTempDirectoryPath() + "/test.simpleStream.spring.log");
        Assert.assertTrue((String)"Receiver log does not exist", (boolean)f.exists());
        Assert.assertTrue((String)"Receiver log is empty", (f.length() > 0L ? 1 : 0) != 0);
    }

    protected void assertMetrics(String[] ids, Map<String, Predicate<Object>> expected) throws IOException, ExecutionException {
        Aas aas = AasPartRegistry.retrieveIipAas();
        Submodel sub = aas.getSubmodel("services");
        Assert.assertNotNull((Object)sub);
        sub.accept((AasVisitor)new AasPrintVisitor());
        SubmodelElementCollection services = sub.getSubmodelElementCollection("services");
        Assert.assertNotNull((Object)sub);
        for (String id : ids) {
            SubmodelElementCollection service = services.getSubmodelElementCollection(AasUtils.fixId((String)id));
            Assert.assertNotNull((Object)service);
            for (Map.Entry<String, Predicate<Object>> ent : expected.entrySet()) {
                Property prop = service.getProperty(ent.getKey());
                Assert.assertNotNull((String)(ent.getKey() + " missing"), (Object)prop);
                Predicate<Object> pred = ent.getValue();
                if (null == pred) continue;
                Object val = prop.getValue();
                Assert.assertTrue((String)("Test for " + ent.getKey() + " failed"), (boolean)pred.test(val));
            }
        }
    }

    protected void startFakeServiceCommandServers(ServiceManager mgr, String[] ids) {
        NetworkManager nMgr = NetworkManagerFactory.getInstance();
        for (String id : ids) {
            String key = Starter.getServiceCommandNetworkMgrKey((String)id);
            ManagedServerAddress addr = nMgr.obtainPort(key);
            if (addr.isNew()) {
                this.netKeyToRelease.add(key);
            }
            ServiceDescriptor desc = mgr.getService(id);
            ProtocolServerBuilder sBuilder = AasFactory.getInstance().createProtocolServerBuilder(this.config.getServiceProtocol(), addr.getPort());
            ServiceMapper mapper = new ServiceMapper(sBuilder);
            mapper.mapService((Service)new ServiceImpl(desc));
            Server server = (Server)sBuilder.build();
            server.start();
            this.serversToRelease.add(server);
        }
    }

    protected void releaseFakeServiceCommandServers() {
        for (Server s : this.serversToRelease) {
            s.stop(true);
        }
        NetworkManager nMgr = NetworkManagerFactory.getInstance();
        for (String key : this.netKeyToRelease) {
            nMgr.releasePort(key);
        }
    }

    protected void testWithZipArchive(boolean useClasspath) throws ExecutionException {
        String prop = System.getProperty("iip.spring.readZipClasspath", "");
        System.setProperty("iip.spring.readZipClasspath", String.valueOf(useClasspath));
        ServiceManager mgr = ServiceFactory.getServiceManager();
        File file = new File("target/jars/simpleStream.spring.zip");
        String aid = mgr.addArtifact(file.toURI());
        mgr.startService(new String[]{"simpleStream-create", "simpleStream-log"});
        TimeUtils.sleep((int)5000);
        mgr.stopService(new String[]{"simpleStream-create", "simpleStream-log"});
        mgr.removeArtifact(aid);
        System.setProperty("iip.spring.readZipClasspath", prop);
    }

    protected static class ServiceImpl
    extends AbstractService {
        protected ServiceImpl(ServiceDescriptor desc) {
            super(desc.getId(), desc.getName(), desc.getVersion(), desc.getDescription(), desc.isDeployable(), desc.isTopLevel(), desc.getKind());
        }

        public void migrate(String resourceId) throws ExecutionException {
        }

        public void update(URI location) throws ExecutionException {
        }

        public void switchTo(String targetId) throws ExecutionException {
        }

        public void reconfigure(Map<String, String> values) throws ExecutionException {
        }
    }

    protected class ArtifactAsserter {
        protected ArtifactAsserter() {
        }

        public void testDescriptor(ArtifactDescriptor desc) {
        }

        public void testDeployment(ArtifactDescriptor desc) {
        }

        public void cleanup(ArtifactDescriptor desc) {
        }
    }
}

