/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.spring.descriptor;

import de.iip_ecosphere.platform.services.spring.descriptor.Artifact;
import de.iip_ecosphere.platform.services.spring.descriptor.Endpoint;
import de.iip_ecosphere.platform.services.spring.descriptor.Field;
import de.iip_ecosphere.platform.services.spring.descriptor.ProcessSpec;
import de.iip_ecosphere.platform.services.spring.descriptor.Relation;
import de.iip_ecosphere.platform.services.spring.descriptor.Service;
import de.iip_ecosphere.platform.services.spring.descriptor.Type;
import de.iip_ecosphere.platform.services.spring.descriptor.TypeResolver;
import de.iip_ecosphere.platform.services.spring.descriptor.TypedData;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Validator {
    private List<String> messages = new ArrayList<String>();
    private Set<String> serviceIds = new HashSet<String>();

    public boolean hasMessages() {
        return this.messages.size() > 0;
    }

    public String getMessages() {
        StringBuilder tmp = new StringBuilder();
        for (int m = 0; m < this.messages.size(); ++m) {
            if (m > 0) {
                tmp.append("\n");
            }
            tmp.append(this.messages.get(m));
        }
        return tmp.toString();
    }

    public Iterable<String> messages() {
        return this.messages;
    }

    public void clear() {
        this.messages.clear();
        this.serviceIds.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void validate(Artifact artifact) {
        String msgContext = "";
        this.assertStringNotEmpty(artifact.getId(), "id", msgContext);
        this.assertStringNotEmpty(artifact.getName(), "name", msgContext);
        this.assertVersion(artifact.getVersion(), "version", msgContext);
        HashMap<String, Type> typeMap = new HashMap<String, Type>();
        for (Type type : artifact.getTypes()) {
            if (!this.assertJavaIdentifier(type.getName(), "name", msgContext)) continue;
            if (typeMap.containsKey(type.getName())) {
                this.messages.add("Declared type `" + type.getName() + "` is not unique.");
            }
            try {
                Class.forName(type.getName());
                this.messages.add("Declared type `" + type.getName() + "` shall not be known as Java class here.");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            typeMap.put(type.getName(), type);
        }
        HashSet<String> fieldNames = new HashSet<String>();
        for (Type type : artifact.getTypes()) {
            for (Field field : type.getFields()) {
                this.assertStringNotEmpty(field.getName(), "name", msgContext);
                if (fieldNames.contains(type.getName())) {
                    this.messages.add("Declared field `" + field.getName() + "`in declared type `" + type.getName() + "` is not unique.");
                }
                this.assertType(field.getType(), typeMap, "type", field.getName() + " in " + type.getName());
                fieldNames.add(field.getName());
            }
            fieldNames.clear();
        }
        if (this.assertList(artifact.getServices(), true, "services", msgContext, (s, m) -> this.validate((Service)s, (Map<String, Type>)typeMap, m))) {
            boolean bl = false;
            for (Service service : artifact.getServices()) {
                void var5_8;
                String string;
                if (null != service.getEnsembleWith() && null != (string = service.getEnsembleWith()) && string.length() > 0 && !this.serviceIds.contains(string)) {
                    this.messages.add("Ensemble entry '" + string + "' in service #" + (int)var5_8 + " is not declared as service .");
                }
                ++var5_8;
            }
        }
    }

    public void validate(Service service, List<? extends Type> types) {
        this.validate(service, Validator.toMap(types), "");
    }

    private void validate(Service service, Map<String, Type> types, String msgContext) {
        if (this.assertStringNotEmpty(service.getId(), "id", msgContext)) {
            this.serviceIds.add(service.getId());
        }
        this.assertStringNotEmpty(service.getName(), "name", msgContext);
        this.assertVersion(service.getVersion(), "version", msgContext);
        this.assertFieldNotNull(service.getDescription(), "description", msgContext);
        this.assertFieldNotNull(service.getKind(), "kind", msgContext);
        this.assertStringList(service.getCmdArg(), "cmdArg", "arg", msgContext);
        this.assertList(service.getParameters(), true, "parameters", msgContext, (p, m) -> this.validate((TypedData)p, types, m));
        this.assertList(service.getRelations(), true, "relations", msgContext, (r, m) -> this.validate((Relation)r, types, m));
        if (null != service.getProcess()) {
            this.validate(service.getProcess(), this.appendToContext(msgContext, "process"));
        }
    }

    public static Map<String, Type> toMap(List<? extends Type> types) {
        HashMap<String, Type> typeMap = new HashMap<String, Type>();
        for (Type type : types) {
            typeMap.put(type.getName(), type);
        }
        return typeMap;
    }

    public void validate(Relation relation, Map<String, Type> types) {
        this.validate(relation, types, "");
    }

    private void validate(TypedData typed, Map<String, Type> types, String msgContext) {
        this.assertFieldNotNull(typed.getName(), "channel", msgContext);
        this.assertFieldNotNull(typed.getDescription(), "description", msgContext);
        this.assertType(typed.getType(), types, "type", msgContext);
    }

    private void validate(Relation relation, Map<String, Type> types, String msgContext) {
        boolean chOk = this.assertFieldNotNull(relation.getChannel(), "channel", msgContext);
        if (null != relation.getEndpoint()) {
            this.validate(relation.getEndpoint(), this.appendToContext(msgContext, "endpoint"));
        }
        this.assertFieldNotNull(relation.getDescription(), "description", msgContext);
        if (chOk && relation.getChannel().length() > 0) {
            this.assertFieldNotNull((Object)relation.getDirection(), "direction", msgContext);
            for (String t : relation.getTypes()) {
                this.assertType(t, types, "type", msgContext);
            }
        }
    }

    public void validate(ProcessSpec process) {
        this.validate(process, "");
    }

    private void validate(ProcessSpec process, String msgContext) {
        this.assertStringList(process.getArtifacts(), "artifacts", "artifact", msgContext);
        this.assertCondition(process.getArtifacts() != null && process.getArtifacts().size() > 0, "At least one artifact must be given", msgContext);
        this.assertStringList(process.getCmdArg(), "cmdArg", "arg", msgContext);
        if (!process.isStarted()) {
            this.assertStringNotEmpty(process.getExecutable(), "executable", msgContext);
            if (this.assertFieldNotNull(process.getAasEndpoint(), "aasEndpoint", msgContext)) {
                this.validate(process.getAasEndpoint(), this.appendToContext(msgContext, "aasEndpoint"));
            }
            if (this.assertFieldNotNull(process.getStreamEndpoint(), "streamEndpoint", msgContext)) {
                this.validate(process.getStreamEndpoint(), this.appendToContext(msgContext, "streamEndpoint"));
            }
            if (this.assertFieldNotNull(process.getServiceStreamEndpoint(), "serviceStreamEndpoint", msgContext)) {
                this.validate(process.getServiceStreamEndpoint(), this.appendToContext(msgContext, "serviceStreamEndpoint"));
            }
        }
    }

    private String appendToContext(String context, String text) {
        String result = context;
        if (result == null) {
            result = "";
        } else if (result.length() > 0) {
            result = result + "/";
        }
        return result + text;
    }

    public void validate(Endpoint endpoint) {
        this.validate(endpoint, "");
    }

    private void validate(Endpoint endpoint, String msgContext) {
        this.assertStringNotEmpty(endpoint.getPortArg(), "portArg", msgContext);
        this.assertFieldNotNull(endpoint.getHostArg(), "hostArg", msgContext);
    }

    private boolean assertType(String type, Map<String, Type> types, String field, String msgContext) {
        boolean ok = this.assertJavaIdentifier(type, field, msgContext);
        if (ok && !types.containsKey(type) && !TypeResolver.isPrimitive(type)) {
            try {
                Class.forName(type);
            }
            catch (ClassNotFoundException e) {
                this.messages.add(this.appendContext("Type `" + type + "` is not known", msgContext));
                ok = false;
            }
        }
        return ok;
    }

    private boolean assertJavaIdentifier(String name, String field, String msgContext) {
        boolean ok = this.assertStringNotEmpty(name, "Field '" + field + "' must not be null", msgContext);
        if (ok) {
            ok &= Character.isJavaIdentifierStart(name.charAt(0));
            for (int c = 1; ok && c < name.length(); ok &= Character.isJavaIdentifierPart(name.charAt(c)), ++c) {
            }
        }
        return ok;
    }

    private boolean assertFieldNotNull(Object object, String field, String msgContext) {
        return this.assertCondition(object != null, "Field '" + field + "' must not be null", msgContext);
    }

    private boolean assertVersion(Object object, String field, String msgContext) {
        boolean ok = this.assertCondition(object instanceof Version, "Field '" + field + "' must be a version", msgContext);
        if (ok) {
            ok = this.assertCondition(Version.isVersion((String)object.toString()), "Field 'version' must be formatted as a version string", msgContext);
        }
        return ok;
    }

    private <O> boolean assertList(List<O> list, boolean fieldNotNull, String field, String msgContext, ValidatorFunction<O> func) {
        boolean ok;
        boolean bl = ok = fieldNotNull ? this.assertFieldNotNull(list, field, msgContext) : true;
        if (ok) {
            for (int e = 0; e < list.size(); ++e) {
                func.validate(list.get(e), this.appendToContext(msgContext, field + " #" + e));
            }
        }
        return ok;
    }

    private boolean assertStringList(List<String> list, String field, String entry, String msgContext) {
        boolean ok = this.assertFieldNotNull(list, field, msgContext);
        if (ok) {
            for (int c = 0; c < list.size(); ++c) {
                ok &= this.assertStringNotEmpty(list.get(c), field, this.appendToContext(msgContext, entry + " #" + c));
            }
        }
        return ok;
    }

    private boolean assertStringNotEmpty(String string, String field, String msgContext) {
        return this.assertCondition(string != null && string.length() > 0, "String in field '" + field + "' must not be empty", msgContext);
    }

    private boolean assertCondition(boolean condition, String msg, String msgContext) {
        if (!condition) {
            this.messages.add(this.appendContext(msg, msgContext));
        }
        return condition;
    }

    private String appendContext(String msg, String msgContext) {
        if (null != msgContext && msgContext.length() > 0) {
            msg = msg + " (in " + msgContext + ")";
        }
        if (!msg.endsWith(".")) {
            msg = msg + ".";
        }
        return msg;
    }

    private static interface ValidatorFunction<O> {
        public void validate(O var1, String var2);
    }
}

