/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.spring;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class Utils {
    public static String formatToMeBi(long number) {
        return Utils.formatToMeBi(number, 0);
    }

    public static String formatToMeBi(long number, int baseUnit) {
        int unit = baseUnit;
        long rem = number;
        while (rem >= 1024L) {
            rem /= 1024L;
            ++unit;
        }
        String result = 2 == unit ? rem + "m" : (3 == unit ? rem + "g" : (4 == unit ? 1024L * rem + "g" : String.valueOf(number)));
        return result;
    }

    public static void addPropertyIfPositiveToMeBi(Map<String, String> properties, String key, Number value, String deflt) {
        Utils.addProperty(properties, key, value, deflt, i -> i.longValue() > 0L, i -> Utils.formatToMeBi(i.longValue(), 2));
    }

    public static void addPropertyIfPositiveToInt(Map<String, String> properties, String key, Number value, String deflt) {
        Utils.addProperty(properties, key, value, deflt, i -> i.intValue() > 0, i -> String.valueOf(i.intValue()));
    }

    public static void addProperty(Map<String, String> properties, String key, Number value, String deflt, Predicate<Number> cond, Function<Number, String> formatter) {
        String result = null != value && null != cond && cond.test(value) ? formatter.apply(value) : deflt;
        if (null != result) {
            properties.put(key, result);
        }
    }
}

