/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.ServicesAas;
import de.iip_ecosphere.platform.services.spring.SpringInstances;
import de.iip_ecosphere.platform.services.spring.StartupApplicationListener;
import de.iip_ecosphere.platform.support.LifecycleDescriptor;
import de.iip_ecosphere.platform.support.iip_aas.IipVersion;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@SpringBootApplication(scanBasePackageClasses={SpringLifecycleDescriptor.class})
public class SpringLifecycleDescriptor
implements LifecycleDescriptor {
    public void startup(String[] args) {
        new SpringApplicationBuilder(new Class[]{SpringLifecycleDescriptor.class}).properties(new String[]{"spring.config.name:iipecosphere"}).build().run(args);
    }

    public void shutdown() {
        ServicesAas.notifyManagerRemoved();
    }

    public Thread getShutdownHook() {
        return null;
    }

    public int priority() {
        return 1;
    }

    @Bean
    public CommandLineRunner commandLineRunner(ApplicationContext ctx) {
        return args -> {
            System.out.println("IIP-Ecosphere Service Manager (Spring Cloud Streams, " + IipVersion.getInstance().getVersion() + ").");
            System.out.println("Configuration: " + ((Object)((Object)SpringInstances.getConfig())).getClass().getName());
            System.out.println("Deployer: " + SpringInstances.getDeployer().getClass().getName());
        };
    }

    public static void main(String[] args) {
        SpringLifecycleDescriptor desc = new SpringLifecycleDescriptor();
        desc.startup(args);
    }

    @Component
    class Startup
    extends StartupApplicationListener {
        Startup() {
        }
    }
}

