/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.ServiceSetup;
import de.iip_ecosphere.platform.support.CollectionUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="service-mgr")
@Component
public class SpringCloudServiceSetup
extends ServiceSetup {
    private String brokerHost = "localhost";
    private int brokerPort = 8883;
    private boolean deleteArtifacts = true;
    private File downloadDir;
    private String descriptorName = "deployment.yml";
    private int waitingTime = 120000;
    private int availabilityRetryDelay = 500;
    private HashMap<String, String> executables = new HashMap();
    private List<String> javaOpts = CollectionUtils.toList((Object[])new String[]{"-Dlog4j2.formatMsgNoLookups=true"});
    private File sharedLibs = new File("/shared");

    public String getBrokerHost() {
        return this.brokerHost;
    }

    public int getBrokerPort() {
        return this.brokerPort;
    }

    public boolean getDeleteArtifacts() {
        return this.deleteArtifacts;
    }

    public File getDownloadDir() {
        return this.downloadDir;
    }

    public File getSharedLibs() {
        return this.sharedLibs;
    }

    public String getDescriptorName() {
        return this.descriptorName;
    }

    public int getWaitingTime() {
        return this.waitingTime;
    }

    public int getAvailabilityRetryDelay() {
        return this.availabilityRetryDelay;
    }

    public String getExecutable(String executable) {
        String result = this.executables.get(executable);
        if (null == result) {
            result = executable;
        }
        return result;
    }

    public List<String> getJavaOpts() {
        return this.javaOpts;
    }

    public void setBrokerHost(String brokerHost) {
        this.brokerHost = brokerHost;
    }

    public void setBrokerPort(int brokerPort) {
        this.brokerPort = brokerPort;
    }

    public void setDeleteArtifacts(boolean deleteArtifacts) {
        this.deleteArtifacts = deleteArtifacts;
    }

    public void setDownloadDir(File downloadDir) {
        this.downloadDir = downloadDir;
    }

    public void setSharedLibs(File sharedLibs) {
        this.sharedLibs = sharedLibs;
    }

    public void setDescriptorName(String descriptorName) {
        if (null != descriptorName && descriptorName.length() > 0) {
            this.descriptorName = descriptorName;
        }
    }

    public void setWaitingTime(int waitingTime) {
        this.waitingTime = waitingTime;
    }

    public void setAvailabilityRetryDelay(int availabilityRetryDelay) {
        this.availabilityRetryDelay = availabilityRetryDelay;
    }

    public void setExecutables(HashMap<String, String> executables) {
        this.executables = executables;
    }

    public void setJavaOpts(List<String> javaOpts) {
        this.javaOpts = javaOpts;
    }
}

