/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.services.spring.SpringInstances;
import de.iip_ecosphere.platform.services.spring.descriptor.Endpoint;
import de.iip_ecosphere.platform.services.spring.descriptor.ProcessSpec;
import de.iip_ecosphere.platform.services.spring.descriptor.Relation;
import de.iip_ecosphere.platform.services.spring.descriptor.Validator;
import de.iip_ecosphere.platform.services.spring.yaml.YamlArtifact;
import de.iip_ecosphere.platform.services.spring.yaml.YamlProcess;
import de.iip_ecosphere.platform.services.spring.yaml.YamlService;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.JarUtils;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.iip_aas.config.CmdLine;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptorUtils {
    public static YamlArtifact readFromFile(File file) throws ExecutionException {
        YamlArtifact result;
        block7: {
            result = null;
            if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
                try {
                    String descName = DescriptorUtils.getDescriptorName();
                    DescriptorUtils.getLogger().info("Reading artifact " + file + ", descriptor " + descName);
                    InputStream descStream = JarUtils.findFile((InputStream)new FileInputStream(file), (String)("BOOT-INF/classes/" + descName));
                    if (null == descStream) {
                        descStream = JarUtils.findFile((InputStream)new FileInputStream(file), (String)descName);
                    }
                    if (null != descStream) {
                        result = YamlArtifact.readFromYaml(descStream);
                        FileUtils.closeQuietly((Closeable)descStream);
                        Validator val = new Validator();
                        val.validate(result);
                        if (val.hasMessages()) {
                            DescriptorUtils.throwExecutionException("Adding " + file, "Problems in descriptor:\n" + val.getMessages());
                        }
                        break block7;
                    }
                    DescriptorUtils.throwExecutionException("Reading artifact " + file, descName + " does not exist in " + file);
                }
                catch (IOException e) {
                    DescriptorUtils.throwExecutionException("Reading artifact " + file, e);
                }
            } else {
                DescriptorUtils.throwExecutionException("Reading artifact " + file, file + " is not considered as service artifact (JAR, ZIP)");
            }
        }
        return result;
    }

    private static String getDescriptorName() {
        String descName = "deployment.yml";
        if (null != SpringInstances.getConfig()) {
            descName = SpringInstances.getConfig().getDescriptorName();
        }
        return descName;
    }

    public static YamlArtifact readFromClasspath() throws ExecutionException {
        YamlArtifact result = null;
        String descName = DescriptorUtils.getDescriptorName();
        InputStream descStream = ResourceLoader.getResourceAsStream(DescriptorUtils.class, (String)descName, (ResourceResolver[])new ResourceResolver[0]);
        if (null != descStream) {
            try {
                result = YamlArtifact.readFromYaml(descStream);
            }
            catch (IOException e) {
                DescriptorUtils.throwExecutionException("Reading deployment descriptor " + descName, e);
            }
            FileUtils.closeQuietly((Closeable)descStream);
        } else {
            DescriptorUtils.throwExecutionException("Reading deployment descriptor", descName + " not found on classpath");
        }
        return result;
    }

    public static void throwExecutionException(String action, Throwable th) throws ExecutionException {
        DescriptorUtils.getLogger().error(action + ": " + th.getMessage());
        throw new ExecutionException(th);
    }

    public static void throwExecutionException(String action, String message) throws ExecutionException {
        DescriptorUtils.getLogger().error(action + ": " + message);
        throw new ExecutionException(message, null);
    }

    public static File extractProcessArtifacts(String sId, ProcessSpec pSpec, File artFile, File processBaseDir) throws IOException {
        File processDir = pSpec.getHomePath();
        if (null == processDir) {
            processDir = new File(processBaseDir, Starter.normalizeServiceId((String)sId) + "-" + System.currentTimeMillis());
        }
        if (!pSpec.isStarted()) {
            FileUtils.deleteQuietly((File)processDir);
        }
        processDir.mkdirs();
        for (String artPath : pSpec.getArtifacts()) {
            while (artPath.startsWith("/")) {
                artPath = artPath.substring(1);
            }
            FileInputStream fis = null;
            InputStream artifact = null;
            try {
                fis = new FileInputStream(artFile);
                artifact = JarUtils.findFile((InputStream)fis, (String)("BOOT-INF/classes/" + artPath));
                if (null == artifact) {
                    fis = new FileInputStream(artFile);
                    artifact = JarUtils.findFile((InputStream)fis, (String)artPath);
                    if (null != artifact) {
                        DescriptorUtils.getLogger().info("Found " + artPath + " in " + artFile + " " + artifact.getClass().getSimpleName());
                    }
                } else {
                    DescriptorUtils.getLogger().info("Found " + artPath + " in BOOT-INF/classes/" + artPath + " " + artifact.getClass().getSimpleName());
                }
            }
            catch (IOException e) {
                DescriptorUtils.getLogger().info("Cannot open " + artFile + ": " + e.getMessage());
            }
            if (null == artifact && null != (artifact = ResourceLoader.getResourceAsStream(DescriptorUtils.class, (String)artPath, (ResourceResolver[])new ResourceResolver[0]))) {
                DescriptorUtils.getLogger().info("Found " + artPath + " on classpath " + artifact.getClass().getSimpleName());
            }
            if (null == artifact) {
                throw new IOException("Cannot find artifact '" + artPath + "' in actual service JAR");
            }
            JarUtils.extractZip((InputStream)artifact, (Path)processDir.toPath());
            DescriptorUtils.getLogger().info("Extracted process artifact " + artPath + " to " + processDir);
            FileUtils.closeQuietly((Closeable)artifact);
            FileUtils.closeQuietly((Closeable)fis);
        }
        return processDir;
    }

    public static void addEndpointArgs(List<String> cmdLine, Endpoint endpoint, ServerAddress addr) {
        DescriptorUtils.addEndpointArgs(cmdLine, endpoint, addr.getPort(), addr.getHost());
    }

    public static void addEndpointArgs(List<String> cmdLine, Endpoint endpoint, int port, String host) {
        if (null != endpoint) {
            CmdLine.parseToArgs((String)endpoint.getPortArg(port), cmdLine);
            if (endpoint.getHostArg().length() > 0) {
                CmdLine.parseToArgs((String)endpoint.getHostArg(host), cmdLine);
            }
        }
    }

    public static List<String> createStandaloneCommandArgs(File jar, int brokerPort, String brokerHost, int adminPort, String serviceProtocol) throws IOException, ExecutionException {
        return DescriptorUtils.createStandaloneCommandArgs(jar, brokerPort, brokerHost, adminPort, serviceProtocol, -1);
    }

    public static List<String> createStandaloneCommandArgs(File jar, int brokerPort, String brokerHost, int adminPort, String serviceProtocol, int springPort) throws IOException, ExecutionException {
        if (springPort < 0) {
            springPort = NetUtils.getEphemeralPort();
        }
        if (!jar.exists()) {
            throw new IOException("Cannot find Spring service binary '" + jar.getAbsolutePath() + "'. Did you run the instantiation process?");
        }
        YamlArtifact art = DescriptorUtils.readFromFile(jar);
        ArrayList<String> result = new ArrayList<String>();
        result.add("java");
        result.add("-jar");
        result.add("-Dlog4j2.formatMsgNoLookups=true");
        Starter.addAppEnvironment(result);
        result.add(jar.getAbsolutePath());
        result.add("--iip.test.service.autostart=true");
        result.add("--iip.test.transport.port=" + brokerPort);
        result.add("--amqp.port=" + brokerPort);
        result.add("--mqtt.port=" + brokerPort);
        result.add("--server.port=" + springPort);
        ArrayList<String> tmp = new ArrayList<String>();
        for (YamlService service : art.getServices()) {
            YamlProcess proc = service.getProcess();
            if (null != proc) {
                File d = DescriptorUtils.extractProcessArtifacts(service.getId(), proc, jar, null);
                FileUtils.deleteOnExit((File)d);
            }
            for (Relation relation : service.getRelations()) {
                DescriptorUtils.addEndpointArgs(tmp, relation.getEndpoint(), brokerPort, brokerHost);
            }
            tmp.addAll(service.getCmdArg(adminPort, serviceProtocol));
        }
        HashSet tmp2 = new HashSet(tmp);
        result.addAll(tmp2);
        return result;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(DescriptorUtils.class);
    }
}

