/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.spring.SpringInstances;
import de.iip_ecosphere.platform.support.JarUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.local.AbstractLocalDeployerSupport;
import org.springframework.cloud.deployer.spi.local.DebugAddress;
import org.springframework.cloud.deployer.spi.local.JavaCommandBuilder;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.core.io.Resource;

public class ClasspathJavaCommandBuilder
extends JavaCommandBuilder {
    public static final String PROP_ZIP_CLASSPATH = "iip.spring.readZipClasspath";
    private final LocalDeployerProperties properties;
    private String curDeployerId;

    public ClasspathJavaCommandBuilder(LocalDeployerProperties properties) {
        super(properties);
        this.properties = properties;
    }

    public ProcessBuilder buildExecutionCommand(AppDeploymentRequest request, Map<String, String> appInstanceEnv, String deployerId, Optional<Integer> appInstanceNumber, LocalDeployerProperties localDeployerProperties, Optional<DebugAddress> debugAddressOption) {
        this.curDeployerId = deployerId;
        return super.buildExecutionCommand(request, appInstanceEnv, deployerId, appInstanceNumber, localDeployerProperties, debugAddressOption);
    }

    private File findWorkingDirectory() {
        File root = this.properties.getWorkingDirectoriesRoot().toFile();
        File[] cands = root.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String[] cont;
                File f;
                boolean accept = false;
                if (name.matches("^\\d+$") && (f = new File(dir, name)).isDirectory() && null != (cont = f.list())) {
                    for (String c : cont) {
                        if (!c.equals(ClasspathJavaCommandBuilder.this.curDeployerId)) continue;
                        accept = true;
                    }
                }
                return accept;
            }
        });
        if (null == cands || cands.length == 0) {
            return de.iip_ecosphere.platform.support.FileUtils.createTmpFolder((String)this.curDeployerId);
        }
        if (cands.length == 1) {
            return new File(cands[0], this.curDeployerId);
        }
        Arrays.sort(cands, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return -Long.compare(o1.lastModified(), o2.lastModified());
            }
        });
        return new File(cands[0], this.curDeployerId);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ClasspathJavaCommandBuilder.class);
    }

    private boolean copySharedLibs(File sharedLibs, File target) {
        boolean copied = false;
        if (sharedLibs.exists()) {
            target.mkdirs();
            ClasspathJavaCommandBuilder.getLogger().info("Scanning " + sharedLibs + " for shared libraries");
            File[] files = sharedLibs.listFiles();
            if (null != files) {
                for (File f : files) {
                    if (!f.getName().endsWith(".jar")) continue;
                    try {
                        Files.copy(f.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        copied = true;
                    }
                    catch (IOException e) {
                        ClasspathJavaCommandBuilder.getLogger().error("Cannot copy shared JAR file " + f + ": " + e.getMessage());
                    }
                }
            }
        }
        return copied;
    }

    private String add(String classpath, AppDeploymentRequest request, File workDir, boolean asWildcard) {
        File sharedLibs = SpringInstances.getConfig().getSharedLibs();
        StringBuilder tmp = new StringBuilder(classpath);
        if (null != sharedLibs && sharedLibs.toString().length() > 0) {
            File sharedSpecificTarget;
            File sharedTarget = new File(workDir, "shared");
            if (this.copySharedLibs(sharedLibs, sharedTarget)) {
                if (asWildcard) {
                    tmp.append(File.pathSeparator + "shared/*");
                } else {
                    de.iip_ecosphere.platform.support.FileUtils.listFiles((File)sharedTarget, f -> f.isFile() && f.getName().endsWith(".jar"), f -> tmp.append(File.pathSeparator + f.getName()));
                }
            }
            if (this.copySharedLibs(sharedLibs = new File(sharedLibs, request.getDefinition().getName()), sharedSpecificTarget = new File(workDir, "shared-specific"))) {
                if (asWildcard) {
                    tmp.append(File.pathSeparator + "shared-specific/*");
                } else {
                    de.iip_ecosphere.platform.support.FileUtils.listFiles((File)sharedSpecificTarget, f -> f.isFile() && f.getName().endsWith(".jar"), f -> tmp.append(File.pathSeparator + f.getName()));
                }
            }
        }
        return tmp.toString();
    }

    private boolean checkCpFile(File cpFile, AppDeploymentRequest request, File workDir) {
        boolean result = false;
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9) && Boolean.valueOf(System.getProperty(PROP_ZIP_CLASSPATH, "true")).booleanValue()) {
            try {
                String classpath = FileUtils.readFileToString((File)cpFile, (String)"UTF-8");
                String mainJars = "";
                File[] files = workDir.listFiles();
                if (null != files) {
                    for (File f : files) {
                        if (!f.getName().endsWith(".jar")) continue;
                        if (mainJars.length() > 0) {
                            mainJars = mainJars + File.pathSeparator;
                        }
                        mainJars = mainJars + f.getName();
                    }
                }
                if (mainJars.length() > 0) {
                    classpath = mainJars + File.pathSeparator + classpath;
                }
                classpath = this.add(classpath, request, workDir, false);
                String fileSep = File.separator;
                if (fileSep.equals("\\")) {
                    fileSep = "\\\\";
                }
                classpath = classpath.replace("/", fileSep).replace(':', File.pathSeparatorChar);
                classpath = "-cp \"" + classpath + "\"";
                FileUtils.writeStringToFile((File)cpFile, (String)classpath, (String)"UTF-8");
                result = true;
            }
            catch (IOException e) {
                ClasspathJavaCommandBuilder.getLogger().info("Cannot rewrite classpath file: " + e.getMessage() + " Falling back to wildcard classpath.");
                result = false;
            }
        }
        return result;
    }

    protected void addJavaExecutionOptions(List<String> commands, AppDeploymentRequest request) {
        try {
            Resource resource = request.getResource();
            String path = resource.getFile().getAbsolutePath();
            if (path.endsWith(".zip")) {
                FileInputStream zis = new FileInputStream(path);
                File workDir = this.findWorkingDirectory();
                ClasspathJavaCommandBuilder.getLogger().info("Unpacking Jars into " + workDir.getAbsolutePath());
                JarUtils.extractZip((InputStream)zis, (Path)workDir.toPath());
                zis.close();
                File cpFile = new File(workDir, "classpath");
                if (cpFile.exists() && this.checkCpFile(cpFile, request, workDir)) {
                    commands.add("@classpath");
                } else {
                    String classpath = "*" + File.pathSeparator + "jars/*";
                    classpath = this.add(classpath, request, workDir, true);
                    commands.add("-cp");
                    commands.add(classpath);
                }
                commands.add("iip.Starter");
            } else {
                commands.add("-jar");
                commands.add(path);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void cleanWorkdirs(LocalDeployerProperties properties) {
        File root = properties.getWorkingDirectoriesRoot().toFile();
        File[] cands = root.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                return f.isDirectory() && name.matches("^\\d+$") && name.length() >= 13;
            }
        });
        if (cands != null) {
            for (File f : cands) {
                de.iip_ecosphere.platform.support.FileUtils.deleteQuietly((File)f);
            }
        }
    }

    static void installInto(AppDeployer deployer) {
        if (null != deployer) {
            try {
                Field jBuilder = AbstractLocalDeployerSupport.class.getDeclaredField("javaCommandBuilder");
                jBuilder.setAccessible(true);
                Method locProps = AbstractLocalDeployerSupport.class.getDeclaredMethod("getLocalDeployerProperties", new Class[0]);
                locProps.setAccessible(true);
                LocalDeployerProperties localPropsInst = (LocalDeployerProperties)locProps.invoke((Object)deployer, new Object[0]);
                ClasspathJavaCommandBuilder.cleanWorkdirs(localPropsInst);
                jBuilder.set(deployer, (Object)new ClasspathJavaCommandBuilder(localPropsInst));
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                ClasspathJavaCommandBuilder.getLogger().error("Cannot reconfigure Spring Java Command Builder, ZIP service artifacts will not work here!");
            }
        }
    }
}

