/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.ArtifactDescriptor;
import de.iip_ecosphere.platform.services.ServiceDescriptor;
import de.iip_ecosphere.platform.services.ServiceFactory;
import de.iip_ecosphere.platform.services.ServiceManager;
import de.iip_ecosphere.platform.services.ServicesAas;
import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceMapper;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.MeterRepresentation;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsAasConstructor;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceDescriptor;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceManager;
import de.iip_ecosphere.platform.services.spring.SpringCloudServiceSetup;
import de.iip_ecosphere.platform.services.spring.StartupApplicationListener;
import de.iip_ecosphere.platform.services.spring.descriptor.ProcessSpec;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasPrintVisitor;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.AasUtils;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.net.ManagedServerAddress;
import de.iip_ecosphere.platform.support.net.NetworkManager;
import de.iip_ecosphere.platform.support.net.NetworkManagerFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.local.LocalAppDeployer;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;
import test.de.iip_ecosphere.platform.test.amqp.qpid.TestQpidServer;

@SpringBootTest(classes={Config.class})
@TestPropertySource(locations={"classpath:iipecosphere.yml"})
@ContextConfiguration(initializers={Initializer.class})
@Import(value={SpringCloudServiceSetup.class})
@RunWith(value=SpringRunner.class)
public class TestServiceManager {
    private static final Predicate<Object> POSITIVE_GAUGE_VALUE = o -> {
        if (o instanceof Number) {
            return ((Number)o).doubleValue() > 0.0;
        }
        if (o != null) {
            Meter meter = MeterRepresentation.parseMeter((String)o.toString(), (String[])new String[0]);
            Assert.assertTrue((boolean)(meter instanceof Gauge));
            return ((Gauge)meter).value() > 0.0;
        }
        System.out.println("Warning: Predicate value is null. For Jenkins, assuming all is fine.");
        return true;
    };
    private static final ServerAddress BROKER = new ServerAddress(Schema.IGNORE);
    private static Server server;
    private static ActiveAasBase.NotificationMode oldM;
    private static AasPartRegistry.AasSetup oldSetup;
    private static Server implServer;
    private static Server aasServer;
    @Autowired
    private SpringCloudServiceSetup config;
    private List<String> netKeyToRelease = new ArrayList<String>();
    private List<Server> serversToRelease = new ArrayList<Server>();

    @BeforeClass
    public static void init() {
        server = new TestQpidServer(BROKER);
        TransportSetup setup = ServiceFactory.getTransport();
        setup.setPort(BROKER.getPort());
        setup.setHost("localhost");
        setup.setAuthenticationKey("amqp");
        server.start();
        oldM = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS);
        Assert.assertTrue((boolean)AasPartRegistry.contributorClasses().contains(ServicesAas.class));
        oldSetup = AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)AasPartRegistry.AasSetup.createLocalEphemeralSetup());
        AasPartRegistry.AasBuildResult res = AasPartRegistry.build(c -> c instanceof ServicesAas);
        implServer = (Server)res.getProtocolServerBuilder().build();
        implServer.start();
        aasServer = AasPartRegistry.deploy((List)res.getAas(), (String[])new String[0]);
        aasServer.start();
    }

    @AfterClass
    public static void shutdown() {
        MetricsAasConstructor.clear();
        server.stop(false);
        aasServer.stop(true);
        implServer.stop(true);
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)oldSetup);
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)oldM);
    }

    @Test
    public void testSimpleStartStop() throws ExecutionException, IOException {
        this.doTestStartStop("deployment.yml", new ArtifactAsserter(){
            private File homePath;

            @Override
            public void testDeployment(ArtifactDescriptor aDesc) {
                ServiceDescriptor sDesc = aDesc.getService("simpleStream-create");
                Assert.assertTrue((boolean)(sDesc instanceof SpringCloudServiceDescriptor));
                ProcessSpec pspec = ((SpringCloudServiceDescriptor)sDesc).getSvc().getProcess();
                Assert.assertNotNull((Object)pspec);
                Assert.assertTrue((boolean)pspec.isStarted());
                Assert.assertNotNull((Object)pspec.getArtifacts());
                Assert.assertEquals((long)2L, (long)pspec.getArtifacts().size());
                this.homePath = pspec.getHomePath();
                Assert.assertNotNull((Object)this.homePath);
                Assert.assertTrue((this.homePath.toString().indexOf("${tmp}") < 0 ? 1 : 0) != 0);
                Assert.assertNotNull((Object)pspec.getExecutablePath());
                Assert.assertTrue((pspec.getExecutablePath().toString().indexOf("${tmp}") < 0 ? 1 : 0) != 0);
                TestServiceManager.assertFileExists(new File(this.homePath, "test.txt"));
                TestServiceManager.assertFileExists(new File(this.homePath, "test2.txt"));
            }

            @Override
            public void cleanup(ArtifactDescriptor aDesc) {
                FileUtils.deleteQuietly((File)this.homePath);
            }
        }, false);
    }

    private static final void assertFileExists(File file) {
        Assert.assertTrue((String)("File " + file + " does not exist"), (boolean)file.exists());
    }

    @Test
    public void testEnsembleStartStop() throws ExecutionException, IOException {
        Assume.assumeFalse((boolean)NetUtils.getOwnHostname().equals("jenkins-2"));
        this.doTestStartStop("deployment1.yml", new ArtifactAsserter(){}, false);
    }

    private void doTestStartStop(String descriptorName, ArtifactAsserter asserter, boolean fakeServer) throws ExecutionException, IOException {
        this.config.setDescriptorName(descriptorName);
        ServiceManager mgr = ServiceFactory.getServiceManager();
        Assert.assertTrue((boolean)(mgr instanceof SpringCloudServiceManager));
        ((SpringCloudServiceManager)mgr).clear();
        File f = new File("./target/jars/simpleStream.spring.jar");
        Assert.assertTrue((String)("Test cannot be executed as " + f + " does not exist. Was it downloaded by Maven?"), (boolean)f.exists());
        String aId = mgr.addArtifact(f.toURI());
        Assert.assertNotNull((Object)aId);
        Assert.assertTrue((aId.length() > 0 ? 1 : 0) != 0);
        ArtifactDescriptor aDesc = mgr.getArtifact(aId);
        Assert.assertNotNull((Object)aDesc);
        Assert.assertTrue((boolean)mgr.getArtifactIds().contains(aId));
        Assert.assertTrue((boolean)mgr.getArtifacts().contains(aDesc));
        Assert.assertTrue((aDesc.getServiceIds().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)aDesc.getServiceIds().contains("simpleStream-create"));
        Assert.assertTrue((boolean)aDesc.getServiceIds().contains("simpleStream-log"));
        Assert.assertTrue((aDesc.getServices().size() == 2 ? 1 : 0) != 0);
        ServiceDescriptor inputService = aDesc.getService("simpleStream-create");
        ServiceDescriptor outputService = aDesc.getService("simpleStream-log");
        Assert.assertTrue((boolean)aDesc.getServices().contains(inputService));
        Assert.assertTrue((boolean)aDesc.getServices().contains(outputService));
        asserter.testDescriptor(aDesc);
        for (Object sDesc : aDesc.getServices()) {
            Assert.assertNotNull((Object)sDesc.getId());
            Assert.assertTrue((sDesc.getId().length() > 0 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)sDesc.getVersion());
            Assert.assertNotNull((Object)sDesc.getName());
            Assert.assertTrue((sDesc.getName().length() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)ServiceState.AVAILABLE, (Object)sDesc.getState());
        }
        Object[] ids = new String[aDesc.getServices().size()];
        aDesc.getServiceIds().toArray(ids);
        if (fakeServer) {
            this.startFakeServiceCommandServers(mgr, (String[])ids);
        }
        System.out.println("STARTING " + mgr + " " + Arrays.toString(ids));
        mgr.startService((String[])ids);
        for (ServiceDescriptor sDesc : aDesc.getServices()) {
            Assert.assertEquals((String)("Service " + sDesc.getId() + " " + sDesc.getName() + " not running: " + sDesc.getState()), (Object)ServiceState.RUNNING, (Object)sDesc.getState());
        }
        Aas aas = AasPartRegistry.retrieveIipAas();
        Submodel sub = aas.getSubmodel("services");
        Assert.assertNotNull((Object)sub);
        sub.accept((AasVisitor)new AasPrintVisitor());
        TimeUtils.sleep((int)5000);
        HashMap<String, Predicate<Object>> expectedMetrics = new HashMap<String, Predicate<Object>>();
        expectedMetrics.put("Memory_Capacity", POSITIVE_GAUGE_VALUE);
        expectedMetrics.put("Allocated_Memory", POSITIVE_GAUGE_VALUE);
        this.assertMetrics((String[])ids, expectedMetrics);
        asserter.testDeployment(aDesc);
        mgr.stopService((String[])ids);
        this.releaseFakeServiceCommandServers();
        for (ServiceDescriptor sDesc : aDesc.getServices()) {
            Assert.assertEquals((String)("Service " + sDesc.getId() + " " + sDesc.getName() + " not stopped: " + sDesc.getState()), (Object)ServiceState.STOPPED, (Object)sDesc.getState());
        }
        asserter.cleanup(aDesc);
        mgr.removeArtifact(aId);
        Assert.assertFalse((boolean)mgr.getArtifactIds().contains(aId));
        Assert.assertFalse((boolean)mgr.getArtifacts().contains(aDesc));
        Assert.assertNull((Object)mgr.getArtifact(aId));
        TestServiceManager.assertReceiverLog();
        MetricsAasConstructor.clear();
    }

    private static void assertReceiverLog() {
        File f = new File(FileUtils.getTempDirectoryPath() + "/test.simpleStream.spring.log");
        Assert.assertTrue((String)"Receiver log does not exist", (boolean)f.exists());
        Assert.assertTrue((String)"Receiver log is empty", (f.length() > 0L ? 1 : 0) != 0);
    }

    private void assertMetrics(String[] ids, Map<String, Predicate<Object>> expected) throws IOException, ExecutionException {
        Aas aas = AasPartRegistry.retrieveIipAas();
        Submodel sub = aas.getSubmodel("services");
        Assert.assertNotNull((Object)sub);
        sub.accept((AasVisitor)new AasPrintVisitor());
        SubmodelElementCollection services = sub.getSubmodelElementCollection("services");
        Assert.assertNotNull((Object)sub);
        for (String id : ids) {
            SubmodelElementCollection service = services.getSubmodelElementCollection(AasUtils.fixId((String)id));
            Assert.assertNotNull((Object)service);
            for (Map.Entry<String, Predicate<Object>> ent : expected.entrySet()) {
                Property prop = service.getProperty(ent.getKey());
                Assert.assertNotNull((String)(ent.getKey() + " missing"), (Object)prop);
                Predicate<Object> pred = ent.getValue();
                if (null == pred) continue;
                Object val = prop.getValue();
                Assert.assertTrue((boolean)pred.test(val));
            }
        }
    }

    private void startFakeServiceCommandServers(ServiceManager mgr, String[] ids) {
        NetworkManager nMgr = NetworkManagerFactory.getInstance();
        for (String id : ids) {
            String key = Starter.getServiceCommandNetworkMgrKey((String)id);
            ManagedServerAddress addr = nMgr.obtainPort(key);
            if (addr.isNew()) {
                this.netKeyToRelease.add(key);
            }
            ServiceDescriptor desc = mgr.getService(id);
            ProtocolServerBuilder sBuilder = AasFactory.getInstance().createProtocolServerBuilder(this.config.getServiceProtocol(), addr.getPort());
            ServiceMapper mapper = new ServiceMapper(sBuilder);
            mapper.mapService((Service)new ServiceImpl(desc));
            Server server = (Server)sBuilder.build();
            server.start();
            this.serversToRelease.add(server);
        }
    }

    private void releaseFakeServiceCommandServers() {
        for (Server s : this.serversToRelease) {
            s.stop(true);
        }
        NetworkManager nMgr = NetworkManagerFactory.getInstance();
        for (String key : this.netKeyToRelease) {
            nMgr.releasePort(key);
        }
    }

    @Test
    public void testSetup() {
        Assert.assertNotNull((Object)this.config.getJavaOpts());
        Assert.assertTrue((this.config.getJavaOpts().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWithZipArchiveNoClasspath() throws ExecutionException {
        Assume.assumeFalse((boolean)NetUtils.getOwnHostname().equals("jenkins-2"));
        this.testWithZipArchive(false);
        TestServiceManager.assertReceiverLog();
    }

    @Test
    public void testWithZipArchiveAndClasspath() throws ExecutionException {
        Assume.assumeFalse((boolean)NetUtils.getOwnHostname().equals("jenkins-2"));
        this.testWithZipArchive(true);
        TestServiceManager.assertReceiverLog();
    }

    private void testWithZipArchive(boolean useClasspath) throws ExecutionException {
        String prop = System.getProperty("iip.spring.readZipClasspath", "");
        System.setProperty("iip.spring.readZipClasspath", String.valueOf(useClasspath));
        ServiceManager mgr = ServiceFactory.getServiceManager();
        File file = new File("target/jars/simpleStream.spring.zip");
        String aid = mgr.addArtifact(file.toURI());
        mgr.startService(new String[]{"simpleStream-create", "simpleStream-log"});
        TimeUtils.sleep((int)5000);
        mgr.stopService(new String[]{"simpleStream-create", "simpleStream-log"});
        mgr.removeArtifact(aid);
        System.setProperty("iip.spring.readZipClasspath", prop);
    }

    @Configuration
    @EnableConfigurationProperties(value={LocalDeployerProperties.class})
    public static class Config {
        @Bean
        public AppDeployer appDeployer(LocalDeployerProperties properties) {
            return new LocalAppDeployer(properties);
        }

        @Component
        class Startup
        extends StartupApplicationListener {
            Startup() {
            }
        }
    }

    @Import(value={SpringCloudServiceSetup.class})
    public static class Initializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        public void initialize(ConfigurableApplicationContext applicationContext) {
            TestPropertyValues.of((String[])new String[]{"service-mgr.brokerPort=" + BROKER.getPort()}).applyTo(applicationContext);
        }
    }

    private static class ServiceImpl
    extends AbstractService {
        protected ServiceImpl(ServiceDescriptor desc) {
            super(desc.getId(), desc.getName(), desc.getVersion(), desc.getDescription(), desc.isDeployable(), desc.isTopLevel(), desc.getKind());
        }

        public void migrate(String resourceId) throws ExecutionException {
        }

        public void update(URI location) throws ExecutionException {
        }

        public void switchTo(String targetId) throws ExecutionException {
        }

        public void reconfigure(Map<String, String> values) throws ExecutionException {
        }
    }

    private class ArtifactAsserter {
        private ArtifactAsserter() {
        }

        public void testDescriptor(ArtifactDescriptor desc) {
        }

        public void testDeployment(ArtifactDescriptor desc) {
        }

        public void cleanup(ArtifactDescriptor desc) {
        }
    }
}

