/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.spring;

import de.iip_ecosphere.platform.services.spring.Utils;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class UtilsTest {
    @Test
    public void testFormatToMeBi() {
        Assert.assertEquals((Object)"0", (Object)Utils.formatToMeBi((long)0L));
        Assert.assertEquals((Object)"1", (Object)Utils.formatToMeBi((long)1L));
        Assert.assertEquals((Object)"1025", (Object)Utils.formatToMeBi((long)1025L));
        Assert.assertEquals((Object)"1m", (Object)Utils.formatToMeBi((long)0x100000L));
        Assert.assertEquals((Object)"1m", (Object)Utils.formatToMeBi((long)0x100001L));
        Assert.assertEquals((Object)"4m", (Object)Utils.formatToMeBi((long)0x400000L));
        Assert.assertEquals((Object)"1g", (Object)Utils.formatToMeBi((long)0x40000000L));
        Assert.assertEquals((Object)"1g", (Object)Utils.formatToMeBi((long)0x40000001L));
    }

    @Test
    public void testFormatToMeBiBase() {
        Assert.assertEquals((Object)"0", (Object)Utils.formatToMeBi((long)0L));
        Assert.assertEquals((Object)"1", (Object)Utils.formatToMeBi((long)1L));
        Assert.assertEquals((Object)"1025", (Object)Utils.formatToMeBi((long)1025L));
        Assert.assertEquals((Object)"1m", (Object)Utils.formatToMeBi((long)1024L, (int)1));
        Assert.assertEquals((Object)"1m", (Object)Utils.formatToMeBi((long)1L, (int)2));
        Assert.assertEquals((Object)"1m", (Object)Utils.formatToMeBi((long)1025L, (int)1));
        Assert.assertEquals((Object)"4m", (Object)Utils.formatToMeBi((long)4096L, (int)1));
        Assert.assertEquals((Object)"4m", (Object)Utils.formatToMeBi((long)4L, (int)2));
        Assert.assertEquals((Object)"1g", (Object)Utils.formatToMeBi((long)0x100000L, (int)1));
        Assert.assertEquals((Object)"1g", (Object)Utils.formatToMeBi((long)0x100001L, (int)1));
        Assert.assertEquals((Object)"15g", (Object)Utils.formatToMeBi((long)0xF00000L, (int)1));
        Assert.assertEquals((Object)"1024g", (Object)Utils.formatToMeBi((long)0x40000000L, (int)1));
    }

    @Test
    public void testAddPropertiesInt() {
        HashMap prop = new HashMap();
        Utils.addPropertyIfPositiveToInt(prop, (String)"a", (Number)-1, null);
        Assert.assertFalse((boolean)prop.containsKey("a"));
        Utils.addPropertyIfPositiveToInt(prop, (String)"a", (Number)-1, (String)"0");
        Assert.assertEquals((Object)"0", prop.get("a"));
        Utils.addPropertyIfPositiveToInt(prop, (String)"b", (Number)5, (String)"0");
        Assert.assertEquals((Object)"5", prop.get("b"));
    }

    @Test
    public void testAddPropertiesMeBi() {
        HashMap prop = new HashMap();
        Utils.addPropertyIfPositiveToMeBi(prop, (String)"c", (Number)-1, null);
        Assert.assertFalse((boolean)prop.containsKey("c"));
        Utils.addPropertyIfPositiveToMeBi(prop, (String)"c", (Number)-1, (String)"1m");
        Assert.assertEquals((Object)"1m", prop.get("c"));
        Utils.addPropertyIfPositiveToMeBi(prop, (String)"d", (Number)1, null);
        Assert.assertEquals((Object)"1m", prop.get("d"));
        Utils.addPropertyIfPositiveToMeBi(prop, (String)"e", (Number)1024, null);
        Assert.assertEquals((Object)"1g", prop.get("e"));
    }
}

