/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment.services;

import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.services.environment.services.TraceToAasService;
import de.iip_ecosphere.platform.services.environment.services.TransportConverter;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ApplicationSetup;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.status.TraceRecord;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.environment.services.TraceToAasServiceMain;

public class TraceToAasServiceTest {
    @BeforeClass
    public static void startup() {
        TraceToAasServiceMain.startup(null, -1, -1, -1);
    }

    @AfterClass
    public static void shutdown() {
        TraceToAasServiceMain.shutdown();
    }

    @Test
    public void testService() throws ExecutionException, IOException {
        TraceToAasService service = TraceToAasServiceMain.createService();
        int cleanupTimeout = 2000;
        service.setTimeout(2000L);
        service.setCleanupTimeout(2000L);
        ApplicationSetup app = service.getApplicationSetup();
        service.setState(ServiceState.STARTING);
        Assert.assertEquals((Object)ServiceState.RUNNING, (Object)service.getState());
        TimeUtils.waitFor(() -> !service.isAasStarted(), (int)5000, (int)300);
        System.out.println("Sending...");
        int[] img = new int[]{128, 128, 64, 12, 0, 8};
        TraceToAasServiceMain.MyData data = new TraceToAasServiceMain.MyData(img);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("source", "send", (Object)data));
        TimeUtils.sleep((int)700);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("receiver", "received", (Object)data));
        TimeUtils.sleep((int)700);
        Aas aas = AasPartRegistry.retrieveAas((AasPartRegistry.AasSetup)Starter.getSetup().getAas(), (String)service.getAasUrn());
        Assert.assertNotNull((Object)aas);
        Submodel submodel = aas.getSubmodel("TechnicalData");
        Assert.assertNotNull((Object)submodel);
        Property prop = submodel.getProperty("Id");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)app.getId(), (Object)prop.getValue());
        prop = submodel.getProperty("name");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)app.getName(), (Object)prop.getValue());
        SubmodelElementCollection.SubmodelElementCollectionBuilder epBuilder = submodel.createSubmodelElementCollectionBuilder("testEpContainer", false, false);
        TransportConverter.addEndpointToAas((SubmodelElementContainerBuilder)epBuilder, null);
        TransportConverter.addEndpointToAas((SubmodelElementContainerBuilder)epBuilder, (Endpoint)new Endpoint(Schema.HTTP, "localhost", 1234, ""));
        TransportConverter.addEndpointToAas((SubmodelElementContainerBuilder)epBuilder, (Endpoint)new Endpoint(Schema.WS, "localhost", 1235, "/myPath"));
        epBuilder.build();
        submodel = aas.getSubmodel("Traces");
        if (service.isTraceInAas()) {
            HashMap<String, SubmodelElementCollection> elts = new HashMap<String, SubmodelElementCollection>();
            for (SubmodelElement e : submodel.submodelElements()) {
                if (!(e instanceof SubmodelElementCollection)) continue;
                SubmodelElementCollection coll = (SubmodelElementCollection)e;
                prop = coll.getProperty("Source");
                Assert.assertNotNull((Object)prop);
                elts.put(prop.getValue().toString(), coll);
                SubmodelElementCollection pColl = coll.getSubmodelElementCollection("Payload");
                Assert.assertNotNull((Object)pColl);
                Assert.assertTrue((pColl.getElementsCount() > 0 ? 1 : 0) != 0);
                elts.put(prop.getValue().toString(), coll);
            }
            Assert.assertNotNull(elts.get("source"));
            Assert.assertNotNull(elts.get("receiver"));
        }
        System.out.println("Waiting for cleanup... (max 2000 ms)");
        TimeUtils.sleep((int)2000);
        service.cleanup();
        aas = AasPartRegistry.retrieveAas((AasPartRegistry.AasSetup)Starter.getSetup().getAas(), (String)service.getAasUrn());
        Assert.assertNotNull((Object)aas);
        submodel = aas.getSubmodel("Traces");
        int remainingCount = 0;
        for (SubmodelElement e : submodel.submodelElements()) {
            if (!(e instanceof SubmodelElementCollection)) continue;
            ++remainingCount;
        }
        if (service.isTraceInAas()) {
            Assert.assertEquals((long)0L, (long)remainingCount);
        }
        service.setState(ServiceState.STOPPING);
    }
}

