/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.UpdatingMonitoringService;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;

public class MonitoringServiceTest {
    @Test
    public void testSetup() {
        MonitoringService.setUp(null, null);
        MetricsProvider prov = new MetricsProvider((MeterRegistry)new SimpleMeterRegistry());
        MonitoringService.setUp(null, (MetricsProvider)prov);
        MyService service = new MyService();
        MonitoringService.setUp((Service)service, (MetricsProvider)prov);
        MyMonitoringService mService = new MyMonitoringService();
        MonitoringService.setUp((Service)mService, (MetricsProvider)prov);
        MyUpdatingMonitoringService uService = new MyUpdatingMonitoringService();
        MonitoringService.setUp((Service)uService, (MetricsProvider)prov);
        Assert.assertTrue((mService.provider == prov ? 1 : 0) != 0);
        Assert.assertTrue((uService.provider == prov ? 1 : 0) != 0);
        prov.calculateMetrics();
        Assert.assertTrue((boolean)uService.called);
    }

    private static class MyUpdatingMonitoringService
    extends MyMonitoringService
    implements UpdatingMonitoringService {
        private boolean called = false;

        private MyUpdatingMonitoringService() {
        }

        public void calculateMetrics() {
            this.called = true;
        }
    }

    private static class MyMonitoringService
    extends MyService
    implements MonitoringService {
        protected MetricsProvider provider;

        private MyMonitoringService() {
        }

        public void attachMetricsProvider(MetricsProvider provider) {
            this.provider = provider;
        }
    }

    private static class MyService
    extends AbstractService {
        protected MyService() {
            super(ServiceKind.PROBE_SERVICE);
        }

        public void migrate(String resourceId) throws ExecutionException {
        }

        public void update(URI location) throws ExecutionException {
        }

        public void switchTo(String targetId) throws ExecutionException {
        }
    }
}

