/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.types.AbstractConnectorInputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.AbstractConnectorOutputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.TranslatingProtocolAdapter;
import de.iip_ecosphere.platform.services.environment.ConnectorServiceWrapper;
import de.iip_ecosphere.platform.services.environment.MockingConnectorServiceWrapper;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.environment.ConnectorImpl;

public class ConnectorServiceWrapperTest {
    @Test
    public void testWrapper() throws ExecutionException {
        ActiveAasBase.NotificationMode mo = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.NONE);
        YamlService yaml = this.getYamlService();
        ConnectorImpl conn = new ConnectorImpl(new ProtocolAdapter[]{this.createConnectorAdapter()});
        ConnectorParameter param = ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)"localhost", (int)0).build();
        ConnectorServiceWrapper wrapper = new ConnectorServiceWrapper(this.getYamlService(), conn, () -> param);
        this.testWrapper(wrapper, yaml);
        this.testStopWrapper(wrapper);
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)mo);
    }

    @Test
    public void testMockingWrapper() throws ExecutionException {
        ActiveAasBase.NotificationMode mo = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.NONE);
        YamlService yaml = this.getYamlService();
        ConnectorImpl conn = new ConnectorImpl(new ProtocolAdapter[]{this.createConnectorAdapter()});
        ConnectorParameter param = ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)"localhost", (int)0).build();
        MockingConnectorServiceWrapper wrapper = new MockingConnectorServiceWrapper(yaml, conn, () -> param);
        final AtomicInteger inRcv = new AtomicInteger(0);
        final AtomicInteger rcv = new AtomicInteger(0);
        wrapper.setInputCallback((ReceptionCallback)new ReceptionCallback<Object>(){

            public void received(Object data) {
                inRcv.incrementAndGet();
            }

            public Class<Object> getType() {
                return Object.class;
            }
        });
        wrapper.setReceptionCallback((ReceptionCallback)new ReceptionCallback<Object>(){

            public void received(Object data) {
                rcv.incrementAndGet();
            }

            public Class<Object> getType() {
                return Object.class;
            }
        });
        this.testWrapper((ConnectorServiceWrapper)wrapper, yaml);
        wrapper.send(new Object());
        TimeUtils.sleep((int)1000);
        Assert.assertTrue((inRcv.get() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((rcv.get() > 0 ? 1 : 0) != 0);
        this.testStopWrapper((ConnectorServiceWrapper)wrapper);
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)mo);
    }

    private YamlService getYamlService() {
        YamlService yaml = new YamlService();
        yaml.setId("id");
        yaml.setName("name");
        yaml.setKind(ServiceKind.PROBE_SERVICE);
        yaml.setDescription("desc");
        yaml.setVersion(new Version("1.0.0"));
        yaml.setDeployable(true);
        return yaml;
    }

    private TranslatingProtocolAdapter<Object, Object, Object, Object> createConnectorAdapter() {
        return new TranslatingProtocolAdapter((ConnectorOutputTypeTranslator)new IdentityOutputTranslator(), (ConnectorInputTypeTranslator)new IdentityInputTranslator());
    }

    private <O, I, CO, CI> void testWrapper(ConnectorServiceWrapper<O, I, CO, CI> wrapper, YamlService yaml) throws ExecutionException {
        Assert.assertNotNull((Object)wrapper.getConnector());
        Assert.assertEquals((Object)yaml.getId(), (Object)wrapper.getId());
        Assert.assertEquals((Object)yaml.getName(), (Object)wrapper.getName());
        Assert.assertEquals((Object)yaml.getDescription(), (Object)wrapper.getDescription());
        Assert.assertEquals((Object)yaml.getKind(), (Object)wrapper.getKind());
        Assert.assertEquals((Object)yaml.getVersion(), (Object)wrapper.getVersion());
        Assert.assertEquals((Object)ServiceState.AVAILABLE, (Object)wrapper.getState());
        Assert.assertNull((Object)wrapper.getParameterConfigurer(null));
        wrapper.enablePolling(false);
        wrapper.setState(ServiceState.STARTING);
        Assert.assertEquals((Object)ServiceState.RUNNING, (Object)wrapper.getState());
        wrapper.enableNotifications(false);
        wrapper.enablePolling(true);
        Assert.assertEquals((Object)"myPathOut", (Object)wrapper.getOutPath("myPathOut"));
        Assert.assertEquals((Object)"myPathIn", (Object)wrapper.getInPath("myPathIn"));
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("inPath", "/pi/1/");
        values.put("outPath", "/po/2/");
        wrapper.reconfigure(values);
        Assert.assertEquals((Object)"/po/2/", (Object)wrapper.getOutPath("myPathOut"));
        Assert.assertEquals((Object)"/pi/1/", (Object)wrapper.getInPath("myPathIn"));
    }

    private <O, I, CO, CI> void testStopWrapper(ConnectorServiceWrapper<O, I, CO, CI> wrapper) throws ExecutionException {
        wrapper.setState(ServiceState.STOPPING);
        Assert.assertEquals((Object)ServiceState.STOPPED, (Object)wrapper.getState());
    }

    private static class IdentityInputTranslator
    extends AbstractConnectorInputTypeTranslator<Object, Object> {
        private IdentityInputTranslator() {
        }

        public Class<? extends Object> getSourceType() {
            return Object.class;
        }

        public Class<? extends Object> getTargetType() {
            return Object.class;
        }

        public Object from(Object data) throws IOException {
            return data;
        }
    }

    private static class IdentityOutputTranslator
    extends AbstractConnectorOutputTypeTranslator<Object, Object> {
        private IdentityOutputTranslator() {
        }

        public void initializeModelAccess() throws IOException {
        }

        public Class<? extends Object> getSourceType() {
            return Object.class;
        }

        public Class<? extends Object> getTargetType() {
            return Object.class;
        }

        public Object to(Object source) throws IOException {
            return source;
        }
    }
}

