/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractRestProcessService;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import spark.Route;
import spark.Spark;

public class AbstractRestProcessServiceTest {
    private static final String PATH = "/services/repeater";
    private static final String TEST_REST = "{\"field\":\"abc\"}";
    private int port;

    public static Stream<String> lines(String string) {
        return Stream.of(string.replace("\r\n", "\n").split("\n"));
    }

    @Test
    public void testRestProcess() throws ExecutionException {
        Route route = (req, res) -> {
            String request = AbstractRestProcessServiceTest.lines(req.body()).collect(Collectors.joining("\n"));
            res.body(request);
            res.status(200);
            return res.body();
        };
        this.port = NetUtils.getEphemeralPort();
        Spark.port((int)this.port);
        Spark.post((String)PATH, (Route)route);
        Spark.get((String)PATH, (Route)route);
        Spark.put((String)PATH, (Route)route);
        Spark.delete((String)PATH, (Route)route);
        Spark.awaitInitialization();
        final AtomicInteger rcv = new AtomicInteger();
        ReceptionCallback<String> callback = new ReceptionCallback<String>(){

            public void received(String data) {
                Assert.assertEquals((Object)AbstractRestProcessServiceTest.TEST_REST, (Object)data);
                rcv.incrementAndGet();
            }

            public Class<String> getType() {
                return String.class;
            }
        };
        YamlService yaml = new YamlService();
        yaml.setDeployable(true);
        yaml.setTopLevel(true);
        yaml.setName("testRest");
        yaml.setKind(ServiceKind.TRANSFORMATION_SERVICE);
        yaml.setDescription("");
        yaml.setVersion(new Version("0.0.1"));
        yaml.setId("testRest");
        MyRestProcessService service = new MyRestProcessService(new MyTypeTranslator(), new MyTypeTranslator(), callback, yaml);
        service.setState(ServiceState.STARTING);
        service.processQuiet(TEST_REST);
        TimeUtils.sleep((int)1000);
        Assert.assertTrue((rcv.get() > 0 ? 1 : 0) != 0);
        service.setState(ServiceState.STOPPING);
        Spark.stop();
        Spark.awaitStop();
    }

    private static class MyTypeTranslator
    implements TypeTranslator<String, String> {
        private MyTypeTranslator() {
        }

        public String from(String data) throws IOException {
            return data;
        }

        public String to(String data) throws IOException {
            return data;
        }
    }

    private class MyRestProcessService
    extends AbstractRestProcessService<String, String> {
        protected MyRestProcessService(TypeTranslator<String, String> inTrans, TypeTranslator<String, String> outTrans, ReceptionCallback<String> callback, YamlService yaml) {
            super(inTrans, outTrans, callback, yaml);
        }

        public void migrate(String resourceId) throws ExecutionException {
        }

        public void update(URI location) throws ExecutionException {
        }

        public void switchTo(String targetId) throws ExecutionException {
        }

        protected String getApiPath() {
            return "http://localhost:" + AbstractRestProcessServiceTest.this.port + AbstractRestProcessServiceTest.PATH;
        }

        protected String getBearerToken() {
            return null;
        }

        protected String adjustRestQuery(String input, String inTypeName) {
            return input;
        }

        protected String adjustRestResponse(String response) {
            return response;
        }

        protected ServiceState start() throws ExecutionException {
            this.setupConnectionManager();
            return ServiceState.RUNNING;
        }
    }
}

