/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractDelegatingService;
import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;

public class AbstractDelegatingServiceTest {
    @Test
    public void test() throws ExecutionException {
        MyService service = new MyService("id", "name", new Version("1.23"), "desc", true, true, ServiceKind.SOURCE_SERVICE);
        DService.setService(service);
        DService dService = new DService(new YamlService());
        Assert.assertEquals((Object)service.getId(), (Object)dService.getId());
        Assert.assertEquals((Object)service.getName(), (Object)dService.getName());
        Assert.assertEquals((Object)service.getVersion(), (Object)dService.getVersion());
        Assert.assertEquals((Object)service.getDescription(), (Object)dService.getDescription());
        Assert.assertEquals((Object)service.isDeployable(), (Object)dService.isDeployable());
        Assert.assertEquals((Object)service.isTopLevel(), (Object)dService.isTopLevel());
        Assert.assertEquals((Object)service.getKind(), (Object)dService.getKind());
        Assert.assertEquals((Object)service.getState(), (Object)dService.getState());
        service.setState(ServiceState.STARTING);
        Assert.assertEquals((Object)service.getState(), (Object)dService.getState());
        dService.migrate("");
        dService.update(null);
        dService.activate();
        dService.passivate();
        dService.reconfigure(new HashMap());
        dService.switchTo("");
        DService.setService(null);
    }

    static class DService
    extends AbstractDelegatingService<MyService> {
        private static MyService service;

        public DService(YamlService yaml) {
            super(yaml);
        }

        static void setService(MyService svc) {
            service = svc;
        }

        protected MyService createService(YamlService yaml) {
            return service;
        }
    }

    static class MyService
    extends AbstractService {
        MyService(String id, String name, Version version, String description, boolean isDeployable, boolean isTopLevel, ServiceKind kind) {
            super(id, name, version, description, isDeployable, isTopLevel, kind);
        }

        MyService(YamlService yaml) {
            super(yaml);
        }

        public void migrate(String resourceId) throws ExecutionException {
        }

        public void update(URI location) throws ExecutionException {
        }

        public void switchTo(String targetId) throws ExecutionException {
        }
    }
}

