/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceStub;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.Type;

public class AasCreator {
    public static final String URN_AAS = "urn:::AAS:::AiTestAas#";
    public static final String AAS_NAME = "AiTestAas";
    public static final String AAS_SUBMODEL_NAME = "AiService";
    public static final String AAS_SUBMODEL_PROPERTY_ID = "id";
    public static final String AAS_SUBMODEL_PROPERTY_NAME = "name";
    public static final String AAS_SUBMODEL_PROPERTY_VERSION = "version";
    public static final String AAS_SUBMODEL_PROPERTY_DESCRIPTION = "description";
    public static final String AAS_SUBMODEL_PROPERTY_STATE = "state";
    public static final String AAS_SUBMODEL_PROPERTY_KIND = "kind";
    public static final String AAS_SUBMODEL_PROPERTY_DEPLOYABLE = "deployable";
    public static final String AAS_SUBMODEL_OPERATION_PASSIVATE = "passivate";
    public static final String AAS_SUBMODEL_OPERATION_ACTIVATE = "activate";
    public static final String AAS_SUBMODEL_OPERATION_SETSTATE = "setState";
    public static final String AAS_SUBMODEL_OPERATION_MIGRATE = "migrate";
    public static final String AAS_SUBMODEL_OPERATION_UPDATE = "update";
    public static final String AAS_SUBMODEL_OPERATION_SWITCH = "switch";
    public static final String AAS_SUBMODEL_OPERATION_RECONF = "reconfigure";

    public static Aas createAas(ServerAddress addr, Service service, String protocol) {
        return AasCreator.createAas(addr, service, protocol, null);
    }

    public static Aas createAas(ServerAddress addr, Service service, String protocol, AasResult result) {
        AasFactory factory = AasFactory.getInstance();
        InvocablesCreator iCreator = factory.createInvocablesCreator(protocol, addr.getHost(), addr.getPort());
        Aas.AasBuilder aasBuilder = factory.createAasBuilder(AAS_NAME, URN_AAS);
        Submodel.SubmodelBuilder smBuilder = aasBuilder.createSubmodelBuilder(AAS_SUBMODEL_NAME, null);
        ServiceStub stub = new ServiceStub(iCreator, service.getId());
        smBuilder.createPropertyBuilder(AAS_SUBMODEL_PROPERTY_ID).setType(Type.STRING).bind(stub.getGetter(AAS_SUBMODEL_PROPERTY_ID), stub.getSetter(AAS_SUBMODEL_PROPERTY_ID)).build();
        smBuilder.createPropertyBuilder(AAS_SUBMODEL_PROPERTY_NAME).setType(Type.STRING).bind(stub.getGetter(AAS_SUBMODEL_PROPERTY_NAME), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder(AAS_SUBMODEL_PROPERTY_VERSION).setType(Type.STRING).bind(stub.getGetter(AAS_SUBMODEL_PROPERTY_VERSION), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder(AAS_SUBMODEL_PROPERTY_DESCRIPTION).setType(Type.STRING).bind(stub.getGetter(AAS_SUBMODEL_PROPERTY_DESCRIPTION), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder(AAS_SUBMODEL_PROPERTY_STATE).setType(Type.STRING).bind(stub.getGetter(AAS_SUBMODEL_PROPERTY_STATE), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder(AAS_SUBMODEL_PROPERTY_KIND).setType(Type.STRING).bind(stub.getGetter(AAS_SUBMODEL_PROPERTY_KIND), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder(AAS_SUBMODEL_PROPERTY_DEPLOYABLE).setType(Type.BOOLEAN).bind(stub.getGetter(AAS_SUBMODEL_PROPERTY_DEPLOYABLE), InvocablesCreator.READ_ONLY).build();
        smBuilder.createOperationBuilder(AAS_SUBMODEL_OPERATION_ACTIVATE).setInvocable(stub.getOperation(AAS_SUBMODEL_OPERATION_ACTIVATE)).addOutputVariable("result", Type.STRING).build();
        smBuilder.createOperationBuilder(AAS_SUBMODEL_OPERATION_PASSIVATE).setInvocable(stub.getOperation(AAS_SUBMODEL_OPERATION_PASSIVATE)).addOutputVariable("result", Type.STRING).build();
        smBuilder.createOperationBuilder(AAS_SUBMODEL_OPERATION_SETSTATE).setInvocable(stub.getOperation(AAS_SUBMODEL_OPERATION_SETSTATE)).addInputVariable(AAS_SUBMODEL_PROPERTY_STATE, Type.STRING).addOutputVariable("result", Type.STRING).build();
        smBuilder.createOperationBuilder(AAS_SUBMODEL_OPERATION_MIGRATE).setInvocable(stub.getOperation(AAS_SUBMODEL_OPERATION_MIGRATE)).addInputVariable("resourceId", Type.STRING).addOutputVariable("result", Type.STRING).build();
        smBuilder.createOperationBuilder(AAS_SUBMODEL_OPERATION_UPDATE).setInvocable(stub.getOperation(AAS_SUBMODEL_OPERATION_UPDATE)).addInputVariable("location", Type.STRING).addOutputVariable("result", Type.STRING).build();
        smBuilder.createOperationBuilder(AAS_SUBMODEL_OPERATION_SWITCH).setInvocable(stub.getOperation("switchTo")).addInputVariable("targetId", Type.STRING).addOutputVariable("result", Type.STRING).build();
        smBuilder.createOperationBuilder(AAS_SUBMODEL_OPERATION_RECONF).setInvocable(stub.getOperation(AAS_SUBMODEL_OPERATION_RECONF)).addInputVariable("values", Type.STRING).addOutputVariable("result", Type.STRING).build();
        smBuilder.build();
        if (result != null) {
            result.stub = stub;
        }
        return (Aas)aasBuilder.build();
    }

    public static class AasResult {
        private ServiceStub stub;

        public ServiceStub getStub() {
            return this.stub;
        }
    }
}

