/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.switching;

import de.iip_ecosphere.platform.services.environment.switching.StartNewStopOld;
import de.iip_ecosphere.platform.services.environment.switching.Strategy;
import org.slf4j.LoggerFactory;

public interface ServiceSelector<T> {
    public String select(T var1);

    default public void actionCompleted(String id) {
    }

    default public void initial(String id) {
    }

    default public Strategy createStrategy() {
        return new StartNewStopOld();
    }

    public static <T> ServiceSelector<T> createInstance(ClassLoader loader, String cls, Class<T> type, String dflt) {
        ServiceSelector<Object> result = null;
        try {
            Class<?> c = loader.loadClass(cls);
            result = (ServiceSelector<Object>)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            LoggerFactory.getLogger(ServiceSelector.class).warn("Cannot load selector {}: Falling back to '{}'", (Object)cls, (Object)dflt);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LoggerFactory.getLogger(ServiceSelector.class).warn("Cannot instantiate selector {}: {}. Falling back to '{}'", new Object[]{cls, e.getMessage(), dflt});
        }
        catch (ClassCastException e) {
            LoggerFactory.getLogger(ServiceSelector.class).warn("Instance of {} is not a selector type. Falling back to '{}'", (Object)cls, (Object)dflt);
        }
        if (result == null) {
            result = i -> dflt;
        }
        return result;
    }
}

