/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.services;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.services.environment.YamlArtifact;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.AasUtils;
import de.iip_ecosphere.platform.support.iip_aas.ApplicationSetup;
import de.iip_ecosphere.platform.support.iip_aas.PlatformAas;
import de.iip_ecosphere.platform.support.iip_aas.json.JsonUtils;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslators;
import de.iip_ecosphere.platform.transport.status.TraceRecord;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.slf4j.LoggerFactory;

public class TraceToAasService
extends AbstractService {
    public static final String VERSION = "0.1.0";
    public static final String SUBMODEL_TRACES = "Traces";
    public static final String SUBMODEL_COMMANDS = "Commands";
    public static final String SUBMODEL_SERVICES = "Services";
    public static final String PROPERTY_SOURCE = "Source";
    public static final String PROPERTY_ACTION = "Action";
    public static final String PROPERTY_TIMESTAMP = "Timestamp";
    public static final String PROPERTY_PAYLOAD_TYPE = "PayloadType";
    public static final String PROPERTY_PAYLOAD = "Payload";
    public static final ValueConverter IDENTITY_CONVERTER = v -> v;
    public static final ValueConverter JSON_CONVERTER = v -> JsonUtils.toJson((Object)v);
    public static final ValueConverter SHORT2INT_CONVERTER = v -> (int)((Short)v).shortValue();
    private static final Map<Class<?>, TypeConverter> DEFAULT_CONVERTERS = new HashMap();
    private static final String PREFIX_GETTER = "get";
    private static final Set<String> METHODS_TO_IGNORE = new HashSet<String>();
    private Map<Class<?>, TypeConverter> converters = new HashMap();
    private Map<String, ParameterConfigurer<?>> paramConfigurers = new HashMap();
    private ApplicationSetup appSetup;
    private YamlArtifact artifact;
    private long timeout = 1200000L;
    private long lastCleanup = System.currentTimeMillis();
    private long cleanupTimeout = 5000L;
    private TraceRecordReceptionCallback callback;

    public TraceToAasService(ApplicationSetup app, YamlService yaml) {
        super(yaml);
        this.converters.putAll(DEFAULT_CONVERTERS);
        this.appSetup = new ApplicationSetup(app);
        this.addParameterConfigurer(new ParameterConfigurer<Long>("timeout", Long.class, TypeTranslators.LONG, t -> {
            this.timeout = t;
        }));
    }

    public TraceToAasService(String serviceId, InputStream ymlFile) {
        this(new YamlConstructionInfo(serviceId, ymlFile));
    }

    private TraceToAasService(YamlConstructionInfo info) {
        this(info.app, info.service);
    }

    public TraceToAasService(YamlArtifact artifact, String serviceId) {
        this(artifact.getApplication(), artifact.getService(serviceId));
        this.artifact = artifact;
    }

    protected void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public ApplicationSetup getApplicationSetup() {
        return this.appSetup;
    }

    protected <T> void addParameterConfigurer(ParameterConfigurer<T> configurer) {
        if (null != configurer) {
            this.paramConfigurers.put(configurer.getName(), configurer);
        }
    }

    protected void addConverter(Class<?> cls, TypeConverter converter) {
        this.converters.put(cls, converter);
    }

    public String getAasId() {
        return AasUtils.fixId((String)("application_" + this.appSetup.getId()));
    }

    public String getAasUrn() {
        return "urn:::AAS:::" + this.getAasId() + "#";
    }

    protected void handleNew(TraceRecord data) {
        try {
            Aas aas = AasPartRegistry.retrieveAas((AasPartRegistry.AasSetup)Starter.getSetup().getAas(), (String)this.getAasUrn());
            Submodel.SubmodelBuilder smBuilder = aas.createSubmodelBuilder(SUBMODEL_TRACES, null);
            SubmodelElementCollection.SubmodelElementCollectionBuilder smcBuilder = smBuilder.createSubmodelElementCollectionBuilder(AasUtils.fixId((String)(data.getSource() + "_" + data.getTimestamp())), true, true);
            smcBuilder.createPropertyBuilder(PROPERTY_SOURCE).setValue(Type.STRING, (Object)data.getSource()).build();
            smcBuilder.createPropertyBuilder(PROPERTY_ACTION).setValue(Type.STRING, (Object)data.getAction()).build();
            smcBuilder.createPropertyBuilder(PROPERTY_TIMESTAMP).setValue(Type.INTEGER, (Object)data.getTimestamp()).build();
            if (null != data.getPayload()) {
                Class<?> cls = data.getPayload().getClass();
                smcBuilder.createPropertyBuilder(PROPERTY_PAYLOAD_TYPE).setValue(Type.STRING, (Object)this.mapPayloadType(cls)).build();
                SubmodelElementCollection.SubmodelElementCollectionBuilder payloadBuilder = smcBuilder.createSubmodelElementCollectionBuilder(PROPERTY_PAYLOAD, false, false);
                for (Method m : cls.getMethods()) {
                    if (!TraceToAasService.isGetter(m)) continue;
                    String field = m.getName().substring(PREFIX_GETTER.length());
                    TypeConverter tConv = this.converters.get(m.getReturnType());
                    if (null != tConv) {
                        try {
                            payloadBuilder.createPropertyBuilder(AasUtils.fixId((String)field)).setValue(tConv.getType(), tConv.convert(m.invoke(data.getPayload(), new Object[0]))).build();
                        }
                        catch (IllegalAccessException | SecurityException | InvocationTargetException e) {
                            LoggerFactory.getLogger(this.getClass()).error("Cannot map value of operation {}/field {} to AAS: {}", new Object[]{m.getName(), field, e.getMessage()});
                        }
                        continue;
                    }
                    if (METHODS_TO_IGNORE.contains(m.getName())) continue;
                    LoggerFactory.getLogger(this.getClass()).warn("Cannot map value of operation {}/field {} to AAS: No converter is defined", (Object)m.getName(), (Object)field);
                }
                payloadBuilder.build();
            }
            smcBuilder.build();
            smBuilder.build();
            this.cleanup(aas);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot obtain AAS {}: {}", (Object)this.getAasUrn(), (Object)e.getMessage());
        }
    }

    protected String mapPayloadType(Class<?> cls) {
        return cls.getName();
    }

    private static boolean isGetter(Method method) {
        int modifier = method.getModifiers();
        boolean pubNonStatic = Modifier.isPublic(modifier) && !Modifier.isStatic(modifier);
        return method.getName().startsWith(PREFIX_GETTER) && method.getParameterCount() == 0 && pubNonStatic;
    }

    protected void cleanup(Aas aas) {
        long now = System.currentTimeMillis();
        if (now - this.lastCleanup > this.cleanupTimeout) {
            long timestamp = now - this.timeout;
            Submodel sm = aas.getSubmodel(SUBMODEL_TRACES);
            ArrayList<SubmodelElement> delete = new ArrayList<SubmodelElement>();
            for (SubmodelElement elt : sm.submodelElements()) {
                SubmodelElementCollection coll;
                Property prop;
                if (!(elt instanceof SubmodelElementCollection) || null == (prop = (coll = (SubmodelElementCollection)elt).getProperty(PROPERTY_TIMESTAMP))) continue;
                try {
                    Object val = prop.getValue();
                    boolean del = false;
                    if (val instanceof Integer) {
                        del = (long)((Integer)val).intValue() < timestamp;
                    } else if (val instanceof Long) {
                        boolean bl = del = (Long)val < timestamp;
                    }
                    if (!del) continue;
                    delete.add(elt);
                }
                catch (ExecutionException executionException) {}
            }
            for (SubmodelElement elt : delete) {
                sm.delete(elt);
            }
            this.lastCleanup = now;
        }
    }

    @Override
    public void setState(ServiceState state) throws ExecutionException {
        switch (state) {
            case STARTING: {
                try {
                    AasFactory factory = AasFactory.getInstance();
                    Aas.AasBuilder aasBuilder = factory.createAasBuilder(this.getAasId(), this.getAasUrn());
                    Submodel.SubmodelBuilder smBuilder = PlatformAas.createNameplate((Aas.AasBuilder)aasBuilder, (ApplicationSetup)this.appSetup);
                    PlatformAas.addSoftwareInfo((Submodel.SubmodelBuilder)smBuilder, (ApplicationSetup)this.appSetup);
                    smBuilder.build();
                    smBuilder = aasBuilder.createSubmodelBuilder(SUBMODEL_COMMANDS, null);
                    this.augmentCommandsSubmodel(smBuilder);
                    smBuilder.build();
                    smBuilder = aasBuilder.createSubmodelBuilder(SUBMODEL_SERVICES, null);
                    this.augmentServicesSubmodel(smBuilder);
                    smBuilder.build();
                    aasBuilder.createSubmodelBuilder(SUBMODEL_TRACES, null).build();
                    List aasList = CollectionUtils.addAll(new ArrayList(), (Object[])new Aas[]{(Aas)aasBuilder.build()});
                    AasPartRegistry.remoteDeploy((AasPartRegistry.AasSetup)Starter.getSetup().getAas(), (List)aasList);
                    this.callback = new TraceRecordReceptionCallback();
                    TransportConnector conn = Transport.createConnector();
                    if (null != conn) {
                        conn.setReceptionCallback("Trace", (ReceptionCallback)this.callback);
                    } else {
                        LoggerFactory.getLogger(this.getClass()).error("No transport setup, will not listen to trace recors.");
                    }
                    super.setState(ServiceState.RUNNING);
                    this.start();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Creating AAS: " + e.getMessage());
                    super.setState(ServiceState.FAILED);
                }
                break;
            }
            case STOPPING: {
                super.setState(state);
                this.stop();
                try {
                    TransportConnector conn = Transport.getConnector();
                    if (null != conn) {
                        conn.detachReceptionCallback("Trace", (ReceptionCallback)this.callback);
                    }
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Detaching transport connector: " + e.getMessage());
                }
                try {
                    Aas aas = AasPartRegistry.retrieveAas((AasPartRegistry.AasSetup)Starter.getSetup().getAas(), (String)this.getAasUrn());
                    aas.delete(aas.getSubmodel(SUBMODEL_TRACES));
                    aas.delete(aas.getSubmodel("TechnicalData"));
                    aas.delete(aas.getSubmodel(SUBMODEL_COMMANDS));
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Cleaning up AAS: " + e.getMessage());
                    super.setState(ServiceState.FAILED);
                }
                super.setState(ServiceState.STOPPED);
                break;
            }
            default: {
                super.setState(state);
            }
        }
    }

    protected void start() {
    }

    protected void stop() {
    }

    private void augmentServicesSubmodel(Submodel.SubmodelBuilder smBuilder) {
        if (null != this.artifact) {
            AasFactory factory = AasFactory.getInstance();
            try {
                Registry reg = factory.obtainRegistry(Starter.getSetup().getAas().getRegistryEndpoint());
                for (YamlService s : this.artifact.getServices()) {
                    String ep = reg.getEndpoint(AasUtils.fixId((String)("service_" + s.getId())));
                    if (null == ep) {
                        ep = "";
                    }
                    smBuilder.createPropertyBuilder(AasUtils.fixId((String)s.getId())).setValue(Type.STRING, (Object)ep).build();
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Building services submodel: {}", (Object)e.getMessage());
            }
        }
    }

    protected void augmentCommandsSubmodel(Submodel.SubmodelBuilder smBuilder) {
    }

    @Override
    public void migrate(String resourceId) throws ExecutionException {
    }

    @Override
    public void update(URI location) throws ExecutionException {
    }

    @Override
    public void switchTo(String targetId) throws ExecutionException {
    }

    @Override
    public ParameterConfigurer<?> getParameterConfigurer(String paramName) {
        return this.paramConfigurers.get(paramName);
    }

    static {
        DEFAULT_CONVERTERS.put(String.class, new TypeConverter(Type.STRING, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Boolean.TYPE, new TypeConverter(Type.BOOLEAN, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Boolean.class, new TypeConverter(Type.BOOLEAN, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Integer.TYPE, new TypeConverter(Type.INTEGER, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Integer.class, new TypeConverter(Type.INTEGER, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Long.TYPE, new TypeConverter(Type.INTEGER, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Long.class, new TypeConverter(Type.INTEGER, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Float.TYPE, new TypeConverter(Type.DOUBLE, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Float.class, new TypeConverter(Type.DOUBLE, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Double.TYPE, new TypeConverter(Type.DOUBLE, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Double.class, new TypeConverter(Type.DOUBLE, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Short.TYPE, new TypeConverter(Type.INTEGER, SHORT2INT_CONVERTER));
        DEFAULT_CONVERTERS.put(Short.class, new TypeConverter(Type.INTEGER, SHORT2INT_CONVERTER));
        DEFAULT_CONVERTERS.put(int[].class, new TypeConverter(Type.STRING, JSON_CONVERTER));
        DEFAULT_CONVERTERS.put(long[].class, new TypeConverter(Type.STRING, JSON_CONVERTER));
        DEFAULT_CONVERTERS.put(float[].class, new TypeConverter(Type.STRING, JSON_CONVERTER));
        DEFAULT_CONVERTERS.put(double[].class, new TypeConverter(Type.STRING, JSON_CONVERTER));
        DEFAULT_CONVERTERS.put(byte[].class, new TypeConverter(Type.STRING, JSON_CONVERTER));
        DEFAULT_CONVERTERS.put(boolean[].class, new TypeConverter(Type.STRING, JSON_CONVERTER));
        METHODS_TO_IGNORE.add("getClass");
    }

    private class TraceRecordReceptionCallback
    implements ReceptionCallback<TraceRecord> {
        private TraceRecordReceptionCallback() {
        }

        public void received(TraceRecord data) {
            new Thread(() -> TraceToAasService.this.handleNew(data)).start();
        }

        public Class<TraceRecord> getType() {
            return TraceRecord.class;
        }
    }

    private static interface ValueConverter {
        public Object convert(Object var1);
    }

    private static class TypeConverter
    implements ValueConverter {
        private ValueConverter conv;
        private Type type;

        private TypeConverter(Type type, ValueConverter conv) {
            this.type = type;
            this.conv = conv;
        }

        @Override
        public Object convert(Object value) {
            return this.conv.convert(value);
        }

        public Type getType() {
            return this.type;
        }
    }

    private static class YamlConstructionInfo {
        private ApplicationSetup app;
        private YamlService service;

        protected YamlConstructionInfo(String serviceId, InputStream ymlFile) {
            YamlArtifact art = YamlArtifact.readFromYamlSafe(ymlFile);
            this.app = art.getApplication();
            this.service = art.getServiceSafe(serviceId);
        }
    }
}

