/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas;

import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;

public class MetricsExtractorRestClient {
    private static final String PROTOCOL = "http://";
    private static final String SIMPLE_ENDPOINT = "simple-meter";
    private static final String TAGGED_ENDPOINT = "tagged-meter";
    private static final String COUNTERS_ENDPOINT = "counters";
    private static final String GAUGES_ENDPOINT = "gauges";
    private static final String TIMERS_ENDPOINT = "timers";
    private static final String CONFIG_MEMORY_BASE_UNIT = "config/memory-base-unit";
    private static final String CONFIG_DISK_BASE_UNIT = "config/disk-base-unit";
    private static final String AREA_HEAP = "area:heap";
    private static final String ID_SURVIVOR_SPACE = "id:PS Survivor Space";
    private static final String ID_OLD_GEN = "id:PS Old Gen";
    private static final String ID_EDEN_SPACE = "id:PS Eden Space";
    private static final String AREA_NONHEAP = "area:nonheap";
    private static final String ID_METASPACE = "id:Metaspace";
    private static final String ID_CODE_CACHE = "id:Code Cache";
    private static final String ID_COMPRESSED_CLASS_SPACE = "id:Compressed Class Space";
    private static final String STATE_RUNNABLE = "state:runnable";
    private static final String STATE_BLOCKED = "state:blocked";
    private static final String STATE_WAITING = "state:waiting";
    private static final String STATE_TIMED_WAITING = "state:timed-waiting";
    private static final String STATE_NEW = "state:new";
    private static final String STATE_TERMINATED = "state:terminated";
    private static final String ID_DIRECT = "id:direct";
    private static final String ID_MAPPED = "id:mapped";
    private static final String LEVEL_WARN = "level:warn";
    private static final String LEVEL_DEBUG = "level:debug";
    private static final String LEVEL_ERROR = "level:error";
    private static final String LEVEL_TRACE = "level:trace";
    private static final String LEVEL_INFO = "level:info";
    private static final String CAUSE = "cause:Metadata GC Threshold";
    private static final String CAUSE_FAILURE = "cause:Allocation Failure";
    private static final String ACTION_MAJOR = "action:end of major GC";
    private static final String ACTION_MINOR = "action:end of minor GC";
    private WebTarget webTarget;

    public MetricsExtractorRestClient(String hostAddr, int portNo) {
        if (hostAddr == null || hostAddr.isEmpty()) {
            throw new IllegalArgumentException("The host address is empty!");
        }
        if (portNo < 0) {
            throw new IllegalArgumentException("Port cannot be a negative number!");
        }
        String uri = PROTOCOL + hostAddr + ":" + portNo;
        this.webTarget = ClientBuilder.newClient().target(uri);
    }

    private String sendGetRequest(String endpoint, String resource, String ... tags) {
        WebTarget request = this.webTarget.path(endpoint).path(resource).queryParam("tag", (Object[])tags);
        Invocation.Builder invocationBuilder = request.request(new String[]{"application/json"});
        try {
            return (String)invocationBuilder.get().readEntity(String.class);
        }
        catch (ProcessingException e) {
            return null;
        }
    }

    private void sendPutRequest(String endpoint, String body) {
        Invocation.Builder invocationBuilder = this.webTarget.path(endpoint).request(new String[]{"application/json"});
        try {
            invocationBuilder.put(Entity.json((Object)body));
        }
        catch (ProcessingException e) {
            throw new IllegalArgumentException("Error code from the server:  " + e.getMessage());
        }
    }

    private void sendDeleteRequest(String endpoint, String resource) {
        Invocation.Builder invocationBuilder = this.webTarget.path(endpoint).path(resource).request(new String[]{"application/json"});
        try {
            invocationBuilder.delete();
        }
        catch (ProcessingException e) {
            throw new IllegalStateException("Error code from the server:  " + e.getMessage());
        }
    }

    public String getJvmBufferCount() {
        return this.getBufferMetric("jvm.buffer.count");
    }

    public String getJvmBufferMemoryUsed() {
        return this.getBufferMetric("jvm.buffer.memory.used");
    }

    public String getJvmBufferTotalCapacity() {
        return this.getBufferMetric("jvm.buffer.memory.used");
    }

    public String getJvmClassesLoaded() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "jvm.classes.loaded", new String[0]);
    }

    public String getJvmClassesUnloaded() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "jvm.classes.unloaded", new String[0]);
    }

    public String getJvmGcLiveDataSize() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "jvm.gc.live.data.size", new String[0]);
    }

    public String getJvmGcMaxDataSize() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "jvm.gc.max.data.size", new String[0]);
    }

    public String getJvmGcMemoryAllocated() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "jvm.gc.memory.allocated", new String[0]);
    }

    public String getJvmGcMemoryPromoted() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "jvm.gc.memory.promoted", new String[0]);
    }

    public String getJvmGcPause() {
        String name = "jvm.gc.pause";
        StringBuilder sb = new StringBuilder();
        String aux = this.sendGetRequest(TAGGED_ENDPOINT, "jvm.gc.pause", CAUSE, ACTION_MAJOR);
        if (aux == null) {
            sb.append("[");
            sb.append("{\"tags\":[\"").append(CAUSE).append("\",\"").append(ACTION_MAJOR).append("\"],");
            sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, "jvm.gc.pause", CAUSE_FAILURE, ACTION_MINOR)).append("}");
            sb.append("]");
        } else {
            sb.append("[");
            sb.append("{\"tags\":[\"").append(CAUSE).append("\",\"").append(ACTION_MAJOR).append("\"],");
            sb.append("\"meter\":").append(aux).append("},");
            sb.append("{\"tags\":[\"").append(CAUSE).append("\",\"").append(ACTION_MINOR).append("\"],");
            sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, "jvm.gc.pause", CAUSE, ACTION_MINOR)).append("}");
            sb.append("]");
        }
        return sb.toString();
    }

    public String getJvmMemoryCommited() {
        return this.getMemoryMetric("jvm.memory.committed");
    }

    public String getJvmMemoryMax() {
        return this.getMemoryMetric("jvm.memory.max");
    }

    public String getJvmMemoryUsed() {
        return this.getMemoryMetric("jvm.memory.used");
    }

    public String getJvmThreadsDaemon() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "jvm.threads.daemon", new String[0]);
    }

    public String getJvmThreadsLive() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "jvm.threads.live", new String[0]);
    }

    public String getJvmThreadsPeak() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "jvm.threads.peak", new String[0]);
    }

    public String getJvmThreadsStates() {
        String name = "jvm.threads.states";
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("{\"tags\":[\"").append(STATE_RUNNABLE).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, "jvm.threads.states", STATE_RUNNABLE)).append("},");
        sb.append("{\"tags\":[\"").append(STATE_BLOCKED).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, "jvm.threads.states", STATE_BLOCKED)).append("},");
        sb.append("{\"tags\":[\"").append(STATE_WAITING).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, "jvm.threads.states", STATE_WAITING)).append("},");
        sb.append("{\"tags\":[\"").append(STATE_TIMED_WAITING).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, "jvm.threads.states", STATE_TIMED_WAITING)).append("},");
        sb.append("{\"tags\":[\"").append(STATE_NEW).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, "jvm.threads.states", STATE_NEW)).append("},");
        sb.append("{\"tags\":[\"").append(STATE_TERMINATED).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, "jvm.threads.states", STATE_TERMINATED)).append("}");
        sb.append("]");
        return sb.toString();
    }

    public String getLogbackEvents() {
        String name = "logback.events";
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("{\"tags\":[\"").append(LEVEL_WARN).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, "logback.events", LEVEL_WARN)).append("},");
        sb.append("{\"tags\":[\"").append(LEVEL_DEBUG).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, "logback.events", LEVEL_DEBUG)).append("},");
        sb.append("{\"tags\":[\"").append(LEVEL_ERROR).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, "logback.events", LEVEL_ERROR)).append("},");
        sb.append("{\"tags\":[\"").append(LEVEL_TRACE).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, "logback.events", LEVEL_TRACE)).append("},");
        sb.append("{\"tags\":[\"").append(LEVEL_INFO).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, "logback.events", LEVEL_INFO)).append("}");
        sb.append("]");
        return sb.toString();
    }

    public String getProcessCpuUsage() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "process.cpu.usage", new String[0]);
    }

    public String getProcessStartTime() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "process.start.time", new String[0]);
    }

    public String getProcessUptime() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "process.uptime", new String[0]);
    }

    public String getSystemCpuCount() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "system.cpu.count", new String[0]);
    }

    public String getSystemCpuUsage() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "system.cpu.usage", new String[0]);
    }

    public String getSystemDiskFree() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "system.disk.free", new String[0]);
    }

    public String getSystemDiskTotal() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "system.disk.total", new String[0]);
    }

    public String getSystemDiskUsable() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "system.disk.usable", new String[0]);
    }

    public String getSystemsDiskUsed() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "system.disk.used", new String[0]);
    }

    public String getSystemMemoryFree() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "system.memory.free", new String[0]);
    }

    public String getSystemMemoryTotal() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "system.memory.total", new String[0]);
    }

    public String getSystemMemoryUsage() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "system.memory.usage", new String[0]);
    }

    public String getSystemMemoryUsed() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "system.memory.used", new String[0]);
    }

    public String getCustomGauge(String name) {
        return this.sendGetRequest(GAUGES_ENDPOINT, name, new String[0]);
    }

    public Object updateCustomGauge(Object[] args) {
        String body = String.valueOf(args[0]);
        this.sendPutRequest(GAUGES_ENDPOINT, body);
        return null;
    }

    public Object deleteCustomGauge(Object[] args) {
        String resource = String.valueOf(args[0]);
        this.sendDeleteRequest(GAUGES_ENDPOINT, resource);
        return null;
    }

    public String getCustomCounter(String name) {
        return this.sendGetRequest(COUNTERS_ENDPOINT, name, new String[0]);
    }

    public Object updateCustomCounter(Object[] args) {
        String body = String.valueOf(args[0]);
        this.sendPutRequest(COUNTERS_ENDPOINT, body);
        return null;
    }

    public Object deleteCustomCounter(Object[] args) {
        String resource = String.valueOf(args[0]);
        this.sendDeleteRequest(COUNTERS_ENDPOINT, resource);
        return null;
    }

    public String getCustomTimer(String name) {
        return this.sendGetRequest(TIMERS_ENDPOINT, name, new String[0]);
    }

    public Object updateCustomTimer(Object[] args) {
        String body = String.valueOf(args[0]);
        this.sendPutRequest(TIMERS_ENDPOINT, body);
        return null;
    }

    public Object deleteCustomTimer(Object[] args) {
        String resource = String.valueOf(args[0]);
        this.sendDeleteRequest(TIMERS_ENDPOINT, resource);
        return null;
    }

    private String getMemoryMetric(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("{\"tags\":[\"").append(AREA_HEAP).append("\",\"").append(ID_SURVIVOR_SPACE).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, name, AREA_HEAP, ID_SURVIVOR_SPACE)).append("},");
        sb.append("{\"tags\":[\"").append(AREA_HEAP).append("\",\"").append(ID_OLD_GEN).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, name, AREA_HEAP, ID_OLD_GEN)).append("},");
        sb.append("{\"tags\":[\"").append(AREA_HEAP).append("\",\"").append(ID_EDEN_SPACE).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, name, AREA_HEAP, ID_EDEN_SPACE)).append("},");
        sb.append("{\"tags\":[\"").append(AREA_NONHEAP).append("\",\"").append(ID_METASPACE).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, name, AREA_NONHEAP, ID_METASPACE)).append("},");
        sb.append("{\"tags\":[\"").append(AREA_NONHEAP).append("\",\"").append(ID_CODE_CACHE).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, name, AREA_NONHEAP, ID_CODE_CACHE)).append("},");
        sb.append("{\"tags\":[\"").append(AREA_NONHEAP).append("\",\"").append(ID_COMPRESSED_CLASS_SPACE).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, name, AREA_NONHEAP, ID_COMPRESSED_CLASS_SPACE)).append("}");
        sb.append("]");
        return sb.toString();
    }

    private String getBufferMetric(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("{\"tags\":[\"").append(ID_DIRECT).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, name, ID_DIRECT)).append("},");
        sb.append("{\"tags\":[\"").append(ID_MAPPED).append("\"],");
        sb.append("\"meter\":").append(this.sendGetRequest(TAGGED_ENDPOINT, name, ID_MAPPED)).append("}");
        sb.append("]");
        return sb.toString();
    }

    public Object setMemoryBaseUnit(Object[] args) {
        String body = String.valueOf(args[0]);
        this.sendPutRequest(CONFIG_MEMORY_BASE_UNIT, body);
        return null;
    }

    public Object setDiskBaseUnit(Object[] args) {
        String body = String.valueOf(args[0]);
        this.sendPutRequest(CONFIG_DISK_BASE_UNIT, body);
        return null;
    }

    public String getGaugeList() {
        return this.sendGetRequest(GAUGES_ENDPOINT, "", new String[0]);
    }

    public String getCounterList() {
        return this.sendGetRequest(COUNTERS_ENDPOINT, "", new String[0]);
    }

    public String getTimerList() {
        return this.sendGetRequest(TIMERS_ENDPOINT, "", new String[0]);
    }

    public String getTaggedMeterList() {
        return this.sendGetRequest(TAGGED_ENDPOINT, "", new String[0]);
    }

    public String getSimpleMeterList() {
        return this.sendGetRequest(SIMPLE_ENDPOINT, "", new String[0]);
    }
}

