/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas;

import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MeterType;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsAasConstructionBundle;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsExtractorRestClient;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.stream.JsonParsingException;
import org.slf4j.LoggerFactory;

public class MetricsAasConstructor {
    private static Map<String, TransportConnector> conns = new HashMap<String, TransportConnector>();
    private static Map<String, JsonObjectHolder> holders = new HashMap<String, JsonObjectHolder>();

    public static void addMetricsToBundle(MetricsAasConstructionBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("The bundle is null!");
        }
        MetricsAasConstructor.addMetricsToAasSubmodel(bundle.getSubmodelBuilder(), bundle.getInvocablesCreator(), bundle.getFilter(), bundle.getNameMapper());
        MetricsAasConstructor.addMetricsProtocols(bundle.getProtocolBuilder(), bundle.getClient(), bundle.getFilter(), bundle.getNameMapper());
    }

    public static void addProviderMetricsToAasSubmodel(SubmodelElementContainerBuilder smBuilder, InvocablesCreator iCreator, Predicate<String> filter, Function<String, String> nameMapper) {
        smBuilder.createPropertyBuilder("gaugelist").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("gaugelist")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("counterlist").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("counterlist")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("timerlist").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("timerlist")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("taggedmeterlist").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("taggedmeterlist")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("simplemeterlist").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("simplemeterlist")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("Storage_Free").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("Storage_Free")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("Storage_Capacity").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("Storage_Capacity")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("Storage_Usable").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("Storage_Usable")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("Allocated_Storage").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("Allocated_Storage")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("Memory_Free").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("Memory_Free")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("Memory_Capacity").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("Memory_Capacity")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("Allocated_Memory").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("Allocated_Memory")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("Memory_Used").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("Memory_Used")), InvocablesCreator.READ_ONLY).build();
    }

    public static void clear() {
        for (Map.Entry<String, TransportConnector> ent : conns.entrySet()) {
            try {
                ent.getValue().disconnect();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(MetricsAasConstructor.class).error("Cannot disconnect transport connector for id " + ent.getKey() + ": " + e.getMessage());
            }
        }
        conns.clear();
        holders.clear();
    }

    private static TransportConnector getTransportConnector(String channel, TransportSetup setup) {
        TransportConnector conn = conns.get(channel);
        if (null == conn && !conns.containsKey(channel)) {
            conn = TransportFactory.createConnector();
            try {
                conn.connect(setup.createParameter());
                conn.setReceptionCallback(channel, (ReceptionCallback)new MetricsReceptionCallback());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(MetricsAasConstructor.class).error("Cannot create connector: " + e.getMessage());
            }
            conns.put(channel, conn);
        }
        return conn;
    }

    private static JsonObjectHolder getHolder(String id, String channel, TransportSetup setup) {
        MetricsAasConstructor.getTransportConnector(channel, setup);
        JsonObjectHolder result = holders.get(id);
        if (null == result) {
            result = new JsonObjectHolder();
            holders.put(id, result);
        }
        return result;
    }

    public static boolean containsMetrics(SubmodelElementCollection sub) {
        return sub.getElement("Storage_Free") != null;
    }

    public static void addProviderMetricsToAasSubmodel(SubmodelElementContainerBuilder smBuilder, Predicate<String> filter, String channel, String id, TransportSetup setup) {
        smBuilder.createPropertyBuilder("Storage_Free").setType(Type.STRING).bind((Supplier)new MeterGetter(channel, id, setup, "system.disk.free"), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("Storage_Capacity").setType(Type.STRING).bind((Supplier)new MeterGetter(channel, id, setup, "system.disk.total"), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("Storage_Usable").setType(Type.STRING).bind((Supplier)new MeterGetter(channel, id, setup, "system.disk.usable"), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("Allocated_Storage").setType(Type.STRING).bind((Supplier)new MeterGetter(channel, id, setup, "system.disk.used"), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("Memory_Free").setType(Type.STRING).bind((Supplier)new MeterGetter(channel, id, setup, "system.memory.free"), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("Memory_Capacity").setType(Type.STRING).bind((Supplier)new MeterGetter(channel, id, setup, "system.memory.total"), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("Allocated_Memory").setType(Type.STRING).bind((Supplier)new MeterGetter(channel, id, setup, "system.memory.usage"), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("Memory_Used").setType(Type.STRING).bind((Supplier)new MeterGetter(channel, id, setup, "system.memory.used"), InvocablesCreator.READ_ONLY).build();
    }

    public static void removeProviderMetricsFromAasSubmodel(SubmodelElementCollection sub) {
        sub.deleteElement("gaugelist");
        sub.deleteElement("counterlist");
        sub.deleteElement("timerlist");
        sub.deleteElement("taggedmeterlist");
        sub.deleteElement("simplemeterlist");
        sub.deleteElement("Storage_Free");
        sub.deleteElement("Storage_Capacity");
        sub.deleteElement("Storage_Usable");
        sub.deleteElement("Allocated_Storage");
        sub.deleteElement("Memory_Free");
        sub.deleteElement("Memory_Capacity");
        sub.deleteElement("Allocated_Memory");
        sub.deleteElement("Memory_Used");
    }

    public static void addMetricsToAasSubmodel(SubmodelElementContainerBuilder smBuilder, InvocablesCreator iCreator, Predicate<String> filter, Function<String, String> nameMapper) {
        smBuilder.createPropertyBuilder("jvmbuffercount").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmbuffercount")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmbuffermemoryused").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmbuffermemoryused")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmbuffertotalcapacity").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmbuffertotalcapacity")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmclassesloaded").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmclassesloaded")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmclassesunloaded").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmclassesunloaded")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmgclivedatasize").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmgclivedatasize")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmgcmaxdatasize").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmgcmaxdatasize")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmgcmemoryallocated").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmgcmemoryallocated")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmgcmemorypromoted").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmgcmemorypromoted")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmgcpause").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmgcpause")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmmemorycommitted").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmmemorycommitted")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmmemorymax").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmmemorymax")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmmemoryused").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmmemoryused")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmthreadsdaemon").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmthreadsdaemon")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmthreadslive").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmthreadslive")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmthreadspeak").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmthreadspeak")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("jvmthreadsstates").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("jvmthreadsstates")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("logbackevents").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("logbackevents")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("processcpuusage").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("processcpuusage")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("processstarttime").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("processstarttime")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("processuptime").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("processuptime")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("systemcpucount").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("systemcpucount")), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("systemcpuusage").setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply("systemcpuusage")), InvocablesCreator.READ_ONLY).build();
        MetricsAasConstructor.addProviderMetricsToAasSubmodel(smBuilder, iCreator, filter, nameMapper);
        smBuilder.createOperationBuilder("setmemorybaseunit").setInvocable(iCreator.createInvocable(nameMapper.apply("setmemorybaseunit"))).addInputVariable("body", Type.STRING).build();
        smBuilder.createOperationBuilder("setdiskbaseunit").setInvocable(iCreator.createInvocable(nameMapper.apply("setdiskbaseunit"))).addInputVariable("body", Type.STRING).build();
    }

    public static void addMetricsProtocols(ProtocolServerBuilder pBuilder, MetricsExtractorRestClient client, Predicate<String> filter, Function<String, String> nameMapper) {
        pBuilder.defineProperty(nameMapper.apply("gaugelist"), () -> client.getGaugeList(), null);
        pBuilder.defineProperty(nameMapper.apply("counterlist"), () -> client.getCounterList(), null);
        pBuilder.defineProperty(nameMapper.apply("timerlist"), () -> client.getTimerList(), null);
        pBuilder.defineProperty(nameMapper.apply("taggedmeterlist"), () -> client.getTaggedMeterList(), null);
        pBuilder.defineProperty(nameMapper.apply("simplemeterlist"), () -> client.getSimpleMeterList(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmbuffercount"), () -> client.getJvmBufferCount(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmbuffermemoryused"), () -> client.getJvmBufferMemoryUsed(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmbuffertotalcapacity"), () -> client.getJvmBufferTotalCapacity(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmclassesloaded"), () -> client.getJvmClassesLoaded(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmclassesunloaded"), () -> client.getJvmClassesUnloaded(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmgclivedatasize"), () -> client.getJvmGcLiveDataSize(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmgcmaxdatasize"), () -> client.getJvmGcMaxDataSize(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmgcmemoryallocated"), () -> client.getJvmGcMemoryAllocated(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmgcmemorypromoted"), () -> client.getJvmGcMemoryPromoted(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmgcpause"), () -> client.getJvmGcPause(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmmemorycommitted"), () -> client.getJvmMemoryCommited(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmmemorymax"), () -> client.getJvmMemoryMax(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmmemoryused"), () -> client.getJvmMemoryUsed(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmthreadsdaemon"), () -> client.getJvmThreadsDaemon(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmthreadslive"), () -> client.getJvmThreadsLive(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmthreadspeak"), () -> client.getJvmThreadsPeak(), null);
        pBuilder.defineProperty(nameMapper.apply("jvmthreadsstates"), () -> client.getJvmThreadsStates(), null);
        pBuilder.defineProperty(nameMapper.apply("logbackevents"), () -> client.getLogbackEvents(), null);
        pBuilder.defineProperty(nameMapper.apply("processcpuusage"), () -> client.getProcessCpuUsage(), null);
        pBuilder.defineProperty(nameMapper.apply("processstarttime"), () -> client.getProcessStartTime(), null);
        pBuilder.defineProperty(nameMapper.apply("processuptime"), () -> client.getProcessUptime(), null);
        pBuilder.defineProperty(nameMapper.apply("systemcpucount"), () -> client.getSystemCpuCount(), null);
        pBuilder.defineProperty(nameMapper.apply("systemcpuusage"), () -> client.getSystemCpuUsage(), null);
        pBuilder.defineProperty(nameMapper.apply("Storage_Free"), () -> client.getSystemDiskFree(), null);
        pBuilder.defineProperty(nameMapper.apply("Storage_Capacity"), () -> client.getSystemDiskTotal(), null);
        pBuilder.defineProperty(nameMapper.apply("Storage_Usable"), () -> client.getSystemDiskUsable(), null);
        pBuilder.defineProperty(nameMapper.apply("Allocated_Storage"), () -> client.getSystemsDiskUsed(), null);
        pBuilder.defineProperty(nameMapper.apply("Memory_Free"), () -> client.getSystemMemoryFree(), null);
        pBuilder.defineProperty(nameMapper.apply("Memory_Capacity"), () -> client.getSystemMemoryTotal(), null);
        pBuilder.defineProperty(nameMapper.apply("Allocated_Memory"), () -> client.getSystemMemoryUsage(), null);
        pBuilder.defineProperty(nameMapper.apply("Memory_Used"), () -> client.getSystemMemoryUsed(), null);
        pBuilder.defineOperation(nameMapper.apply("setmemorybaseunit"), args -> client.setMemoryBaseUnit((Object[])args));
        pBuilder.defineOperation(nameMapper.apply("setdiskbaseunit"), args -> client.setDiskBaseUnit((Object[])args));
    }

    public static void addMetricsProtocols(ProtocolServerBuilder pBuilder, MetricsProvider provider, Predicate<String> filter, Function<String, String> nameMapper) {
        pBuilder.defineProperty(nameMapper.apply("gaugelist"), () -> provider.getCustomGaugeList(), null);
        pBuilder.defineProperty(nameMapper.apply("counterlist"), () -> provider.getCustomCounterList(), null);
        pBuilder.defineProperty(nameMapper.apply("timerlist"), () -> provider.getCustomTimerList(), null);
        pBuilder.defineProperty(nameMapper.apply("taggedmeterlist"), () -> provider.getTaggedMeterList(), null);
        pBuilder.defineProperty(nameMapper.apply("simplemeterlist"), () -> provider.getSimpleMeterList(), null);
        pBuilder.defineProperty(nameMapper.apply("Storage_Free"), () -> MetricsAasConstructor.getMeter(provider, "system.disk.free"), null);
        pBuilder.defineProperty(nameMapper.apply("Storage_Capacity"), () -> MetricsAasConstructor.getMeter(provider, "system.disk.total"), null);
        pBuilder.defineProperty(nameMapper.apply("Storage_Usable"), () -> MetricsAasConstructor.getMeter(provider, "system.disk.usable"), null);
        pBuilder.defineProperty(nameMapper.apply("Allocated_Storage"), () -> MetricsAasConstructor.getMeter(provider, "system.disk.used"), null);
        pBuilder.defineProperty(nameMapper.apply("Memory_Free"), () -> MetricsAasConstructor.getMeter(provider, "system.memory.free"), null);
        pBuilder.defineProperty(nameMapper.apply("Memory_Capacity"), () -> MetricsAasConstructor.getMeter(provider, "system.memory.total"), null);
        pBuilder.defineProperty(nameMapper.apply("Allocated_Memory"), () -> MetricsAasConstructor.getMeter(provider, "system.memory.usage"), null);
        pBuilder.defineProperty(nameMapper.apply("Memory_Used"), () -> MetricsAasConstructor.getMeter(provider, "system.memory.used"), null);
    }

    private static String getMeter(MetricsProvider provider, String name) {
        String result;
        try {
            result = provider.getMeter(name, MetricsProvider.EMPTY_TAGS);
        }
        catch (IllegalArgumentException e) {
            result = null;
        }
        return result;
    }

    public static void addCustomMetric(MetricsAasConstructionBundle bundle, String name, MeterType type) {
        SubmodelElementContainerBuilder smBuilder = bundle.getSubmodelBuilder();
        InvocablesCreator iCreator = bundle.getInvocablesCreator();
        ProtocolServerBuilder pBuilder = bundle.getProtocolBuilder();
        MetricsExtractorRestClient client = bundle.getClient();
        Function<String, String> nameMapper = bundle.getNameMapper();
        MetricsAasConstructor.addCustomMetricToSubmodel(smBuilder, iCreator, name, type, nameMapper);
        MetricsAasConstructor.addCustomMetricProtocols(pBuilder, client, name, type, nameMapper);
    }

    public static void addCustomMetricToSubmodel(SubmodelElementContainerBuilder smBuilder, InvocablesCreator iCreator, String name, MeterType type, Function<String, String> nameMapper) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name is null or is empty!");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type is null!");
        }
        smBuilder.createPropertyBuilder(name).setType(Type.STRING).bind(iCreator.createGetter(nameMapper.apply(name)), InvocablesCreator.READ_ONLY).build();
        smBuilder.createOperationBuilder("update" + name).setInvocable(iCreator.createInvocable(nameMapper.apply("update" + name))).addInputVariable("body", Type.STRING).build();
        smBuilder.createOperationBuilder("delete" + name).setInvocable(iCreator.createInvocable(nameMapper.apply("delete" + name))).build();
    }

    public static void addCustomMetricProtocols(ProtocolServerBuilder pBuilder, MetricsExtractorRestClient client, String name, MeterType type, Function<String, String> nameMapper) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name is null or is empty!");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type is null!");
        }
        Object[] deleteArg = new Object[]{name};
        switch (type) {
            case COUNTER: {
                pBuilder.defineProperty(nameMapper.apply(name), () -> client.getCustomCounter(name), null);
                pBuilder.defineOperation(nameMapper.apply("update" + name), args -> client.updateCustomCounter((Object[])args));
                pBuilder.defineOperation(nameMapper.apply("delete" + name), args -> client.deleteCustomCounter(deleteArg));
                break;
            }
            case GAUGE: {
                pBuilder.defineProperty(nameMapper.apply(name), () -> client.getCustomGauge(name), null);
                pBuilder.defineOperation(nameMapper.apply("update" + name), args -> client.updateCustomGauge((Object[])args));
                pBuilder.defineOperation(nameMapper.apply("delete" + name), args -> client.deleteCustomGauge(deleteArg));
                break;
            }
            case TIMER: {
                pBuilder.defineProperty(nameMapper.apply(name), () -> client.getCustomTimer(name), null);
                pBuilder.defineOperation(nameMapper.apply("update" + name), args -> client.updateCustomTimer((Object[])args));
                pBuilder.defineOperation(nameMapper.apply("delete" + name), args -> client.deleteCustomTimer(deleteArg));
                break;
            }
        }
    }

    private static class MeterGetter
    implements Supplier<Object>,
    Serializable {
        private static final long serialVersionUID = 2294254606334816252L;
        private String name;
        private String id;
        private String channel;
        private TransportSetup setup;

        private MeterGetter(String channel, String id, TransportSetup setup, String name) {
            this.id = id;
            this.name = name;
            this.channel = channel;
            this.setup = setup;
        }

        @Override
        public Object get() {
            return MetricsAasConstructor.getHolder(this.id, this.channel, this.setup).getMeter(this.name);
        }
    }

    private static class ListGetter
    implements Supplier<Object>,
    Serializable {
        private static final long serialVersionUID = -4387599926801687791L;
        private String name;
        private String id;
        private String channel;
        private TransportSetup setup;

        private ListGetter(String channel, String id, TransportSetup setup, String name) {
            this.id = id;
            this.name = name;
            this.channel = channel;
            this.setup = setup;
        }

        @Override
        public Object get() {
            return MetricsAasConstructor.getHolder(this.id, this.channel, this.setup).getList(this.name);
        }
    }

    private static class MetricsReceptionCallback
    implements ReceptionCallback<String> {
        public void received(String data) {
            try {
                JsonObjectHolder holder;
                JsonObject obj = Json.createReader((Reader)new StringReader(data)).readObject();
                String id = obj.getString("id");
                if (null != id && null != (holder = (JsonObjectHolder)holders.get(id))) {
                    holder.obj = obj;
                }
            }
            catch (JsonParsingException e) {
                LoggerFactory.getLogger(MetricsAasConstructor.class).error("Cannot parse JSON: " + e.getMessage() + " " + data);
            }
        }

        public Class<String> getType() {
            return String.class;
        }
    }

    private static class JsonObjectHolder {
        private JsonObject obj;

        private JsonObjectHolder() {
        }

        public String getList(String name) {
            JsonArray array;
            String result = "";
            if (null != this.obj && null != (array = this.obj.getJsonArray(name))) {
                result = array.toString();
            }
            return result;
        }

        public String getMeter(String name) {
            JsonObject meter;
            JsonObject meters;
            String result = "";
            if (null != this.obj && null != (meters = this.obj.getJsonObject("meters")) && null != (meter = meters.getJsonObject(name))) {
                result = meter.toString();
            }
            return result;
        }
    }
}

