/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation;

import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.CounterRepresentation;
import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.GaugeRepresentation;
import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.TimerRepresentation;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.stream.JsonParsingException;

public abstract class MeterRepresentation
implements Meter {
    private static final String NON_VALID_JSON = "JsonObject does not map a valid Meter!";
    private Meter.Id id;

    protected MeterRepresentation(JsonObject object, Meter.Type type, String ... tags) {
        if (object == null) {
            throw new IllegalArgumentException("The Object is null!");
        }
        try {
            String baseUnit = object.isNull("baseUnit") ? null : object.getString("baseUnit");
            String description = object.isNull("description") ? null : object.getString("description");
            this.id = new Meter.Id(object.getString("name"), MeterRepresentation.extractTagsMap(tags), baseUnit, description, type);
        }
        catch (ClassCastException | NullPointerException ex) {
            throw new IllegalArgumentException(NON_VALID_JSON, ex);
        }
    }

    protected MeterRepresentation(String name, Meter.Type type) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or null");
        }
        this.id = new Meter.Id(name, Tags.of(new ArrayList()), null, null, type);
    }

    private static Tags extractTagsMap(String ... tags) {
        ArrayList<ImmutableTag> tagList = new ArrayList<ImmutableTag>();
        try {
            for (String tag : tags) {
                String[] aux = tag.split(":");
                if (aux[0].equals("") || aux[1].equals("")) {
                    throw new IllegalArgumentException(NON_VALID_JSON);
                }
                tagList.add(new ImmutableTag(aux[0], aux[1]));
            }
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            throw new IllegalArgumentException(NON_VALID_JSON, aiobe);
        }
        return Tags.of(tagList);
    }

    public Meter.Id getId() {
        return this.id;
    }

    public abstract Iterable<Measurement> measure();

    public abstract JsonObject getUpdater();

    public static Meter parseMeter(String json, String ... tags) {
        try {
            return MeterRepresentation.parseMeter(Json.createReader((Reader)new StringReader(json)).readObject(), tags);
        }
        catch (JsonParsingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static Meter parseMeter(JsonObject object, String ... tags) {
        Timer result = null;
        boolean valueFound = false;
        boolean countFound = false;
        boolean totalTimeFound = false;
        JsonArray measurements = object.getJsonArray("measurements");
        if (null != measurements) {
            for (int i = 0; i < measurements.size(); ++i) {
                JsonObject measurement = measurements.getJsonObject(i);
                if (null == measurement) continue;
                String statistics = measurement.getString("statistic");
                valueFound = Statistic.VALUE.name().equals(statistics);
                countFound = Statistic.COUNT.name().equals(statistics);
                totalTimeFound = Statistic.TOTAL_TIME.name().equals(statistics);
            }
        }
        if (totalTimeFound && countFound) {
            result = TimerRepresentation.parseTimer(object, tags);
        } else if (countFound) {
            result = CounterRepresentation.parseCounter(object, tags);
        } else if (valueFound) {
            result = GaugeRepresentation.parseGauge(object, tags);
        } else {
            throw new IllegalArgumentException("Invalid meter JSON: " + object);
        }
        return result;
    }
}

